/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class KEYRecordTest
extends TestCase {
    public void test_ctor_0arg() throws UnknownHostException {
        KEYRecord ar = new KEYRecord();
        KEYRecordTest.assertNull((Object)ar.getName());
        KEYRecordTest.assertEquals((int)0, (int)ar.getType());
        KEYRecordTest.assertEquals((int)0, (int)ar.getDClass());
        KEYRecordTest.assertEquals((long)0L, (long)ar.getTTL());
        KEYRecordTest.assertEquals((int)0, (int)ar.getAlgorithm());
        KEYRecordTest.assertEquals((int)0, (int)ar.getFlags());
        KEYRecordTest.assertEquals((int)0, (int)ar.getFootprint());
        KEYRecordTest.assertEquals((int)0, (int)ar.getProtocol());
        KEYRecordTest.assertNull((Object)ar.getKey());
    }

    public void test_getObject() {
        KEYRecord ar = new KEYRecord();
        Record r = ar.getObject();
        KEYRecordTest.assertTrue((boolean)(r instanceof KEYRecord));
    }

    public void test_ctor_7arg() throws TextParseException {
        Name n = Name.fromString("My.Absolute.Name.");
        Name r = Name.fromString("My.Relative.Name");
        byte[] key = new byte[]{0, 1, 3, 5, 7, 9};
        KEYRecord kr = new KEYRecord(n, 1, 9388L, 38962, 18, 103, key);
        KEYRecordTest.assertEquals((Object)n, (Object)kr.getName());
        KEYRecordTest.assertEquals((int)25, (int)kr.getType());
        KEYRecordTest.assertEquals((int)1, (int)kr.getDClass());
        KEYRecordTest.assertEquals((long)9388L, (long)kr.getTTL());
        KEYRecordTest.assertEquals((int)38962, (int)kr.getFlags());
        KEYRecordTest.assertEquals((int)18, (int)kr.getProtocol());
        KEYRecordTest.assertEquals((int)103, (int)kr.getAlgorithm());
        KEYRecordTest.assertTrue((boolean)Arrays.equals(key, kr.getKey()));
        try {
            new KEYRecord(r, 1, 9388L, 38962, 18, 103, key);
            KEYRecordTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_Protocol_string() {
        KEYRecordTest.assertEquals((String)"DNSSEC", (String)KEYRecord.Protocol.string(3));
        KEYRecordTest.assertEquals((String)"254", (String)KEYRecord.Protocol.string(254));
        try {
            KEYRecord.Protocol.string(-1);
            KEYRecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            KEYRecord.Protocol.string(256);
            KEYRecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Protocol_value() {
        KEYRecordTest.assertEquals((int)4, (int)KEYRecord.Protocol.value("IPSEC"));
        KEYRecordTest.assertEquals((int)254, (int)KEYRecord.Protocol.value("254"));
        KEYRecordTest.assertEquals((int)-1, (int)KEYRecord.Protocol.value("-2"));
        KEYRecordTest.assertEquals((int)-1, (int)KEYRecord.Protocol.value("256"));
    }

    public void test_Flags_value() {
        KEYRecordTest.assertEquals((int)-1, (int)KEYRecord.Flags.value("-2"));
        KEYRecordTest.assertEquals((int)0, (int)KEYRecord.Flags.value("0"));
        KEYRecordTest.assertEquals((int)43829, (int)KEYRecord.Flags.value("43829"));
        KEYRecordTest.assertEquals((int)65535, (int)KEYRecord.Flags.value("65535"));
        KEYRecordTest.assertEquals((int)-1, (int)KEYRecord.Flags.value("65536"));
        KEYRecordTest.assertEquals((int)4096, (int)KEYRecord.Flags.value("EXTEND"));
        KEYRecordTest.assertEquals((int)-1, (int)KEYRecord.Flags.value("NOT_A_VALID_NAME"));
        KEYRecordTest.assertEquals((int)33056, (int)KEYRecord.Flags.value("NOAUTH|ZONE|FLAG10"));
        KEYRecordTest.assertEquals((int)-1, (int)KEYRecord.Flags.value("NOAUTH|INVALID_NAME|FLAG10"));
        KEYRecordTest.assertEquals((int)0, (int)KEYRecord.Flags.value("|"));
    }

    public void test_rdataFromString() throws IOException, TextParseException {
        KEYRecord kr = new KEYRecord();
        Tokenizer st = new Tokenizer("NOAUTH|ZONE|FLAG10 EMAIL RSASHA1 AQIDBAUGBwgJ");
        kr.rdataFromString(st, null);
        KEYRecordTest.assertEquals((int)33056, (int)kr.getFlags());
        KEYRecordTest.assertEquals((int)2, (int)kr.getProtocol());
        KEYRecordTest.assertEquals((int)5, (int)kr.getAlgorithm());
        KEYRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, kr.getKey()));
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|NOKEY|FLAG10 TLS ECC");
        kr.rdataFromString(st, null);
        KEYRecordTest.assertEquals((int)49184, (int)kr.getFlags());
        KEYRecordTest.assertEquals((int)1, (int)kr.getProtocol());
        KEYRecordTest.assertEquals((int)4, (int)kr.getAlgorithm());
        KEYRecordTest.assertNull((Object)kr.getKey());
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|ZONE|JUNK EMAIL RSASHA1 AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            KEYRecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|ZONE RSASHA1 ECC AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            KEYRecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|ZONE EMAIL ZONE AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            KEYRecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }
}

