<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<table class="tableWidth tableFont">
<tr>
<td><div class="bgMonthAndYearWidget" month="${dataMap['month']}" year="${dataMap['year']}" query="?action=${action}&module=${module}&mid=${mid}"></div></td>
<td style="text-align: right;"><h2 style="margin: 0px;">Текущий лимит: <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['limit']}"/></h2></td>
</tr>
</table>


<table class="table tableWidth tableFont contractLimit">
	<thead>
	  <tr>
		<td>Сумма</td>
		<td>Дата понижения</td>
		<td>Дата восстановления</td>
		<td>Состояние</td>
	  </tr>
	</thead>
	<c:if test="${not empty dataMap['moveList']}">
	<tbody>
	<c:forEach var="item" items="${dataMap['moveList']}">
		<tr>
			<td>${item.summ }</td>
			<td><fmt:formatDate value="${item.date1.time }" pattern="dd.MM.yyyy"/></td>		
			<td><fmt:formatDate value="${item.date2.time }" pattern="dd.MM.yyyy"/></td>
			<td nowrap="nowrap">			
				<c:choose>
					<c:when test="${item.status==0 }">не погашено</c:when>
					<c:when test="${item.status==1 }">частично погашено</c:when>
					<c:when test="${item.status==2 }">погашено</c:when>
					<c:otherwise>просрочено</c:otherwise>
				</c:choose>
			</td>
		</tr>		
	</c:forEach>
	</tbody>			
	</c:if>
</table>
<em class="comment">Лимит будет восстановлен при поступлении суммы равной или большей суммы понижения, а понижение лимита помечено как погашено.<br/>
Если понижение лимита по истечении срока не погашено, оно помечается как просрочено и лимит восстанавливается к прежнему значению.
</em>

<c:if test="${not empty dataMap['contractLimitParameters']}">
<div style="margin-top: 30px;">
	<form method="post" action="">
		<input type="hidden" name="action" value="${action}"/>
		<input type="hidden" name="operation" value="lowLimit"/>
		<input type="hidden" name="rand" value="${ dataMap['rand']}"/>
		<table class="filter">
		<tr>
			<td>Понизить лимит на сумму:</td>
			<td><input type="text" name="summ" size="6"/></td>
			<td>сроком на </td>
			<td>
				<c:set var="map" value="${dataMap['dMap']}" />
				<select name="days"><c:forEach var="item" begin="${dataMap['contractLimitParameters'].minDays}" end="${dataMap['contractLimitParameters'].maxDays}"><option value="${item}">${item} ${map[item]}</option></c:forEach></select>
			</td>
			<td><input type="submit" value="Понизить" style="margin-left: 15px;"></td>
		</tr>
	</table>
	</form>
<div style="margin-top: 10px;">Сумма понижения может быть 
от <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['contractLimitParameters'].minSumm}"/> 
до <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['contractLimitParameters'].maxSumm}"/>. 
Лимит может быть понижен до <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['contractLimitParameters'].minLimit}"/>.</div>
</div>	
</c:if>
<c:if test="${not empty dataMap['message']}"><div style="margin-top: 10px; font-style: italic;">${dataMap['message']}</div></c:if>
