/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.service.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;

public class ServiceDao
extends AbstractIdDao<Service>
implements Recyclable {
    private static final Logger logger = Logger.getLogger(ServiceDao.class);
    private PreparedStatement insertPS;
    private PreparedStatement updatePS;
    private PreparedStatement updateDeviceStatePS;

    public ServiceDao(Connection con) {
        super(con, 0, "inv_service");
    }

    public List<Service> list(int contractId, int productId) throws BGException {
        return super.list("contractId=? AND productId=?", null, contractId, productId);
    }

    public List<Service> list(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date timeFromIntersect, Date timeToIntersect, boolean needNonActive, boolean titleLoad) throws BGException {
        try {
            ArrayList<Service> result = new ArrayList<Service>();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT service.*, spec.title FROM ").append(this.tableName).append(" AS service");
            sb.append(" LEFT JOIN inv_service_spec as spec ON service.serviceSpecId=spec.id ");
            sb.append(" WHERE service.contractId=? AND (? OR service.accountId=?) AND ((? OR spec.moduleId=?) OR (? OR spec.moduleId=0))");
            sb.append(" AND (? OR service.timeFrom>=?)");
            sb.append(" AND (? OR service.timeTo<=?)");
            sb.append(" AND (? OR service.timeFrom IS NULL OR service.timeFrom<=?)");
            sb.append(" AND (? OR service.timeTo IS NULL OR service.timeTo>=?)");
            if (!needNonActive) {
                sb.append("\n AND (service.timeTo IS NULL OR service.timeFrom<service.timeTo)");
            }
            sb.append("\n ORDER BY service.timeFrom");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, contractId);
            ps.setBoolean(2, accountId <= 0);
            ps.setInt(3, accountId);
            ps.setBoolean(4, moduleId >= 0);
            ps.setInt(5, moduleId);
            ps.setBoolean(6, kernel);
            ps.setBoolean(7, timeFrom == null);
            ps.setTimestamp(8, TimeUtils.convertDateToTimestamp(timeFrom));
            ps.setBoolean(9, timeTo == null);
            ps.setTimestamp(10, TimeUtils.convertDateToTimestamp(timeTo));
            ps.setBoolean(11, timeToIntersect == null);
            ps.setTimestamp(12, TimeUtils.convertDateToTimestamp(timeToIntersect));
            ps.setBoolean(13, timeFromIntersect == null);
            ps.setTimestamp(14, TimeUtils.convertDateToTimestamp(timeFromIntersect));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected Service getFromRS(ResultSet rs) throws SQLException, BGException {
        Service result = new Service();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contractId"));
        result.setAccountId(rs.getInt("accountId"));
        result.setProductId(rs.getInt("productId"));
        result.setServiceSpecId(rs.getInt("serviceSpecId"));
        result.setTimeFrom(TimeUtils.convertTimestampToDate(rs.getTimestamp("timeFrom")));
        result.setTimeTo(TimeUtils.convertTimestampToDate(rs.getTimestamp("timeTo")));
        result.setDeviceState(rs.getShort("deviceState"));
        return result;
    }

    @Override
    protected void updateImpl(Service b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getId() <= 0) {
            ps = this.insertPS;
            if (ps == null) {
                ps = this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (contractId, accountId, productId, serviceSpecId, timeFrom, timeTo, deviceState) VALUES (?,?,?,?,?,?,?)");
            }
            ps.setInt(1, b2.getContractId());
            ps.setInt(2, b2.getAccountId());
            ps.setInt(3, b2.getProductId());
            ps.setInt(4, b2.getServiceSpecId());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestamp(b2.getTimeFrom()));
            ps.setTimestamp(6, TimeUtils.convertDateToTimestamp(b2.getTimeTo()));
            ps.setShort(7, b2.getDeviceState());
        } else {
            ps = this.updatePS;
            if (ps == null) {
                ps = this.updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET timeFrom=?, timeTo=? WHERE id=?");
            }
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp(b2.getTimeFrom()));
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp(b2.getTimeTo()));
            ps.setInt(3, b2.getId());
        }
        ps.executeUpdate();
    }

    public void updateDeviceState(int contractId, int tvAccountId, int serviceId, short deviceState) throws BGException {
        try {
            PreparedStatement ps = this.updateDeviceStatePS;
            if (ps == null) {
                ps = this.updateDeviceStatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=? WHERE contractId=? AND id=? AND deviceState!=?");
            }
            ps.setShort(1, deviceState);
            ps.setInt(2, contractId);
            ps.setInt(3, serviceId);
            ps.setShort(4, deviceState);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void delete(int contractId, int id) throws BGException {
        this.delete("contractId=? AND id=?", contractId, id);
    }

    public void deleteByProduct(int contractId, int productId) throws BGException {
        this.delete("contractId=? AND productId=?", contractId, productId);
    }

    @Override
    public void recycle() {
        try {
            if (this.updateDeviceStatePS != null) {
                this.updateDeviceStatePS.close();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

