/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.ip.dynamic;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpRangeResourceSubscriptionSet;

public class IpResourceRuntime
extends ReentrantLock {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(IpResourceRuntime.class);
    static final ConcurrentMap<Integer, ConcurrentMap<IpAddress, Long>> staticReserved = new ConcurrentHashMap<Integer, ConcurrentMap<IpAddress, Long>>();
    final int id;
    final int categoryId;
    private final byte[] addressFrom;
    private final byte[] addressTo;
    private boolean ipv6;
    private short prefixLength;
    private final int incrementBit;
    private final long timeFrom;
    private final long timeTo;
    private final long size;
    private long position;
    private IpAddress current;
    private ConcurrentMap<IpAddress, Long> reserved;
    private final ConcurrentMap<IpAddress, Object> occupied;
    private final IpRangeResourceSubscriptionSet occupiedRanges;
    private final AtomicLong occupiedRangesSize;
    private final List<DhcpOption> dhcpOptionList;
    public final IpResource ipResource;
    public final ParameterMap config;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, new WorkerThreadFactory("ip-resource-free-map", null, null));
    private final TimeoutMap<Long, IpAddress> freeMap = new TimeoutMap<Long, IpAddress>(SCHEDULED_EXECUTOR_SERVICE, 60L, 60L, TimeUnit.SECONDS){

        @Override
        protected void afterRemoveOnTimeout(Long subscriptionId, IpAddress address) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("freeMap(size=%s):afterRemoveOnTimeout: subscriptionId=%s; address=%s", this.entrySet().size(), subscriptionId, address));
            }
            IpResourceRuntime.this.occupied.remove(address, subscriptionId);
        }
    };

    public IpResourceRuntime(IpResource resource, List<IpResourceSubscriptionRuntime> subscriptionListDyn, List<IpResourceSubscriptionRuntime> subscriptionList) throws BGException {
        DhcpOption option;
        this.id = resource.getId();
        this.categoryId = resource.getCategoryId();
        this.ipResource = resource;
        this.addressFrom = resource.getAddressFrom();
        this.addressTo = resource.getAddressTo();
        this.ipv6 = this.addressFrom.length == 16;
        Calendar calendar = TimeUtils.convertDateToCalendar(resource.getDateFrom());
        if (calendar == null) {
            this.timeFrom = 0L;
        } else {
            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
            this.timeFrom = calendar.getTimeInMillis();
        }
        calendar = TimeUtils.convertDateToCalendar(resource.getDateTo());
        if (calendar == null) {
            this.timeTo = 0L;
        } else {
            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
            calendar.add(5, 1);
            calendar.add(14, -1);
            this.timeTo = calendar.getTimeInMillis();
        }
        ConcurrentMap reserved = (ConcurrentHashMap)staticReserved.get(this.id);
        if (reserved == null) {
            ConcurrentHashMap newReserved = new ConcurrentHashMap();
            reserved = staticReserved.putIfAbsent(this.id, newReserved);
            if (reserved == null) {
                reserved = newReserved;
            }
        }
        this.reserved = reserved;
        this.occupied = new ConcurrentHashMap<IpAddress, Object>();
        ArrayList<IpResourceSubscriptionRuntime> occupiedRangeList = new ArrayList<IpResourceSubscriptionRuntime>(Math.min(100, subscriptionList.size() / 2));
        long occupiedRangesSize = 0L;
        for (IpResourceSubscriptionRuntime subscription : subscriptionList) {
            occupiedRangesSize = this.addOccupied(occupiedRangeList, occupiedRangesSize, subscription);
        }
        this.occupiedRanges = new IpRangeResourceSubscriptionSet(occupiedRangeList);
        this.occupiedRangesSize = new AtomicLong(occupiedRangesSize);
        for (IpResourceSubscriptionRuntime subscription : subscriptionListDyn) {
            IpAddress address = new IpAddress(subscription.getAddressFrom());
            this.occupied.merge(address, subscription.subscriptionId, this::occupieMerge);
        }
        this.prefixLength = resource.getPrefixLength();
        if (this.prefixLength <= 0) {
            this.prefixLength = (short)(this.ipv6 ? 64 : 32);
        }
        this.incrementBit = this.ipv6 ? 128 - this.prefixLength : 32 - this.prefixLength;
        byte[] tempFrom = new byte[this.addressFrom.length + 1];
        System.arraycopy(this.addressFrom, 0, tempFrom, 1, this.addressFrom.length);
        byte[] tempTo = new byte[this.addressFrom.length + 1];
        System.arraycopy(this.addressTo, 0, tempTo, 1, this.addressTo.length);
        BigInteger bigIntegerFrom = new BigInteger(tempFrom);
        BigInteger bigIntegerTo = new BigInteger(tempTo);
        BigInteger size = bigIntegerTo.subtract(bigIntegerFrom).add(BigInteger.ONE);
        if (this.incrementBit > 0) {
            size = size.divide(BigInteger.valueOf(2L).pow(this.incrementBit));
        }
        if (size.compareTo(BigInteger.ZERO) < 0) {
            throw new BGException("Incorrect range of addresses!");
        }
        this.size = size.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) > 0 ? Long.MIN_VALUE : size.longValue();
        Preferences params = new Preferences(Utils.maskNull(resource.getConfig()), "\n");
        this.config = params;
        if (this.addressFrom != null && this.addressFrom.length == 16) {
            IpAddress.nextPrefix(this.addressFrom, this.prefixLength);
        }
        this.current = new IpAddress(Arrays.copyOf(this.addressFrom, this.addressFrom.length));
        ArrayList<DhcpOption> optionList = new ArrayList<DhcpOption>(8);
        if (Utils.notBlankString(resource.getRouter()) && (option = DhcpOption.parseOption("gate", resource.getRouter())) != null) {
            optionList.add(option);
        }
        if (Utils.notBlankString(resource.getSubnetMask()) && (option = DhcpOption.parseOption("subnetMask", resource.getSubnetMask())) != null) {
            optionList.add(option);
        }
        if (Utils.notBlankString(resource.getDns()) && (option = DhcpOption.parseOption("dns", resource.getDns())) != null) {
            optionList.add(option);
        }
        for (Map.Entry<String, String> e : params.sub("dhcp.option.").entrySet()) {
            DhcpOption option2 = DhcpOption.parseOption(e.getKey(), e.getValue());
            if (option2 == null) continue;
            optionList.add(option2);
        }
        this.dhcpOptionList = optionList.size() > 0 ? optionList : null;
    }

    private long addOccupied(List<IpResourceSubscriptionRuntime> occupiedRangeList, long occupiedRangesSize, IpResourceSubscriptionRuntime subscription) {
        int prefixLength;
        byte[] addressFrom = subscription.getAddressFrom();
        byte[] addressTo = subscription.getAddressTo();
        if (addressTo == null || IpAddress.equals(addressFrom, addressTo)) {
            IpAddress address = new IpAddress(addressFrom);
            this.occupied.put(address, subscription.subscriptionId);
            return occupiedRangesSize;
        }
        if (addressFrom.length == 16 && (prefixLength = IpNet.getMask(addressFrom, addressTo)) == this.prefixLength) {
            IpAddress address = new IpAddress(addressFrom);
            this.occupied.put(address, subscription.subscriptionId);
            return occupiedRangesSize;
        }
        occupiedRangeList.add(subscription);
        return occupiedRangesSize += IpResourceRuntime.rangeSize(addressFrom, addressTo);
    }

    private static long convertBytesToLong(byte[] bytes) {
        return 0xFFL & (long)bytes[3] | 0xFF00L & (long)(bytes[2] << 8) | 0xFF0000L & (long)(bytes[1] << 16) | 0xFF000000L & (long)(bytes[0] << 24);
    }

    private static long rangeSize(byte[] addressFrom, byte[] addressTo) {
        if (addressFrom.length == 4) {
            return IpResourceRuntime.convertBytesToLong(addressTo) - IpResourceRuntime.convertBytesToLong(addressFrom);
        }
        byte[] tempFrom = new byte[addressFrom.length + 1];
        System.arraycopy(addressFrom, 0, tempFrom, 1, addressFrom.length);
        byte[] tempTo = new byte[addressFrom.length + 1];
        System.arraycopy(addressTo, 0, tempTo, 1, addressTo.length);
        BigInteger bigIntegerFrom = new BigInteger(tempFrom);
        BigInteger bigIntegerTo = new BigInteger(tempTo);
        BigInteger size = bigIntegerTo.subtract(bigIntegerFrom).add(BigInteger.ONE);
        if (size.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) > 0) {
            return Long.MIN_VALUE;
        }
        return size.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpResourceReserve reserve(long timeout) {
        long time = System.currentTimeMillis();
        Long timeoutTime = time + timeout;
        IpAddress address = new IpAddress();
        this.lock();
        try {
            if (this.tryReserve(address, time, timeoutTime)) {
                IpResourceReserve ipResourceReserve = new IpResourceReserve(this.id, address.address, this.getPrefixLength(), timeoutTime);
                return ipResourceReserve;
            }
        }
        finally {
            this.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reserve(List<IpResourceReserve> list, long millis, long timeout, int max) {
        Long timeoutTime = millis + timeout;
        if (this.timeFrom > millis && this.timeFrom != 0L || this.timeTo != 0L && this.timeTo < timeoutTime) {
            return max;
        }
        this.lock();
        try {
            IpAddress address;
            while (max > 0 && this.tryReserve(address = new IpAddress(), millis, timeoutTime)) {
                list.add(new IpResourceReserve(this.id, address.address, this.getPrefixLength(), timeoutTime));
                --max;
            }
        }
        finally {
            this.unlock();
        }
        return max;
    }

    private boolean tryReserve(IpAddress current, long time, Long timeoutTime) {
        current.address = new byte[this.current.address.length];
        IpResourceRuntime.set(current, this.current);
        if (this.size != Long.MIN_VALUE) {
            long size = this.size;
            for (long i = 0L; i < size; ++i) {
                Long oldTime;
                if (!this.occupied.containsKey(current) && !this.occupiedRanges.contains(current) && (oldTime = this.reserved.putIfAbsent(current, timeoutTime)) == null) {
                    IpResourceRuntime.set(this.current, current);
                    this.incrementFast(this.current);
                    return true;
                }
                this.incrementFast(current);
            }
        } else {
            do {
                Long oldTime;
                if (!this.occupied.containsKey(current) && !this.occupiedRanges.contains(current) && (oldTime = this.reserved.putIfAbsent(current, timeoutTime)) == null) {
                    IpResourceRuntime.set(this.current, current);
                    this.increment(this.current);
                    return true;
                }
                this.increment(current);
            } while (!IpResourceRuntime.equalsByBack(this.current.address, current.address));
        }
        return false;
    }

    private IpAddress incrementFast(IpAddress current) {
        if (this.ipv6) {
            IpAddress.increment(current.address, this.incrementBit);
        } else {
            IpAddress.increment(current.address);
        }
        if (++this.position >= this.size) {
            System.arraycopy(this.addressFrom, 0, current.address, 0, this.addressFrom.length);
            this.position = 0L;
        }
        return current;
    }

    private IpAddress increment(IpAddress current) {
        if (this.ipv6) {
            IpAddress.increment(current.address, this.incrementBit);
        } else {
            IpAddress.increment(current.address);
        }
        if (IpAddress.compare(current.address, this.addressTo) > 0) {
            System.arraycopy(this.addressFrom, 0, current.address, 0, this.addressFrom.length);
        }
        return current;
    }

    private static void set(IpAddress current, IpAddress address) {
        System.arraycopy(address.address, 0, current.address, 0, address.address.length);
    }

    private static boolean equalsByBack(byte[] a2, byte[] a22) {
        for (int i = a2.length - 1; i >= 0; --i) {
            if (a2[i] == a22[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isCoincide(byte[] address, long millis) {
        return !(IpAddress.compare(this.addressFrom, address) > 0 || IpAddress.compare(this.addressTo, address) < 0 || this.timeFrom > millis && this.timeFrom != 0L || this.timeTo != 0L && this.timeTo < millis);
    }

    public void occipie(long subscriptionId, byte[] addressFrom, byte[] addressTo, boolean dynamic) {
        if (dynamic) {
            IpAddress address = new IpAddress(addressFrom);
            if (!this.freeMap.containsKey(subscriptionId)) {
                this.occupied.merge(address, subscriptionId, this::occupieMerge);
            } else {
                logger.info((Object)"Subscription already closed.");
            }
            this.reserved.remove(address);
            return;
        }
        if (addressTo == null || IpAddress.equals(addressFrom, addressTo) || addressFrom.length == 16 && IpNet.getMask(addressFrom, addressTo) == this.prefixLength) {
            IpAddress address = new IpAddress(addressFrom);
            this.occupied.merge(address, subscriptionId, this::occupieMerge);
            this.reserved.remove(address);
            return;
        }
        this.occupiedRanges.add(new IpResourceSubscriptionRuntime(subscriptionId, addressFrom, addressTo));
        this.occupiedRangesSize.addAndGet(IpResourceRuntime.rangeSize(addressFrom, addressTo));
    }

    private Object occupieMerge(Object oldValue, Object value) {
        if (oldValue == null) {
            return value;
        }
        if (oldValue instanceof Long[]) {
            Long[] array = (Long[])oldValue;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!value.equals(array[i])) continue;
                return oldValue;
            }
            array = Arrays.copyOf(array, array.length + 1);
            array[array.length - 1] = (Long)value;
            return array;
        }
        return new Long[]{(Long)oldValue, (Long)value};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean free0(IpAddress address, Long subscriptionId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("free0( address=%s, subscriptionId=%s )", address, subscriptionId));
            logger.debug((Object)("free0: occupied.size()=" + this.occupied.size()));
        }
        if (this.occupied.remove(address, subscriptionId)) {
            if (!logger.isDebugEnabled()) return true;
            logger.debug((Object)("free0: occupied.remove=true; occupied.size()=" + this.occupied.size()));
            return true;
        }
        block0: while (true) {
            Object value = this.occupied.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("free0( address=%s, subscriptionId=%s )", address, subscriptionId));
                logger.debug((Object)("free0: value=" + value));
            }
            if (value == null) {
                if (!logger.isDebugEnabled()) return false;
                logger.debug((Object)"free0: not free (not found)!");
                return false;
            }
            if (value instanceof Long) {
                if (subscriptionId.equals(value)) {
                    if (!this.occupied.remove(address, subscriptionId)) continue;
                    if (!logger.isDebugEnabled()) return true;
                    logger.debug((Object)"free0: occupied.remove!");
                    return true;
                }
                if (!logger.isDebugEnabled()) return false;
                logger.debug((Object)("free0: address=" + address + "; subscriptionId=" + subscriptionId + " != occupied.get( address )"));
                logger.debug((Object)"free0: not free (subscriptionId not equals)!");
                return false;
            }
            Long[] array = (Long[])value;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!value.equals(array[i])) continue;
                if (size == 1) {
                    if (!this.occupied.remove(address, array)) continue block0;
                    return true;
                }
                Long[] newArray = new Long[array.length - 1];
                System.arraycopy(array, 0, newArray, 0, i);
                System.arraycopy(array, i + 1, newArray, i, array.length - i - 1);
                if (this.occupied.replace(address, array, newArray)) return true;
                continue block0;
            }
            break;
        }
        return false;
    }

    public void free(long subscriptionId, byte[] addressFrom, byte[] addressTo, boolean dynamic) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("free: subscriptionId=" + subscriptionId + "; dynamic=" + dynamic + "; occupied.size()=" + this.occupied.size() + "; occupiedRanges.size()=" + this.occupiedRanges.size()));
        }
        if (dynamic || addressTo == null || IpAddress.equals(addressFrom, addressTo) || addressFrom.length == 16 && IpNet.getMask(addressFrom, addressTo) == this.prefixLength) {
            IpAddress address = new IpAddress(addressFrom);
            if (!this.free0(address, subscriptionId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("free: address=" + address + "; subscriptionId=" + subscriptionId + " add to freeMap"));
                }
                this.freeMap.put(subscriptionId, address, System.currentTimeMillis() + 60000L);
            }
            return;
        }
        this.occupiedRanges.remove(new IpResourceSubscriptionRuntime(subscriptionId, addressFrom, addressTo));
        this.occupiedRangesSize.addAndGet(-IpResourceRuntime.rangeSize(addressFrom, addressTo));
    }

    public boolean checkPeriod(long millis) {
        return !(this.timeFrom != 0L && this.timeFrom > millis || this.timeTo != 0L && this.timeTo <= millis);
    }

    public long getSize() {
        return this.size;
    }

    public List<DhcpOption> getDhcpOptionList() {
        return this.dhcpOptionList;
    }

    public long getOccupiedCount() {
        return (long)this.occupied.size() + this.occupiedRangesSize.get();
    }

    public long getReservedCount() {
        return this.reserved.size();
    }

    public short getPrefixLength() {
        return this.prefixLength;
    }
}

