/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;

public class DeviceGroupDao
extends AbstractIdDao<DeviceGroup>
implements Directory<DeviceGroup> {
    private static final List<DeviceGroup> defaultList = new ArrayList<DeviceGroup>();

    public DeviceGroupDao(Connection con, int mid) {
        super(con, 0, "inv_device_group_" + mid);
    }

    @Override
    protected DeviceGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        DeviceGroup result = new DeviceGroup();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        result.setCityId(rs.getInt("cityId"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    @Override
    protected void updateImpl(DeviceGroup s) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString(s.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (s.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (parentId, title, cityId, comment) VALUES (?, ?, ?, ?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, title=?, cityId=?, comment=? WHERE id=?");
            ps.setInt(5, s.getId());
        }
        ps.setInt(1, s.getParentId());
        ps.setString(2, s.getTitle());
        ps.setInt(3, s.getCityId());
        ps.setString(4, s.getComment());
        ps.executeUpdate();
        if (s.getId() <= 0) {
            s.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public DeviceGroup get(String title) throws BGException {
        return (DeviceGroup)this.get("title=?", title);
    }

    @Override
    public List<DeviceGroup> list() throws BGException {
        List<DeviceGroup> result = super.list(null, null, new Object[0]);
        result.addAll(0, defaultList);
        return result;
    }

    public DeviceGroup root() throws BGException {
        List<DeviceGroup> deviceList = this.list();
        DeviceGroup root = new DeviceGroup();
        root.setId(0);
        root.setTitle("\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
        HashMap<Integer, DeviceGroup> deviceMap = new HashMap<Integer, DeviceGroup>();
        deviceMap.put(root.getId(), root);
        root.setChildren(new ArrayList<DeviceGroup>());
        for (DeviceGroup d : deviceList) {
            deviceMap.put(d.getId(), d);
            d.setChildren(new ArrayList<DeviceGroup>());
        }
        for (DeviceGroup d : deviceList) {
            DeviceGroup parent = (DeviceGroup)deviceMap.get(d.getParentId());
            if (parent != null) {
                parent.getChildren().add(d);
                continue;
            }
            root.getChildren().add(d);
        }
        return root;
    }
}

