/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceInstance;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.bean.Resource;

public class IpResourceNet
extends IpNet
implements IpResourceInstance,
Resource {
    private int ipResourceId;

    public IpResourceNet() {
    }

    public IpResourceNet(int ipResourceId, byte[] subnet, int mask) {
        super(subnet, mask);
        this.ipResourceId = ipResourceId;
    }

    @Override
    @XmlAttribute(name="resId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    @Override
    public void setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
    }

    public static void newIpResourceNetList(IpResource resource, List<IpResourceSubscription> subscriptionList, int mask, final int max, final List<IpResourceNet> result) {
        boolean ipv6;
        boolean bl = ipv6 = resource.getAddressFrom() != null && resource.getAddressFrom().length == 16;
        if (mask <= 0 && resource.getPrefixLength() > 0) {
            mask = resource.getPrefixLength();
        } else if (mask > resource.getPrefixLength() && resource.getPrefixLength() > 0) {
            mask = resource.getPrefixLength();
        } else if (mask <= 0) {
            mask = ipv6 ? 64 : 32;
        }
        final int maskf = mask;
        new IpResourceRange.IpResourceRangeExtractor(max){

            @Override
            protected boolean next(int resourceId, byte[] addressFrom, byte[] addressTo) {
                IpResourceNet.subnet(result, resourceId, addressFrom, addressTo, maskf, max - result.size(), ipv6);
                return result.size() < max;
            }
        }.process(resource, subscriptionList);
    }

    public static void newIpResourceNetList(Iterable<IpResourceRange> rangeList, int mask, int max, List<IpResourceNet> result) {
        for (IpResourceRange range : rangeList) {
            byte[] addressFrom = range.getAddressFrom();
            boolean ipv6 = addressFrom != null && addressFrom.length == 16;
            IpResourceNet.subnet(result, range.getIpResourceId(), range.getAddressFrom(), range.getAddressTo(), mask, max, ipv6);
            if ((max -= result.size()) > 0) continue;
            break;
        }
    }

    private static void subnet(List<IpResourceNet> list, int ipResourceId, byte[] addressFrom, byte[] addressTo, int mask, int max, boolean ipv6) {
        byte[] addressFrom2 = new byte[addressFrom.length];
        byte[] addressTo2 = new byte[addressFrom.length];
        System.arraycopy(addressFrom, 0, addressFrom2, 0, addressFrom.length);
        System.arraycopy(addressFrom, 0, addressTo2, 0, addressFrom.length);
        for (int k = 0; k < max; ++k) {
            int i;
            for (i = addressFrom2.length - 1; i > mask / 8; --i) {
                addressFrom2[i] = 0;
                addressTo2[i] = -1;
            }
            if (mask % 8 != 0) {
                int n = i;
                addressFrom2[n] = (byte)(addressFrom2[n] & (byte)(255 << 8 - mask % 8));
                int n2 = i;
                addressTo2[n2] = (byte)(addressTo2[n2] | (byte)(255 >> mask % 8));
            } else if (mask / 8 == (ipv6 ? 16 : 4)) {
                int n = i;
                addressTo2[n] = (byte)(addressTo2[n] | 0);
            } else {
                int n = i;
                addressTo2[n] = (byte)(addressTo2[n] | (byte)(255 >> mask % 8));
            }
            if (IpAddress.compare(addressTo2, addressTo) > 0) break;
            if (IpAddress.compare(addressFrom, addressFrom2) <= 0) {
                list.add(new IpResourceNet(ipResourceId, addressFrom2, mask));
            }
            if ((addressFrom2 = IpAddress.newAndIncrement(addressTo2)) == null) break;
            System.arraycopy(addressFrom2, 0, addressTo2, 0, addressFrom.length);
        }
    }
}

