/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductUtils;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifyEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifyEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ServiceLinkModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.inventory.product.server.ProductSpecMap;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecActivationModeDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecServiceLinkDao;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.service.ServiceService;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.product.common.service.ProductService")
public class ProductServiceImpl
extends AbstractService
implements ProductService {
    @Resource
    private ServiceService serviceService;
    private ProductDao productDao;
    private ProductSpecDao productSpecDao;
    private ProductPeriodDao productPeriodDao;
    private Directory<ProductSpec> productSpecDir;

    private Directory<ProductSpec> getProductSpecDir() throws BGException {
        if (this.productSpecDir == null) {
            this.productSpecDir = this.context.getDirectory(ProductSpec.class, 0);
        }
        return this.productSpecDir;
    }

    private ProductSpecDao getProductSpecDao() {
        if (this.productSpecDao == null) {
            this.productSpecDao = new ProductSpecDao(this.getConnection(), 0, this.userId);
        }
        return this.productSpecDao;
    }

    private ProductDao getProductDao() {
        if (this.productDao == null) {
            this.productDao = new ProductDao(this.getConnection(), this.userId);
        }
        return this.productDao;
    }

    private ProductPeriodDao getProductPeriodDao() {
        if (this.productPeriodDao == null) {
            this.productPeriodDao = new ProductPeriodDao(this.getConnection(), this.userId);
        }
        return this.productPeriodDao;
    }

    @PostConstruct
    protected void init() {
    }

    @Override
    public ProductSpec productSpecGet(int id) throws BGException {
        return this.getProductSpecDir().get(id);
    }

    @Override
    public ProductSpec productSpecGetByIdentifier(String identifier) throws BGException {
        return this.getProductSpecDao().getByIdentifier(identifier);
    }

    @Override
    public List<ProductSpec> productSpecList(Integer moduleId, Date dateFrom, Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws BGException {
        if (moduleId == null && this.moduleId > 0) {
            moduleId = this.moduleId;
        }
        if (!(moduleId != null && moduleId >= 0 || dateFrom != null || dateTo != null || !Utils.isBlankString(title) || entityFilter != null && entityFilter.size() != 0)) {
            return this.getProductSpecDir().list();
        }
        return this.getProductSpecDao().list(moduleId, dateFrom, dateTo, title, entityFilter);
    }

    @Override
    public ProductSpec productSpecTree(Integer moduleId, Date dateFrom, Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws BGException {
        List<ProductSpec> list = this.productSpecList(moduleId, dateFrom, dateTo, title, entityFilter);
        ProductSpec root = new ProductSpec();
        root.setTitle("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
        return TreeUtils.tree(list, root);
    }

    @Override
    public int productSpecUpdate(ProductSpec productSpec) throws BGException {
        this.getProductSpecDir().update(productSpec);
        return productSpec.getId();
    }

    @Override
    public void productSpecDelete(int id) throws BGException {
        this.getProductSpecDir().delete(id);
    }

    @Override
    public List<ProductSpecActivationMode> productSpecActivationModeList(int productSpecId, Date date) throws BGException {
        return new ProductSpecActivationModeDao(this.getConnection(), 0).list(productSpecId, date);
    }

    @Override
    public void productSpecMove(int id, Set<Integer> ids) throws BGException {
        this.getProductSpecDao().move(id, ids);
    }

    @Override
    public List<ProductSpecServiceLink> serviceLinkList(int productSpecId, Date date) throws BGException {
        return new ProductSpecServiceLinkDao(this.getConnection(), 0).list(productSpecId, date);
    }

    @Override
    public void serviceLinkUpdate(int productSpecId, List<ProductSpecServiceLink> linkList) throws BGException {
        new ProductSpecServiceLinkDao(this.getConnection(), 0).update(productSpecId, linkList);
        this.context.publishAfterCommit(new ServiceLinkModifiedEvent(this.moduleId, this.userId, productSpecId, linkList));
    }

    @Override
    @Deprecated
    public List<Product> productList(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date intersectTimeFrom, Date intersectTimeTo, boolean nonActive) throws BGException {
        return this.productList(moduleId, contractId, accountId, kernel, timeFrom, timeTo, intersectTimeFrom, intersectTimeTo, nonActive, true);
    }

    @Override
    public List<Product> productList(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date intersectTimeFrom, Date intersectTimeTo, boolean nonActive, boolean needProductPeriods) throws BGException {
        int i;
        List<Product> result = this.getProductDao().list(moduleId, contractId, accountId, kernel, timeFrom, timeTo, intersectTimeFrom, intersectTimeTo, nonActive, true);
        if (!needProductPeriods) {
            return result;
        }
        Date now = new Date();
        List<ProductPeriod> productPeriodList = this.getProductPeriodDao().list(-1, contractId, accountId, true, now, now, true);
        HashMap<Integer, ProductPeriod> productPeriodMap = new HashMap<Integer, ProductPeriod>();
        int size = productPeriodList.size();
        for (i = 0; i < size; ++i) {
            ProductPeriod productPeriod = productPeriodList.get(i);
            productPeriodMap.put(productPeriod.getProductId(), productPeriod);
        }
        size = result.size();
        for (i = 0; i < size; ++i) {
            ProductPeriod productPeriod;
            Product product = result.get(i);
            if (product.getTimeTo() != null && product.getTimeTo().before(now) || (productPeriod = (ProductPeriod)productPeriodMap.get(product.getId())) == null) continue;
            product.setSubscriptionTimeFrom(productPeriod.getTimeFrom());
            product.setSubscriptionTimeTo(productPeriod.getTimeTo());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int productUpdate(Product product) throws BGException {
        int contractId = product.getContractId();
        ProductDao productDao = this.getProductDao();
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            HashMap<Integer, Service> oldServiceMap;
            Product oldProduct;
            if (product.getId() > 0) {
                oldProduct = (Product)productDao.get(product.getId());
                List<Service> oldServiceList = this.serviceService.serviceList(contractId, product.getId());
                oldServiceMap = new HashMap<Integer, Service>();
                for (Service service : oldServiceList) {
                    oldServiceMap.put(service.getServiceSpecId(), service);
                }
            } else {
                oldProduct = null;
                oldServiceMap = null;
            }
            this.getProductDao().update(product);
            ArrayList<Service> newServiceList = new ArrayList<Service>();
            ProductSpecMap productSpecMap = ProductSpecMap.getInstance();
            ProductSpecMap.ProductSpecItem productSpecItem = productSpecMap.get(product.getProductSpecId());
            GregorianCalendar utilCalendar = new GregorianCalendar();
            for (ProductSpecServiceLink serviceLink : productSpecItem.serviceLinkList) {
                Service oldService;
                if (!TimeUtils.periodInRange(product.getTimeTo(), product.getTimeFrom(), serviceLink.getDateFrom(), serviceLink.getDateTo())) continue;
                Date timeFrom = ProductUtils.timeFrom(product.getTimeFrom(), serviceLink.getDateFrom(), utilCalendar);
                Date timeTo = ProductUtils.timeTo(product.getTimeTo(), serviceLink.getDateTo(), utilCalendar);
                if (oldServiceMap != null) {
                    oldService = (Service)oldServiceMap.remove(serviceLink.getServiceSpecId());
                    if (oldService != null && (timeFrom == null && oldService.getTimeFrom() == null || timeFrom != null && timeFrom.equals(oldService.getTimeFrom()) && timeTo == null && oldService.getTimeTo() == null || timeTo != null && timeTo.equals(oldService.getTimeTo()))) {
                        newServiceList.add(oldService);
                        continue;
                    }
                } else {
                    oldService = null;
                }
                Service service = new Service();
                if (oldService != null) {
                    service.setId(oldService.getId());
                }
                service.setContractId(product.getContractId());
                service.setAccountId(product.getAccountId());
                service.setProductId(product.getId());
                service.setServiceSpecId(serviceLink.getServiceSpecId());
                service.setTimeFrom(timeFrom);
                service.setTimeTo(timeTo);
                service.setDeviceState(product.getDeviceState());
                this.serviceService.serviceUpdate(service);
                newServiceList.add(service);
            }
            if (oldServiceMap != null) {
                for (Service oldService : oldServiceMap.values()) {
                    this.serviceService.serviceDelete(contractId, oldService.getId());
                }
            }
            product.setServiceList(newServiceList);
            ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
            this.context.publishAfterCommit(new ProductModifiedEvent(productSpec.getModuleId(), product.getContractId(), this.userId, oldProduct, product));
            int n = product.getId();
            return n;
        }
        finally {
            contractRuntime.unlock();
        }
    }

    @Override
    public Product productGet(int contractId, int productId) throws BGException {
        return this.getProductDao().get(contractId, productId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void productDelete(int contractId, int productId) throws BGException {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            Product oldProduct = this.getProductDao().getAndDelete(contractId, productId);
            List<Service> oldServiceList = this.serviceService.serviceList(contractId, productId);
            oldProduct.setServiceList(oldServiceList);
            this.serviceService.serviceDeleteByProduct(contractId, productId);
            List<ProductPeriod> oldProductPeriodList = this.getProductPeriodDao().list(contractId, productId);
            this.getProductPeriodDao().deleteByProductId(contractId, productId);
            ProductSpec productSpec = this.getProductSpecDir().get(oldProduct.getProductSpecId());
            ProductModifyEvent productModifyEvent = EventProcessor.getInstance().request(new ProductModifyEvent(contractId, this.userId, productSpec, oldProduct, null, true, true));
            if (!productModifyEvent.isProcess()) {
                throw new BGMessageException(productModifyEvent.getMessage());
            }
            this.context.publishAfterCommit(new ProductModifiedEvent(productSpec.getModuleId(), oldProduct.getContractId(), productId, oldProduct, null));
            for (ProductPeriod oldProductPeriod : oldProductPeriodList) {
                this.context.publishAfterCommit(new ProductPeriodModifiedEvent(productSpec.getModuleId(), contractId, productId, oldProduct, oldProductPeriod, null));
            }
        }
        finally {
            contractRuntime.unlock();
        }
    }

    @Override
    public int productPeriodUpdate(int contractId, ProductPeriod productPeriod) throws BGException {
        if (contractId <= 0 || productPeriod.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        Product product = this.productGet(contractId, productPeriod.getProductId());
        if (product == null) {
            throw new BGIllegalArgumentException("productPeriod.productId");
        }
        productPeriod.setProductSpecId(product.getProductSpecId());
        ProductPeriod oldProductPeriod = this.getProductPeriodDao().getAndUpdate(productPeriod);
        ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
        EventProcessor.getInstance().request(new ProductPeriodModifyEvent(productSpec.getModuleId(), contractId, this.userId, productSpec, product, oldProductPeriod, productPeriod));
        this.context.publishAfterCommit(new ProductPeriodModifiedEvent(productSpec.getModuleId(), contractId, this.userId, product, oldProductPeriod, productPeriod));
        return productPeriod.getId();
    }

    @Override
    public void productPeriodDelete(int contractId, int productPeriodId) throws BGException {
        ProductPeriod oldProductPeriod = (ProductPeriod)this.getProductPeriodDao().get(productPeriodId);
        if (oldProductPeriod.getContractId() != contractId) {
            throw new BGIllegalArgumentException("productPeriodId");
        }
        Product product = this.productGet(contractId, oldProductPeriod.getProductId());
        ProductSpec productSpec = this.getProductSpecDir().get(product.getProductSpecId());
        List<ProductPeriod> list = this.getProductPeriodDao().list(contractId, product.getId());
        if (list.size() <= 1) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043f\u0435\u0440\u0438\u043e\u0434. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0432\u043c\u0435\u0441\u0442\u043e \u044d\u0442\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
        }
        this.getProductPeriodDao().delete(productPeriodId);
        this.context.publishAfterCommit(new ProductPeriodModifiedEvent(productSpec.getModuleId(), contractId, this.userId, product, oldProductPeriod, null));
    }

    @Override
    public List<ProductPeriod> productPeriodList(int contractId, int productId) throws BGException {
        return this.getProductPeriodDao().list(contractId, productId);
    }

    @Override
    public List<String[]> getIncompatibleItems(int moduleId) throws BGException {
        String config = this.getSetup().getModuleSetup(moduleId).get("tv.product.incompatible.items", "true:\u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c;false:\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c");
        String[] listItems = config.split(";");
        ArrayList<String[]> items = new ArrayList<String[]>();
        for (String item : listItems) {
            items.add(item.split(":"));
        }
        return items;
    }
}

