/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecActivationModeDao;

public class ProductSpecDao
extends AbstractEntityDao<ProductSpec>
implements Directory<ProductSpec> {
    private final ProductSpecActivationModeDao activationModeDao;

    public ProductSpecDao(Connection con, int moduleId) {
        this(con, moduleId, 0);
    }

    public ProductSpecDao(Connection con) {
        this(con, 0, 0);
    }

    public ProductSpecDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, userId, "inv_product_spec");
        this.activationModeDao = new ProductSpecActivationModeDao(con, moduleId);
    }

    @Override
    protected ProductSpec getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        ProductSpec result = new ProductSpec();
        result.setId(rs.getInt("id"));
        result.setEntityId(rs.getInt("entityId"));
        result.setModuleId(rs.getInt("moduleId"));
        result.setParentId(rs.getInt("parentId"));
        result.setPeriodic(rs.getBoolean("periodic"));
        result.setTitle(rs.getString("title"));
        result.setIdentifier(rs.getString("identifier"));
        result.setTariffIds(Utils.toIntegerSet(rs.getString("tariffIds")));
        result.setContractGroups(rs.getLong("contractGroups"));
        result.setComment(rs.getString("comment"));
        result.setDescription(rs.getString("description"));
        result.setDateFrom(rs.getDate("dateFrom"));
        result.setDateTo(rs.getDate("dateTo"));
        result.setDepends(Utils.toIntegerSet(rs.getString("depends")));
        result.setIncompatible(Utils.toIntegerSet(rs.getString("incompatible")));
        result.setHideForCustomer(rs.getBoolean("hideForCustomer"));
        result.setHideForContractGroups(rs.getLong("hideForContractGroups"));
        result.setHideForContractGroupsMode(rs.getInt("hideForContractGroupsMode"));
        result.setActivationByCustomer(rs.getBoolean("activationByCustomer"));
        result.setDeactivationByCustomer(rs.getBoolean("deactivationByCustomer"));
        result.setNotRealtime(rs.getBoolean("notRealtime"));
        result.setPriority(rs.getInt("priority"));
        String data = rs.getString("data");
        result.setData(data.isEmpty() ? "{}" : data);
        result.setActivationModeList(this.activationModeDao.list(result.getId(), null));
        return result;
    }

    @Override
    protected void updateImpl(ProductSpec productSpec) throws BGException, SQLException {
        boolean insert = productSpec.getId() <= 0;
        String querySet = " SET entityId=?, moduleId=?, parentId=?, periodic=?, title=?, identifier=?, tariffIds=?, contractGroups=?, comment=?, description=?, dateFrom=?, dateTo=?, depends=?, incompatible=?, hideForCustomer=?, hideForContractGroups=?, hideForContractGroupsMode=?, activationByCustomer=?, deactivationByCustomer=?, notRealtime=?, priority=?, data=?";
        PreparedStatement ps = this.con.prepareStatement((insert ? "INSERT INTO " : "UPDATE ") + this.tableName + querySet + (insert ? "" : " WHERE id=?"), 1);
        int parameterIndex = 1;
        ps.setInt(parameterIndex++, productSpec.getEntityId());
        ps.setInt(parameterIndex++, productSpec.getModuleId());
        ps.setInt(parameterIndex++, productSpec.getParentId());
        ps.setBoolean(parameterIndex++, productSpec.isPeriodic());
        ps.setString(parameterIndex++, productSpec.getTitle());
        ps.setString(parameterIndex++, productSpec.getIdentifier());
        ps.setString(parameterIndex++, Utils.toString(productSpec.getTariffIds()));
        ps.setLong(parameterIndex++, productSpec.getContractGroups());
        ps.setString(parameterIndex++, productSpec.getComment());
        ps.setString(parameterIndex++, productSpec.getDescription());
        ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(productSpec.getDateFrom()));
        ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(productSpec.getDateTo()));
        ps.setString(parameterIndex++, Utils.toString(productSpec.getDepends()));
        ps.setString(parameterIndex++, Utils.toString(productSpec.getIncompatible()));
        ps.setBoolean(parameterIndex++, productSpec.isHideForCustomer());
        ps.setLong(parameterIndex++, productSpec.getHideForContractGroups());
        ps.setInt(parameterIndex++, productSpec.getHideForContractGroupsMode());
        ps.setBoolean(parameterIndex++, productSpec.isActivationByCustomer());
        ps.setBoolean(parameterIndex++, productSpec.isDeactivationByCustomer());
        ps.setBoolean(parameterIndex++, productSpec.isNotRealtime());
        ps.setInt(parameterIndex++, productSpec.getPriority());
        ps.setString(parameterIndex++, productSpec.getData());
        if (!insert) {
            ps.setInt(parameterIndex++, productSpec.getId());
        }
        ps.executeUpdate();
        if (insert) {
            productSpec.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
        this.activationModeDao.update(productSpec.getId(), productSpec.getActivationModeList());
    }

    @Override
    public ProductSpec get(String title) throws BGException {
        return (ProductSpec)this.get("title=?", title);
    }

    public List<ProductSpec> list(int moduleId, java.util.Date dateFrom, java.util.Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws BGException {
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate(dateFrom);
        Date sqlDateTo = TimeUtils.convertDateToSqlDate(dateTo);
        return super.list(true, null, null, null, entityFilter, "(? OR moduleId=?) AND (? OR dateFrom IS NULL OR dateFrom<=?) AND (? OR dateTo IS NULL OR ?<=dateTo) AND (? OR " + this.tableName + ".title LIKE ?)", this.tableName + ".id", null, moduleId < 0, moduleId, sqlDateTo == null, sqlDateTo, sqlDateFrom == null, sqlDateFrom, Utils.isBlankString(title), "%" + title + "%");
    }

    public List<ProductSpec> list(int moduleId) throws BGException {
        return this.list(moduleId, null, null, null, null);
    }

    @Override
    public List<ProductSpec> list() throws BGException {
        return this.list(-1, null, null, null, null);
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        List<ProductSpec> list = this.list();
        for (Integer id : children) {
            ProductSpec child = TreeUtils.tree(list, id);
            if (TreeUtils.find(child, newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public ProductSpec getByIdentifier(String identifier) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle FROM " + this.tableName + " LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId WHERE " + this.tableName + ".identifier=?");
            ps.setString(1, identifier);
            ResultSet rs = ps.executeQuery();
            ProductSpec result = rs.next() ? (ProductSpec)this.getFromRS(rs, true, true) : null;
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public int delete(int id) throws BGException {
        try (ProductDao productDao = new ProductDao(this.con, this.userId);){
            productDao.checkProductSpecDelete(id);
            int n = super.delete(id);
            return n;
        }
    }
}

