/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.server.bean.EntitySpecAttrDao;

public class EntitySpecDao
extends AbstractIdDao<EntitySpec>
implements Directory<EntitySpec> {
    private EntitySpecAttrDao esam;
    private PreparedStatement getModuleIdsPS = null;

    public EntitySpecDao(Connection con) {
        super(con, 0, "entity_spec");
        this.esam = new EntitySpecAttrDao(con);
    }

    @Override
    protected EntitySpec getFromRS(ResultSet rs) throws SQLException, BGException {
        EntitySpec result = new EntitySpec();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setEntitySpecTypeId(rs.getInt("entitySpecTypeId"));
        result.setComment(rs.getString("comment"));
        result.setHidden(rs.getBoolean("hidden"));
        result.setEntityTitleMacros(rs.getString("entityTitleMacros"));
        result.setAttributeList(this.esam.listByEntitySpec(result.getId()));
        return result;
    }

    @Override
    protected void updateImpl(EntitySpec s) throws BGException, SQLException {
        PreparedStatement ps;
        if (s.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, entitySpecTypeId, comment, hidden, entityTitleMacros) VALUES (?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, entitySpecTypeId=?, comment=?, hidden=?, entityTitleMacros=? WHERE id=?");
            ps.setInt(6, s.getId());
        }
        ps.setString(1, s.getTitle());
        ps.setInt(2, s.getEntitySpecTypeId());
        ps.setString(3, s.getComment());
        ps.setBoolean(4, s.isHidden());
        ps.setString(5, s.getEntityTitleMacros());
        ps.executeUpdate();
        if (s.getId() <= 0) {
            s.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
        this.esam.update(s);
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        int result = super.deleteImpl(id);
        return result;
    }

    @Override
    public List<EntitySpec> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    @Override
    public EntitySpec get(String title) throws BGException {
        return (EntitySpec)super.get("title=?", title);
    }
}

