/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAttribute;

public class BGMoney
implements Comparable<BGMoney> {
    public static final BGMoney ZERO = new BGMoney(0L);
    @XmlAttribute(name="mde")
    private long mde;
    private int mdeFactor = 100;
    private BigDecimal mdeFactorBD = new BigDecimal(this.mdeFactor);
    private int fractionDigits = 2;

    public BGMoney() {
        this(0L);
    }

    public BGMoney(long mde) {
        this.mde = mde;
    }

    public BGMoney(BigDecimal val) {
        this.mde = val.multiply(this.mdeFactorBD).longValue();
    }

    public BGMoney(double val) {
        this.mde = Math.round(val * (double)this.mdeFactor);
    }

    public BGMoney(String val) throws NumberFormatException {
        char[] digits = val.toCharArray();
        long mul = 1L;
        boolean wasDot = false;
        for (int i = digits.length - 1; i >= 0; --i) {
            char curr = digits[i];
            if (Character.isDigit(curr)) {
                this.mde += mul * (long)(curr - 48);
                mul *= 10L;
                continue;
            }
            if (curr == '.') {
                if (mul == (long)this.mdeFactor) {
                    wasDot = true;
                    continue;
                }
                throw new NumberFormatException("\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u044f\u0442\u043e\u0439 \u0432 '" + val + "'");
            }
            if (curr == '-') {
                if (i == 0) {
                    this.mde = -this.mde;
                    continue;
                }
                throw new NumberFormatException("\u043c\u0438\u043d\u0443\u0441 \u043d\u0435 \u043f\u0435\u0440\u0432\u044b\u0439 \u0432 '" + val + "'");
            }
            throw new NumberFormatException("\u043f\u043b\u043e\u0445\u043e\u0439 \u0441\u0438\u043c\u0432\u043e\u043b '" + curr + "' \u0432 '" + val + "'");
        }
        if (!wasDot) {
            this.mde *= 100L;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mde < 0L) {
            sb.append("-");
            this.mde = -this.mde;
        }
        sb.append(this.mde / (long)this.mdeFactor).append(this.mdeFactor > 1 ? "." : "");
        long kop = this.mde % (long)this.mdeFactor;
        long del = this.mdeFactor / 10;
        for (int i = this.fractionDigits; i > 0; --i) {
            sb.append(kop / del);
            kop %= del;
            del /= 10L;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.mde == ((BGMoney)o).mde;
    }

    public int hashCode() {
        int result = (int)(this.mde ^ this.mde >>> 32);
        result = 31 * result + this.mdeFactor;
        return result;
    }

    public String toHumanString() {
        throw new UnsupportedOperationException();
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.mde).divide(this.mdeFactorBD, this.fractionDigits, 7);
    }

    public BGMoney multiply(BGMoney multiplicand) {
        return new BGMoney(this.mde * multiplicand.mde / (long)this.mdeFactor);
    }

    public BGMoney add(BGMoney augend) {
        return new BGMoney(this.mde + augend.mde);
    }

    @Override
    public int compareTo(BGMoney val) {
        return this.mde == val.mde ? 0 : (this.mde < val.mde ? -1 : 1);
    }
}

