/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;

public abstract class AbstractPeriodItemSet2<I extends PeriodItem> {
    protected final I[] entries;
    private static final Comparator<PeriodItem> timeFromComparator = new Comparator<PeriodItem>(){

        @Override
        public int compare(PeriodItem o1, PeriodItem o2) {
            long c = o1.timeFrom - o2.timeFrom;
            if (c > 0L) {
                return 1;
            }
            if (c < 0L) {
                return -1;
            }
            return 0;
        }
    };

    protected AbstractPeriodItemSet2(List<I> entryList) {
        this.entries = entryList.toArray(this.newArray(entryList.size()));
    }

    protected AbstractPeriodItemSet2(I[] entries) {
        this.entries = entries;
    }

    protected abstract I[] newArray(int var1);

    protected boolean isCoincide(I item, I other) {
        return ((PeriodItem)other).timeFrom == ((PeriodItem)item).timeFrom && ((PeriodItem)other).timeTo == ((PeriodItem)item).timeTo;
    }

    protected I[] add(I newItem) {
        int index = Arrays.binarySearch(this.entries, newItem, timeFromComparator);
        index = index < 0 ? -index - 1 : ++index;
        PeriodItem[] newEntries = this.newArray(this.entries.length + 1);
        System.arraycopy(this.entries, 0, newEntries, 0, index);
        newEntries[index] = newItem;
        System.arraycopy(this.entries, index, newEntries, index + 1, this.entries.length - index);
        return newEntries;
    }

    protected I[] update(I newItem) {
        for (I item : this.entries) {
            if (!this.isCoincide(item, newItem)) continue;
            PeriodItem[] newEntries = this.newArray(this.entries.length);
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            newEntries[i] = newItem;
            return newEntries;
        }
        return this.add((PeriodItem)newItem);
    }

    protected I[] remove(I oldItem) {
        int size = this.entries.length;
        for (int i = 0; i < size; ++i) {
            I item = this.entries[i];
            if (!this.isCoincide(item, oldItem)) continue;
            PeriodItem[] newEntries = this.newArray(this.entries.length - 1);
            System.arraycopy(this.entries, 0, newEntries, 0, i);
            System.arraycopy(this.entries, i + 1, newEntries, i, this.entries.length - (i + 1));
            return newEntries;
        }
        return this.entries;
    }

    public I get(long millis) {
        for (I item : this.entries) {
            if (((PeriodItem)item).timeFrom > millis && ((PeriodItem)item).timeFrom != 0L || ((PeriodItem)item).timeTo < millis && ((PeriodItem)item).timeTo != 0L) continue;
            return item;
        }
        return null;
    }

    public int size() {
        return this.entries.length;
    }

    public I item(int i) {
        return this.entries[i];
    }

    protected boolean containsMillis(I item, long millis) {
        return !(((PeriodItem)item).timeFrom != 0L && ((PeriodItem)item).timeFrom > millis || ((PeriodItem)item).timeTo != 0L && millis > ((PeriodItem)item).timeTo);
    }

    protected boolean contains(Function<I, Integer> converter, Date time, Set<Integer> ids) {
        return this.contains(converter, time.getTime(), ids);
    }

    protected boolean contains(Function<I, Integer> converter, long millis, Set<Integer> ids) {
        for (I item : this.entries) {
            if (!ids.contains(converter.apply(item)) || !this.containsMillis(item, millis)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsAll(Function<I, Integer> converter, Date time, Set<Integer> ids) {
        return this.containsAll(converter, time.getTime(), ids);
    }

    protected boolean containsAll(Function<I, Integer> converter, long millis, Set<Integer> ids) {
        HashSet<Integer> set = new HashSet<Integer>(ids);
        for (I item : this.entries) {
            if (!this.containsMillis(item, millis)) continue;
            set.remove(converter.apply(item));
        }
        return set.size() == 0;
    }

    protected Set<Integer> ids(Function<I, Integer> converter, Date timeFrom, Date timeTo) {
        return this.ids(converter, timeFrom.getTime(), timeTo.getTime());
    }

    protected Set<Integer> ids(Function<I, Integer> converter, long millisFrom, long millisTo) {
        if (this.entries.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> options = new HashSet<Integer>(4);
        for (I item : this.entries) {
            if (!RangeUtils.intersects(((PeriodItem)item).timeFrom, ((PeriodItem)item).timeTo, millisFrom, millisTo)) continue;
            options.add(converter.apply(item));
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptySet();
    }

    protected Set<Integer> ids(Function<I, Integer> converter, long millis) {
        if (this.entries.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>(8);
        this.ids(converter, millis, result);
        if (result.size() > 0) {
            return result;
        }
        return Collections.emptySet();
    }

    protected void ids(Function<I, Integer> converter, long millis, Set<Integer> result) {
        for (I item : this.entries) {
            if (((PeriodItem)item).timeFrom > millis && ((PeriodItem)item).timeFrom != 0L || ((PeriodItem)item).timeTo < millis && ((PeriodItem)item).timeTo != 0L) continue;
            result.add(converter.apply(item));
        }
    }

    protected void ids(Function<I, Integer> converter, Predicate<I> predicate, long millis, Set<Integer> result) {
        if (predicate != null) {
            for (I item : this.entries) {
                if (((PeriodItem)item).timeFrom > millis && ((PeriodItem)item).timeFrom != 0L || ((PeriodItem)item).timeTo < millis && ((PeriodItem)item).timeTo != 0L || !predicate.test(item)) continue;
                result.add(converter.apply(item));
            }
        } else {
            for (I item : this.entries) {
                if (((PeriodItem)item).timeFrom > millis && ((PeriodItem)item).timeFrom != 0L || ((PeriodItem)item).timeTo < millis && ((PeriodItem)item).timeTo != 0L) continue;
                result.add(converter.apply(item));
            }
        }
    }

    protected Map<Integer, I> map(Function<I, Integer> converter, long timeFrom, long timeTo) {
        if (this.entries.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, I> result = new HashMap<Integer, I>(4);
        for (I item : this.entries) {
            if (!RangeUtils.intersects(((PeriodItem)item).timeFrom, ((PeriodItem)item).timeTo, timeFrom, timeTo)) continue;
            result.put(converter.apply(item), item);
        }
        if (result.size() > 0) {
            return result;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (I item : this.entries) {
            ((PeriodItem)item).toString(result).append('\n');
        }
        return result.toString();
    }

    public static class PeriodItem {
        public final long timeFrom;
        public final long timeTo;

        public PeriodItem(Date timeFrom, Date timeTo) {
            this.timeFrom = timeFrom != null ? timeFrom.getTime() : 0L;
            long l = this.timeTo = timeTo != null ? timeTo.getTime() - 1L : 0L;
            assert (this.timeFrom % 1000L == 0L);
            assert (this.timeTo == 0L || this.timeTo % 1000L == 999L);
        }

        public PeriodItem(long timeFrom, long timeTo) {
            assert (timeFrom % 1000L == 0L);
            assert (timeTo == 0L || timeTo % 1000L == 999L);
            this.timeFrom = timeFrom;
            this.timeTo = timeTo;
        }

        public StringBuilder toString(StringBuilder sb) {
            return sb.append(this.timeFrom == 0L ? "null" : TimeUtils.format(new Date(this.timeFrom), "dd.MM.yyyy HH:mm:ss.S")).append(" - ").append(this.timeTo == 0L ? "null" : TimeUtils.format(new Date(this.timeTo), "dd.MM.yyyy HH:mm:ss.S"));
        }

        public boolean equals(Object obj) {
            PeriodItem other = (PeriodItem)obj;
            return other.timeFrom == this.timeFrom && other.timeTo == this.timeTo;
        }
    }
}

