/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.server;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CaseInsensitiveParameterWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> mapUpercaseKeys = new HashMap<String, String[]>();

    public CaseInsensitiveParameterWrapper(HttpServletRequest request) {
        super(request);
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String[]) {
                this.mapUpercaseKeys.put(((String)entry.getKey()).toUpperCase(), (String[])entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Strange type of map HttpServletRequest.getParameterMap()");
        }
    }

    public String[] getParameterValues(String name) {
        return this.mapUpercaseKeys.get(name.toUpperCase());
    }

    public String getParameter(String name) {
        String[] parameterValues = this.getParameterValues(name);
        return parameterValues != null && parameterValues.length > 0 ? parameterValues[0] : null;
    }
}

