/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.reports;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.ConvertUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class AbstractJRDataSource<F extends JRDataSourceField<E, Object>, E>
implements JRDataSource {
    private Map<String, F> fieldMap = new HashMap<String, F>();
    public E current;

    protected abstract F newField(JRField var1);

    public Object getFieldValue(JRField jrField) throws JRException {
        JRDataSourceField f = (JRDataSourceField)this.fieldMap.get(jrField.getName());
        if (f == null) {
            f = this.newField(jrField);
            this.fieldMap.put(jrField.getName(), f);
        }
        return f.getValue(this.current);
    }

    public abstract boolean next() throws JRException;

    protected static final <K> JRDataSourceField<K, Object> newStringField(JRDataSourceField<K, String> field, JRField jrField) {
        final Class clazz = jrField.getValueClass();
        final String format = jrField.getPropertiesMap().getProperty("format");
        if (clazz.equals(String.class)) {
            return new JRStringDataSourceField<K>((JRDataSourceField)field){

                @Override
                public Object getValue(String val) throws JRException {
                    return val;
                }
            };
        }
        if (clazz.equals(BigDecimal.class)) {
            return new JRStringDataSourceField<K>((JRDataSourceField)field){

                @Override
                public BigDecimal getValue(String text) throws JRException {
                    return Utils.parseBigDecimal(text, BigDecimal.ZERO);
                }
            };
        }
        if (clazz.equals(Integer.class)) {
            return new JRStringDataSourceField<K>((JRDataSourceField)field){

                @Override
                public Object getValue(String text) throws JRException {
                    return Utils.parseInt(text);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            return new JRStringDataSourceField<K>((JRDataSourceField)field){

                @Override
                public Object getValue(String text) throws JRException {
                    return Utils.parseLong(text);
                }
            };
        }
        if (clazz.equals(Float.class)) {
            return new JRStringDataSourceField<K>((JRDataSourceField)field){

                @Override
                public Object getValue(String text) throws JRException {
                    return Float.valueOf(Utils.parseFloat(text, 0.0f));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            return new JRStringDataSourceField<K>((JRDataSourceField)field){

                @Override
                public Object getValue(String text) throws JRException {
                    return Float.valueOf(Utils.parseFloat(text, 0.0f));
                }
            };
        }
        if (clazz.equals(Date.class)) {
            return new JRStringDataSourceField<K>(field){
                private final DateFormat dateFormat;
                {
                    super(field);
                    this.dateFormat = new SimpleDateFormat(format != null ? format : "dd.MM.yyyy");
                }

                @Override
                public Object getValue(String text) throws JRException {
                    return TimeUtils.parseDate(text, this.dateFormat);
                }
            };
        }
        if (clazz.equals(Calendar.class)) {
            return new JRStringDataSourceField<K>(field){
                private final DateFormat dateFormat;
                {
                    super(field);
                    this.dateFormat = new SimpleDateFormat(format != null ? format : "dd.MM.yyyy");
                }

                @Override
                public Object getValue(String text) throws JRException {
                    return TimeUtils.parseCalendar(text, this.dateFormat);
                }
            };
        }
        return new JRStringDataSourceField<K>(field){

            @Override
            public Object getValue(String text) throws JRException {
                return ConvertUtils.convert((String)text.trim(), (Class)clazz);
            }
        };
    }

    public static abstract class AbstractCollectionJRDataSource<E>
    extends AbstractJRDataSource<JRDataSourceField<E, Object>, E>
    implements JRRewindableDataSource {
        private final Collection<E> list;
        private Iterator<E> iterator;

        public AbstractCollectionJRDataSource(Collection<E> list) {
            this.list = list;
            this.iterator = list.iterator();
        }

        public void moveFirst() throws JRException {
            this.iterator = this.list.iterator();
        }

        @Override
        public boolean next() throws JRException {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            this.current = null;
            return false;
        }
    }

    protected static abstract class JRStringDataSourceField<K>
    extends JRDataSourceField<K, Object> {
        private final JRDataSourceField<K, String> field;

        protected JRStringDataSourceField(JRDataSourceField<K, String> field) {
            this.field = field;
        }

        @Override
        public Object getValue(K val) throws JRException {
            return this.getValue(this.field.getValue(val));
        }

        @Override
        protected abstract Object getValue(String var1) throws JRException;
    }

    public static abstract class JRDataSourceField<E, V> {
        public abstract V getValue(E var1) throws JRException;
    }
}

