/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import java.util.Calendar;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ScheduleTime {
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int dayOfWeek = 0;
    private long min = 0L;
    private String humanReadable = "";
    private String humanReadableWithoutTime = "";
    private String dayOfWeekAsString = "";

    public ScheduleTime() {
    }

    public ScheduleTime(ScheduleTime st) {
        this(st.getMonth(), st.getDay(), st.getHour(), st.getDayOfWeek(), st.getMin());
    }

    public ScheduleTime(int month, int day, int hour, int dayOfWeek, long min) {
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.dayOfWeek = dayOfWeek;
        this.min = min;
    }

    public static String serialize(ScheduleTime st) {
        if (st == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(st.min);
        result.append(',');
        result.append(st.hour);
        result.append(',');
        result.append(st.day);
        result.append(',');
        result.append(st.dayOfWeek);
        result.append(',');
        result.append(st.month);
        return result.toString();
    }

    public static ScheduleTime deserialize(String str) {
        if (Utils.isBlankString(str)) {
            return null;
        }
        String[] result = str.split(",");
        return new ScheduleTime(Utils.parseInt(result[4]), Utils.parseInt(result[2]), Utils.parseInt(result[1]), Utils.parseInt(result[3]), Utils.parseLong(result[0]));
    }

    public static String toHumanReadable(ScheduleTime time) {
        return ScheduleTime.toHumanReadable(time, true);
    }

    private static String toHumanReadable(ScheduleTime time, boolean hoursAndMins) {
        if (time == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(100);
        result.append(ScheduleTime.processMonth(time.month));
        String days = ScheduleTime.processDay(time.day);
        if (result.length() > 0 && days.length() > 0) {
            result.append("; ");
        }
        result.append(days);
        String daysOfWeek = ScheduleTime.processDayOfWeek(time.dayOfWeek);
        if (result.length() > 0 && daysOfWeek.length() > 0) {
            result.append("; ");
        }
        result.append(daysOfWeek);
        if (hoursAndMins) {
            String hourAndMinutes = ScheduleTime.processHourAndMinute(time.hour, time.min);
            if (result.length() > 0 && hourAndMinutes.length() > 0) {
                result.append("; ");
            }
            result.append(hourAndMinutes);
            if (result.length() == 0) {
                result.append("\u043a\u0430\u0436\u0434\u0443\u044e \u043c\u0438\u043d\u0443\u0442\u0443");
            }
        }
        return result.toString();
    }

    private static String processHourAndMinute(int hour, long min) {
        String[] hours = Utils.maskToEnum(hour).split(",");
        String[] minutes = Utils.maskToEnum(min).split(",");
        String appender = " \u043c\u0438\u043d\u0443\u0442 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0430\u0441\u0430";
        boolean needAppender = false;
        StringBuilder result = new StringBuilder();
        result.append("\u0432 ");
        for (String hh : hours) {
            boolean hhBlank = Utils.isBlankString(hh);
            if (hhBlank) {
                needAppender = true;
            }
            for (String mm : minutes) {
                boolean mmBlank = Utils.isBlankString(mm);
                if (mmBlank && hhBlank) {
                    return "";
                }
                if (!hhBlank) {
                    result.append(hh);
                    result.append(":");
                }
                result.append(mmBlank ? "00" : mm);
                result.append(", ");
            }
        }
        if (needAppender) {
            result.setLength(result.length() - 2);
            result.append(" \u043c\u0438\u043d\u0443\u0442 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0430\u0441\u0430");
            return result.toString();
        }
        return result.length() > 0 ? result.substring(0, result.length() - 2) : "";
    }

    private static String processDayOfWeek(int dayOfWeek) {
        String result;
        switch (dayOfWeek) {
            case 0: {
                result = "";
                break;
            }
            default: {
                result = ScheduleTime.processNames(dayOfWeek, 7, "\u043f\u043e ", TimeUtils.weekDayName);
            }
        }
        return result;
    }

    private static String processDay(int day) {
        String result;
        switch (day) {
            case 0: {
                result = "";
                break;
            }
            default: {
                result = ScheduleTime.processNumbers(day, 1, 31, "\u043f\u043e ", " \u0447\u0438\u0441\u043b\u0430\u043c");
            }
        }
        return result;
    }

    private static String processMonth(int month) {
        String result;
        switch (month) {
            case 0: {
                result = "";
                break;
            }
            default: {
                result = ScheduleTime.processNames(month, 12, "\u043a\u0430\u0436\u0434\u044b\u0439 ", TimeUtils.monthNames);
            }
        }
        return result;
    }

    private static String processNames(int value, int maximum, String prefix, String[] values) {
        StringBuilder sresult = new StringBuilder();
        for (int i = 0; i < maximum; ++i) {
            if ((value >> i & 1) <= 0) continue;
            if (sresult.length() == 0) {
                sresult.append(prefix);
            }
            sresult.append(values[i] + ", ");
        }
        String result = "";
        if (sresult.length() > 0) {
            result = sresult.substring(0, sresult.length() - 2);
        }
        return result;
    }

    private static String processNumbers(int value, int add, int maximum, String prefix, String suffix) {
        int first = -1;
        int last = -1;
        StringBuilder semiResult = new StringBuilder();
        for (int i = 0; i <= maximum; ++i) {
            if (i != maximum && (value >> i & 1) <= 0) continue;
            if (first != -1 && last + 1 != i) {
                if (first != last) {
                    if (first != last - 1) {
                        semiResult.append("-");
                    } else {
                        semiResult.append(", ");
                    }
                    semiResult.append(last + add);
                }
                semiResult.append(", ");
                first = -1;
                last = i;
            }
            if (i != maximum && first == -1) {
                first = i;
                semiResult.append(first + add);
            }
            last = i;
        }
        String result = "";
        if (semiResult.length() > 0) {
            result = prefix + semiResult.substring(0, semiResult.length() - 2) + suffix;
        }
        return result;
    }

    public boolean isTimeTick(Calendar time) {
        return TimeUtils.checkMasks(time, this.hour, this.dayOfWeek, this.month, this.day, this.min);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public String getHumanReadable() {
        this.humanReadable = ScheduleTime.toHumanReadable(this);
        return this.humanReadable;
    }

    public void setHumanReadable(String s) {
    }

    public String getHumanReadableWithoutTime() {
        this.humanReadableWithoutTime = ScheduleTime.toHumanReadable(this, false);
        return this.humanReadableWithoutTime;
    }

    public void setHumanReadableWithoutTime(String s) {
    }

    public String getDayOfWeekAsString() {
        this.dayOfWeekAsString = Utils.unpackValues(this.dayOfWeek, 1);
        return this.dayOfWeekAsString;
    }

    public void setDayOfWeekAsString(String s) {
    }
}

