/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.inet;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.bind.annotation.XmlAttribute;

public class IpAddress
implements Comparable<IpAddress>,
Serializable {
    static final BigInteger mask4 = new BigInteger(new byte[]{-1, -1, -1, -1});
    static final BigInteger mask16 = new BigInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    static final BigInteger two = BigInteger.valueOf(2L);
    private static final byte[] nullBytes = new byte[24];
    public static final IpAddress ZERO_ADDRESS = new IpAddress(new byte[]{0, 0, 0, 0});
    public static final IpAddress IPV6_ZERO_ADDRESS = new IpAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    @XmlAttribute(name="addr")
    public byte[] address;
    public static final Comparator<byte[]> comparator = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return IpAddress.compare(o1, 0, o1.length, o2, 0, o2.length);
        }
    };

    public IpAddress() {
    }

    public IpAddress(byte[] address) {
        this.address = address;
    }

    public int hashCode() {
        return IpAddress.hashCode(this.address);
    }

    public static int hashCode(byte[] a2) {
        if (a2 == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < a2.length; ++i) {
            result = 31 * result + a2[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        byte[] a2 = this.address;
        byte[] a22 = ((IpAddress)obj).address;
        return IpAddress.equals(a2, a22);
    }

    public static boolean equals(byte[] a2, byte[] a22) {
        if (a2 == a22) {
            return true;
        }
        if (a2 == null || a22 == null) {
            return false;
        }
        int length = a2.length;
        if (a22.length != length) {
            return false;
        }
        if (a2.length == 16) {
            int i;
            for (i = 7; i >= 0; --i) {
                if (a2[i] == a22[i]) continue;
                return false;
            }
            for (i = 15; i >= 8; --i) {
                if (a2[i] == a22[i]) continue;
                return false;
            }
        } else {
            for (int i = length - 1; i >= 0; --i) {
                if (a2[i] == a22[i]) continue;
                return false;
            }
        }
        return true;
    }

    public void clear() {
        System.arraycopy(nullBytes, 0, this.address, 0, this.address.length);
    }

    public String toString() {
        return IpAddress.toString(this.address);
    }

    public static String toString(byte[] address) {
        StringBuilder sb = new StringBuilder(64);
        IpAddress.toString(address, sb);
        return sb.toString();
    }

    public static void toString(byte[] address, StringBuilder sb) {
        if (address == null) {
            sb.append("[IpAddress:null]");
            return;
        }
        if (address.length == 4) {
            sb.append(address[0] & 0xFF).append('.').append(address[1] & 0xFF).append('.').append(address[2] & 0xFF).append('.').append(address[3] & 0xFF);
            return;
        }
        int size = address.length;
        for (int i = 0; i < size; i += 2) {
            int k = address[i + 1] & 0xFF | address[i] << 8 & 0xFF00;
            sb.append(Integer.toHexString(k));
            sb.append(":");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
    }

    public static final int compare(byte[] v1, byte[] v2) {
        int lim = v1.length;
        for (int k = 0; k < lim; ++k) {
            short c1 = (short)(v1[k] & 0xFF);
            short c2 = (short)(v2[k] & 0xFF);
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return 0;
    }

    public static final int compare(byte[] v1, int i, int len1, byte[] v2, int j, int len2) {
        int n = Math.min(len1, len2);
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                short c1 = (short)(v1[k] & 0xFF);
                short c2 = (short)(v2[k] & 0xFF);
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                short c2;
                short c1;
                if ((c1 = (short)(v1[i++] & 0xFF)) == (c2 = (short)(v2[j++] & 0xFF))) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public static byte[] newAndIncrement(byte[] ip) {
        byte[] result = new byte[ip.length];
        System.arraycopy(ip, 0, result, 0, ip.length);
        if (IpAddress.increment(result)) {
            return result;
        }
        return null;
    }

    public static boolean increment(byte[] ip) {
        return IpAddress.increment(ip, 0);
    }

    public static boolean increment(byte[] ip, int fromBit) {
        int pos = ip.length - 1 - fromBit / 8;
        int bit = fromBit % 8;
        if (bit > 0) {
            int v = (short)(ip[pos] & 0xFF) + (1 << bit);
            if (v <= 255) {
                ip[pos] = (byte)(v & 0xFF);
                return true;
            }
            ip[pos--] = 0;
        }
        for (int i = pos; i >= 0; --i) {
            short v = (short)(ip[i] & 0xFF);
            if (v < 255) {
                ip[i] = (byte)(v + 1 & 0xFF);
                return true;
            }
            ip[i] = 0;
        }
        return false;
    }

    public static boolean add(byte[] ip, long delta) {
        boolean result = true;
        if (delta < 0L) {
            return false;
        }
        for (long i = 0L; i < delta; ++i) {
            result &= IpAddress.increment(ip);
        }
        return result;
    }

    public static boolean substract(byte[] ip, int delta) {
        boolean result = true;
        if (delta < 0) {
            return false;
        }
        for (long i = 0L; i < (long)delta; ++i) {
            result &= IpAddress.decrement(ip);
        }
        return result;
    }

    public static boolean decrement(byte[] ip) {
        int pos;
        for (int i = pos = ip.length - 1; i >= 0; --i) {
            short v = (short)(ip[i] & 0xFF);
            if (v > 0) {
                ip[i] = (byte)(v - 1 & 0xFF);
                return true;
            }
            ip[i] = -1;
        }
        return false;
    }

    public static byte[] newAndDecrement(byte[] ip) {
        byte[] result = new byte[ip.length];
        System.arraycopy(ip, 0, result, 0, ip.length);
        for (int i = ip.length - 1; i >= 0; --i) {
            short v = (short)(result[i] & 0xFF);
            if (v > 0) {
                result[i] = (byte)(v - 1 & 0xFF);
                return result;
            }
            result[i] = -1;
        }
        return null;
    }

    @Override
    public int compareTo(IpAddress o) {
        return IpAddress.compare(this.address, 0, this.address.length, o.address, 0, o.address.length);
    }

    public IpAddress clone() {
        byte[] addr = new byte[this.address.length];
        System.arraycopy(this.address, 0, addr, 0, addr.length);
        return new IpAddress(addr);
    }

    @Deprecated
    public static boolean instersect(byte[] addressFrom, byte[] addressTo, byte[] addressFrom2, byte[] addressTo2) {
        if (addressFrom == null || addressTo == null || addressFrom2 == null || addressTo2 == null) {
            throw new NullPointerException();
        }
        return IpAddress.compare(addressFrom, addressTo2) <= 0 && IpAddress.compare(addressTo, addressFrom2) >= 0;
    }

    @Deprecated
    public static boolean rangeInRange(byte[] addressFrom, byte[] addressTo, byte[] addressFrom2, byte[] addressTo2) {
        if (addressFrom == null || addressTo == null || addressFrom2 == null || addressTo2 == null) {
            throw new NullPointerException();
        }
        return IpAddress.compare(addressFrom, addressFrom2) <= 0 && IpAddress.compare(addressTo, addressTo2) >= 0;
    }

    @Deprecated
    public static boolean ipInRange(byte[] ip, byte[] addressFrom, byte[] addressTo) {
        return IpAddress.compare(addressFrom, ip) <= 0 && IpAddress.compare(addressTo, ip) >= 0;
    }

    public static BigInteger convertIp4AddresToBigInt(byte[] address) {
        byte[] address2 = new byte[address[0] < 0 ? 5 : 4];
        System.arraycopy(address, 0, address2, address[0] < 0 ? 1 : 0, 4);
        return new BigInteger(address2);
    }

    public static byte[] convertBigIntToIp4Address(BigInteger bigInteger) {
        byte[] address = bigInteger.toByteArray();
        byte[] address2 = new byte[]{0, 0, 0, 0};
        System.arraycopy(address, address.length == 5 ? 1 : 0, address2, address.length == 5 ? 0 : 4 - address.length, address.length == 5 ? 4 : address.length);
        return address2;
    }

    @Deprecated
    public static String formatRange(IpAddress from, IpAddress to) {
        StringBuilder result = new StringBuilder(50);
        if (to == null) {
            result.append(from);
        } else {
            result.append(from);
            result.append("-");
            result.append(to);
        }
        return result.toString();
    }

    @Deprecated
    public static String formatRange(byte[] from, byte[] to) {
        StringBuilder result = new StringBuilder(50);
        if (to == null) {
            result.append(IpAddress.toString(from));
        } else {
            result.append(IpAddress.toString(from));
            result.append("-");
            result.append(IpAddress.toString(to));
        }
        return result.toString();
    }

    public static boolean nextPrefix(byte[] ip, int prefixLength) {
        boolean ipv6 = ip.length == 16;
        int fromBit = ipv6 ? 128 - prefixLength : 32 - prefixLength;
        int pos = ip.length - 1 - fromBit / 8;
        int bit = fromBit % 8;
        boolean wasChanged = false;
        if (bit > 0) {
            byte old = ip[pos];
            ip[pos] = (byte)(ip[pos] & (byte)(255 << bit) & 0xFF);
            wasChanged = old != ip[pos];
        }
        for (int i = pos + 1; i < ip.length; ++i) {
            if (ip[i] == 0) continue;
            ip[i] = 0;
            wasChanged |= true;
        }
        if (wasChanged) {
            return IpAddress.increment(ip, fromBit);
        }
        return true;
    }

    public static String toRFCString(byte[] address) {
        if (address == null) {
            return "[IpAddress:null]";
        }
        if (address.length == 4) {
            return (address[0] & 0xFF) + "." + (address[1] & 0xFF) + "." + (address[2] & 0xFF) + "." + (address[3] & 0xFF);
        }
        int[] hextets = new int[8];
        int j = 0;
        int size = address.length;
        for (int i = 0; i < size; i += 2) {
            hextets[j++] = address[i + 1] & 0xFF | address[i] << 8 & 0xFF00;
        }
        IpAddress.compressLongestRunOfZeroes(hextets);
        return IpAddress.hextetsToIPv6String(hextets, new StringBuilder(39));
    }

    public static void toRFCString(byte[] address, StringBuilder sb) {
        if (address == null) {
            sb.append("[IpAddress:null]");
            return;
        }
        if (address.length == 4) {
            sb.append((address[0] & 0xFF) + "." + (address[1] & 0xFF) + "." + (address[2] & 0xFF) + "." + (address[3] & 0xFF));
            return;
        }
        int[] hextets = new int[8];
        int j = 0;
        int size = address.length;
        for (int i = 0; i < size; i += 2) {
            hextets[j++] = address[i + 1] & 0xFF | address[i] << 8 & 0xFF00;
        }
        IpAddress.compressLongestRunOfZeroes(hextets);
        IpAddress.hextetsToIPv6String(hextets, sb);
    }

    private static void compressLongestRunOfZeroes(int[] hextets) {
        int bestRunStart = -1;
        int bestRunLength = -1;
        int runStart = -1;
        for (int i = 0; i < hextets.length + 1; ++i) {
            if (i < hextets.length && hextets[i] == 0) {
                if (runStart >= 0) continue;
                runStart = i;
                continue;
            }
            if (runStart < 0) continue;
            int runLength = i - runStart;
            if (runLength > bestRunLength) {
                bestRunStart = runStart;
                bestRunLength = runLength;
            }
            runStart = -1;
        }
        if (bestRunLength >= 2) {
            Arrays.fill(hextets, bestRunStart, bestRunStart + bestRunLength, -1);
        }
    }

    private static String hextetsToIPv6String(int[] hextets, StringBuilder buf) {
        boolean lastWasNumber = false;
        for (int i = 0; i < hextets.length; ++i) {
            boolean thisIsNumber;
            boolean bl = thisIsNumber = hextets[i] >= 0;
            if (thisIsNumber) {
                if (lastWasNumber) {
                    buf.append(':');
                }
                buf.append(Integer.toHexString(hextets[i]));
            } else if (i == 0 || lastWasNumber) {
                buf.append("::");
            }
            lastWasNumber = thisIsNumber;
        }
        return buf.toString();
    }
}

