/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.dao;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.Column;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public abstract class AbstractDao<B>
extends AbstarctDaoConstant
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(AbstractDao.class);
    protected static final Pattern orderByPattern = Pattern.compile("\\A[\\w\\s\\d,_\\-\\.]+\\z");
    protected final Connection con;
    @Deprecated
    protected final int mid;
    protected final int moduleId;
    protected final String tableName;
    protected String cacheWhat;
    protected String cacheJoin;
    protected String cacheFilter;
    protected String cacheOrderBy;
    protected boolean cachePaged;
    protected PreparedStatement cachePS;
    protected PreparedStatement getByIdPS = null;

    public AbstractDao(Connection con, int moduleId, String tableName) {
        this(con, moduleId, tableName, null);
    }

    public AbstractDao(Connection con, int moduleId, String tableName, Date date) {
        this.con = con;
        this.mid = this.moduleId = moduleId;
        this.tableName = this.getTableName(tableName, moduleId, date);
    }

    protected String getTableName(String tableName, int moduleId, Date date) {
        if (moduleId > 0) {
            if (date != null) {
                return ServerUtils.getModuleMonthTableName(tableName, date, moduleId);
            }
            return tableName + "_" + moduleId;
        }
        if (date != null) {
            return ServerUtils.getMonthTableName(tableName, date);
        }
        return tableName;
    }

    protected void processException(SQLException e) throws BGException {
        throw new BGException(e.getMessage() + " [" + e.getSQLState() + ", " + e.getErrorCode() + "]", e);
    }

    protected abstract B getFromRS(ResultSet var1) throws SQLException, BGException;

    protected PreparedStatement listImplPS(String what, String filter, String orderBy, int pageIndex, int pageSize) throws SQLException, BGException {
        return this.listImplPS(what, null, filter, orderBy, pageIndex, pageSize);
    }

    protected PreparedStatement listImplPS(String what, String join, String filter, String orderBy, int pageIndex, int pageSize) throws SQLException, BGException {
        StringBuilder sb = new StringBuilder().append("SELECT ");
        sb.append(what).append(" FROM ").append(this.tableName);
        if (join != null && join.length() > 0) {
            sb.append(" ").append(join);
        }
        if (filter != null && filter.length() > 0) {
            sb.append(" WHERE ").append(filter);
        }
        if (orderBy != null && orderBy.length() > 0) {
            if (!orderByPattern.matcher(orderBy).matches()) {
                throw new BGException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
            }
            sb.append(" ORDER BY ").append(orderBy);
        }
        if (pageSize > 0 && pageIndex > 0) {
            sb.append(" LIMIT ?, ?");
        }
        return this.con.prepareStatement(sb.toString());
    }

    protected List<B> getListFromRS(ResultSet rs) throws SQLException, BGException {
        ArrayList<B> result = new ArrayList<B>();
        while (rs.next()) {
            result.add(this.getFromRS(rs));
        }
        return result;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected List<B> listImpl(Page page, String what, String join, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        PreparedStatement ps;
        int pageIndex;
        ArrayList<B> result = new ArrayList<B>();
        int pageSize = page != null ? page.getPageSize() : 0;
        int n = pageIndex = page != null ? page.getPageIndex() : 0;
        if (pageIndex <= 0) {
            pageSize = 0;
        }
        if (this.cachePS != null && this.eq(what, this.cacheWhat) && this.eq(join, this.cacheJoin) && this.eq(filter, this.cacheFilter) && this.eq(orderBy, this.cacheOrderBy) && pageSize > 0 == this.cachePaged) {
            ps = this.cachePS;
        } else {
            if (this.cachePS != null) {
                this.cachePS.close();
                this.cachePS = null;
            }
            this.cachePS = ps = this.listImplPS(what, join, filter, orderBy, pageIndex, pageSize);
            this.cacheWhat = what;
            this.cacheFilter = filter;
            this.cacheOrderBy = orderBy;
            this.cachePaged = pageSize > 0;
            this.cacheJoin = join;
        }
        int idx = 0;
        for (int i = 0; i < params.length; ++i) {
            AbstractDao.setStatementParam(ps, ++idx, params[i]);
        }
        if (pageSize > 0) {
            ps.setInt(++idx, (pageIndex - 1) * pageSize);
            ps.setInt(++idx, pageSize);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("psList = " + ps));
        }
        ResultSet rs = ps.executeQuery();
        if (what.contains("SQL_CALC_FOUND_ROWS")) {
            page.setRecordCount(ServerUtils.foundRows(this.con));
        }
        while (rs.next()) {
            result.add(this.getFromRS(rs));
        }
        rs.close();
        return result;
    }

    protected static void setStatementParam(PreparedStatement ps, int idx, Object param) throws SQLException {
        if (param instanceof Calendar) {
            logger.error((Object)("param #" + idx + " has type Calendar"), (Throwable)new BGException());
            param = ((Calendar)param).getTime();
        }
        ps.setObject(idx, param);
    }

    protected List<B> listImpl(Page page, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        return this.listImpl(page, "*", null, filter, orderBy, params);
    }

    protected List<B> list(String filter, String orderBy, Object ... params) throws BGException {
        try {
            return this.listImpl(new Page(), filter, orderBy, params);
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    protected Result<B> list(Page page, String filter, String orderBy, Object ... params) throws BGException {
        try {
            List<B> result = this.listImpl(page, "SQL_CALC_FOUND_ROWS *", null, filter, orderBy, params);
            return new Result<B>(result, page);
        }
        catch (SQLException e) {
            this.processException(e);
            return new Result(Collections.emptyList());
        }
    }

    protected B get(String filter, Object ... params) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + filter);
            for (int i = 0; i < params.length; ++i) {
                AbstractDao.setStatementParam(ps, i + 1, params[i]);
            }
            ResultSet rs = ps.executeQuery();
            B result = rs.next() ? (B)this.getFromRS(rs) : null;
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return null;
        }
    }

    protected int delete(String filter, Object ... params) throws BGException {
        int result = 0;
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + filter);
            for (int i = 0; i < params.length; ++i) {
                AbstractDao.setStatementParam(ps, i + 1, params[i]);
            }
            result = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    protected B getImpl(int id) throws BGException, SQLException {
        return this.getById(id);
    }

    protected B getById(int id) throws BGException, SQLException {
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            ps = this.getByIdPS = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=?");
        }
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        B result = rs.next() ? (B)this.getFromRS(rs) : null;
        rs.close();
        return result;
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        return this.delete("id=?", id);
    }

    protected abstract void updateImpl(B var1) throws BGException, SQLException;

    public void update(B b2) throws BGException {
        try {
            this.updateImpl(b2);
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    public void recycle() throws BGException {
        try {
            if (this.getByIdPS != null) {
                this.getByIdPS.close();
                this.getByIdPS = null;
            }
            if (this.cachePS != null) {
                this.cachePS.close();
                this.cachePS = null;
                this.cacheWhat = null;
                this.cacheJoin = null;
                this.cacheFilter = null;
                this.cacheOrderBy = null;
                this.cachePaged = false;
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public String getSQLOrder(List<String> sortFields, String[] fieldNames) {
        StringBuilder order = new StringBuilder();
        if (sortFields != null) {
            block0: for (String field : sortFields) {
                String[] data = field.split(":");
                if (data.length != 2) continue;
                for (String fieldName : fieldNames) {
                    if (!fieldName.equals(data[0])) continue;
                    if (order.length() > 0) {
                        order.append(", ");
                    }
                    order.append(fieldName).append("0".equals(data[1]) ? "" : " DESC");
                    continue block0;
                }
            }
        }
        return order.length() > 0 ? " ORDER BY ".concat(order.toString()) : "";
    }

    @Override
    public void close() throws BGException {
        this.recycle();
    }

    protected Period getPeriod(ResultSet rs) throws SQLException {
        Period period = new Period();
        period.setDateFrom(rs.getDate("date_from"));
        period.setDateTo(rs.getDate("date_to"));
        return period;
    }

    protected <T> T ormFromResultSet(ResultSet rs, Class<T> clazz) throws SQLException, BGException {
        T t;
        try {
            t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<T> currentClass = clazz;
            while (!currentClass.equals(Object.class)) {
                block5: for (Method method : currentClass.getMethods()) {
                    if (method.getName().equals("setPeriod")) {
                        method.invoke(t, this.getPeriod(rs));
                        continue;
                    }
                    if (!method.getName().startsWith("set")) continue;
                    for (Annotation annotation : method.getAnnotations()) {
                        String columnName;
                        if (!annotation.annotationType().equals(Column.class)) continue;
                        Column column = (Column)annotation;
                        String string = columnName = column.name().isEmpty() ? null : column.name();
                        if (columnName == null || method.getParameterCount() != 1) continue block5;
                        if (method.getParameterTypes()[0].equals(Integer.TYPE)) {
                            method.invoke(t, rs.getInt(columnName));
                            continue block5;
                        }
                        if (method.getParameterTypes()[0].equals(String.class)) {
                            method.invoke(t, rs.getString(columnName));
                            continue block5;
                        }
                        if (method.getParameterTypes()[0].equals(Boolean.TYPE)) {
                            method.invoke(t, rs.getBoolean(columnName));
                            continue block5;
                        }
                        if (!method.getParameterTypes()[0].isEnum()) continue block5;
                        Class<?> enumClass = method.getParameterTypes()[0];
                        try {
                            Method getMethod = enumClass.getDeclaredMethod("get" + enumClass.getSimpleName() + "ByCode", Integer.TYPE);
                            method.invoke(t, getMethod.invoke(null, rs.getInt(columnName)));
                        }
                        catch (Exception exception) {}
                        continue block5;
                    }
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return t;
    }

    protected void ormUpdateImpl(Object bean) throws BGException, SQLException {
        this.ormUpdateImpl(bean, null, null, null, null);
    }

    protected void ormUpdateImpl(Object bean, String extraQuerySet, String extraQueryWhere, Object[] extraSetParams, Object[] extraWhereParams) throws BGException, SQLException {
        try {
            int n;
            Class<?> clazz = bean.getClass();
            Method getIdMethod = clazz.getMethod("getId", new Class[0]);
            boolean insert = (Integer)getIdMethod.invoke(bean, new Object[0]) < 1;
            StringBuffer query = new StringBuffer((insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET ");
            StringBuffer setQuery = new StringBuffer(extraQuerySet == null ? "" : extraQuerySet);
            block13: for (Method method : clazz.getDeclaredMethods()) {
                if (method.getName().equals("getPeriod")) {
                    if (setQuery.length() > 0) {
                        setQuery.append(", ");
                    }
                    setQuery.append("date_from=?, date_to=?");
                    continue;
                }
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                Annotation[] annotationArray = method.getAnnotations();
                n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    String columnName;
                    Annotation annotation = annotationArray[i];
                    if (!annotation.annotationType().equals(Column.class)) continue;
                    Column column = (Column)annotation;
                    String string = columnName = column.name().isEmpty() ? null : column.name();
                    if (setQuery.length() > 0) {
                        setQuery.append(", ");
                    }
                    setQuery.append(columnName).append("=?");
                    continue block13;
                }
            }
            query.append(setQuery);
            if (!insert) {
                query.append(" WHERE id=?").append(extraQueryWhere == null ? "" : extraQueryWhere);
            }
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int index = 1;
                if (extraSetParams != null) {
                    Object[] objectArray = extraSetParams;
                    int n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        Object object = objectArray[n];
                    }
                }
                block16: for (Method method : clazz.getDeclaredMethods()) {
                    if (method.getName().equals("getPeriod")) {
                        Period period = (Period)method.invoke(bean, new Object[0]);
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateTo()));
                        continue;
                    }
                    if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                    for (Annotation annotation : method.getAnnotations()) {
                        if (!annotation.annotationType().equals(Column.class)) continue;
                        Class<?> returnClass = method.getReturnType();
                        if (returnClass.equals(Integer.TYPE)) {
                            ps.setInt(index++, (Integer)method.invoke(bean, new Object[0]));
                            continue block16;
                        }
                        if (returnClass.equals(Boolean.TYPE)) {
                            ps.setBoolean(index++, (Boolean)method.invoke(bean, new Object[0]));
                            continue block16;
                        }
                        if (returnClass.equals(String.class)) {
                            ps.setString(index++, (String)method.invoke(bean, new Object[0]));
                            continue block16;
                        }
                        if (!returnClass.isEnum()) continue block16;
                        try {
                            Method getCode = returnClass.getMethod("getCode", new Class[0]);
                            ps.setInt(index++, (Integer)getCode.invoke(method.invoke(bean, new Object[0]), new Object[0]));
                        }
                        catch (Exception exception) {}
                        continue block16;
                    }
                }
                if (!insert) {
                    ps.setInt(index++, (Integer)getIdMethod.invoke(bean, new Object[0]));
                    if (extraWhereParams != null) {
                        for (Object object : extraWhereParams) {
                        }
                    }
                }
                ps.executeUpdate();
                if (insert) {
                    Method method = clazz.getMethod("setId", Integer.TYPE);
                    method.invoke(bean, ServerUtils.lastInsertId(this.con));
                }
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public final class ResultSetIterator
    implements Iterable<B>,
    Iterator<B>,
    Closeable {
        private final ResultSet rs;
        private boolean hasNext;
        private final Statement closeOnEndStatement;

        public ResultSetIterator(ResultSet rs) throws BGException {
            this(rs, null);
        }

        public ResultSetIterator(ResultSet rs, Statement closeOnEndStatement) throws BGException {
            this.rs = rs;
            this.closeOnEndStatement = closeOnEndStatement;
            try {
                this.hasNext = rs.next();
            }
            catch (SQLException e) {
                this.hasNext = false;
                throw new BGException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public B next() {
            try {
                Object result = AbstractDao.this.getFromRS(this.rs);
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    this.close();
                }
                return result;
            }
            catch (Exception e) {
                this.hasNext = false;
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void close() {
            try {
                if (this.closeOnEndStatement != null) {
                    this.closeOnEndStatement.close();
                    if (this.closeOnEndStatement != this.rs.getStatement()) {
                        this.rs.close();
                    }
                } else {
                    this.rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public Iterator<B> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

