/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeUtils {
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY = "dd.MM.yyyy";

    public static LocalDate parseLocalDate(String value, String dateFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        LocalDate date = null;
        if (value != null) {
            try {
                date = LocalDate.parse(value, formatter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static final String format(LocalDate localDate, String dateFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        return localDate == null ? "" : localDate.format(formatter);
    }

    public static final LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        return zdt.toLocalDate();
    }

    public static Date toOldDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        Instant instantStartOfDay = date.atStartOfDay(ZoneId.systemDefault()).toInstant();
        return Date.from(instantStartOfDay);
    }
}

