/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.utils.javawebstart;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BGClient_JavaWebStart {
    public static void main(String[] args) {
        String db_driver = null;
        String db_url = null;
        String db_user = null;
        String db_pswd = null;
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(new Attributes.Name("Permissions"), "all-permissions");
            manifest.getMainAttributes().put(new Attributes.Name("Application-Name"), "BGBilling GUI client");
            manifest.getMainAttributes().put(new Attributes.Name("Codebase"), System.getProperty("codebase", "*"));
            HashSet clientZipEntryNameSet = new HashSet();
            HashSet<String> libsZipEntryNameSet = new HashSet<String>();
            JarOutputStream jarClientOutputStream = new JarOutputStream((OutputStream)new FileOutputStream("client.jar"), manifest);
            jarClientOutputStream.setLevel(-1);
            JarOutputStream jarLibOutputStream = new JarOutputStream((OutputStream)new FileOutputStream("client_libs.jar"), manifest);
            jarLibOutputStream.setLevel(-1);
            JarEntry jarEntry1 = new JarEntry("plugins/");
            jarEntry1.setTime(System.currentTimeMillis());
            jarClientOutputStream.putNextEntry(jarEntry1);
            jarClientOutputStream.closeEntry();
            StringBuffer pluginList = new StringBuffer();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("data.data");
            db_driver = resourceBundle.getString("db.driver");
            db_url = resourceBundle.getString("db.url");
            db_user = resourceBundle.getString("db.user");
            db_pswd = resourceBundle.getString("db.pswd");
            Class.forName(db_driver);
            Connection con = DriverManager.getConnection(db_url, db_user, db_pswd);
            String query = "SELECT name, client_zip FROM installed_modules ORDER BY name";
            PreparedStatement ps = con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                System.out.println("\nname = " + name + "\n");
                JarOutputStream jarOutputStream = "update_lib".equals(name) ? jarLibOutputStream : jarClientOutputStream;
                HashSet<String> zipEntryNameSet = "update_lib".equals(name) ? libsZipEntryNameSet : clientZipEntryNameSet;
                File moduleDir = new File("client.jars" + File.separatorChar + name);
                if (moduleDir.exists()) {
                    for (String fileName : moduleDir.list()) {
                        if (!fileName.endsWith(".jar")) continue;
                        System.out.print(fileName);
                        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(new File(moduleDir, fileName)));
                        ZipEntry jarEntry = null;
                        while ((jarEntry = jarInputStream.getNextEntry()) != null) {
                            JarEntry jarEntry2;
                            String jarEntryName = jarEntry.getName();
                            if (jarEntryName.equals("META-INF/MANIFEST.MF")) continue;
                            byte[] bytes = BGClient_JavaWebStart.readByBlock(jarInputStream);
                            if ("plugin.xml".equals(jarEntryName)) {
                                jarEntry2 = new JarEntry("plugins/" + name + ".xml");
                                jarEntry2.setTime(jarEntry.getTime());
                                jarOutputStream.putNextEntry(jarEntry2);
                                jarOutputStream.write(bytes);
                                jarOutputStream.closeEntry();
                                pluginList.append(name);
                                pluginList.append(".xml\n");
                                continue;
                            }
                            if (zipEntryNameSet.contains(jarEntryName)) continue;
                            zipEntryNameSet.add(jarEntryName);
                            try {
                                jarEntry2 = new JarEntry(jarEntry.getName());
                                jarEntry2.setTime(jarEntry.getTime());
                                jarOutputStream.putNextEntry(jarEntry2);
                                jarOutputStream.write(bytes);
                                jarOutputStream.closeEntry();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        System.out.println();
                    }
                    continue;
                }
                ZipInputStream zis = new ZipInputStream(rs.getBinaryStream(2));
                ZipEntry zipEntry = null;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    String zipEntryName = zipEntry.getName();
                    if (!zipEntryName.endsWith(".jar")) continue;
                    System.out.print(zipEntryName);
                    ZipInputStream jarInputStream = new ZipInputStream(zis);
                    ZipEntry jarEntry = null;
                    while ((jarEntry = jarInputStream.getNextEntry()) != null) {
                        JarEntry jarEntry2;
                        String jarEntryName = jarEntry.getName();
                        if (jarEntryName.equals("META-INF/MANIFEST.MF")) continue;
                        byte[] bytes = BGClient_JavaWebStart.readByBlock(jarInputStream);
                        if ("plugin.xml".equals(jarEntryName)) {
                            jarEntry2 = new JarEntry("plugins/" + name + ".xml");
                            jarEntry2.setTime(jarEntry.getTime());
                            jarOutputStream.putNextEntry(jarEntry2);
                            jarOutputStream.write(bytes);
                            jarOutputStream.closeEntry();
                            pluginList.append(name);
                            pluginList.append(".xml\n");
                            continue;
                        }
                        if (zipEntryNameSet.contains(jarEntryName)) continue;
                        zipEntryNameSet.add(jarEntryName);
                        try {
                            jarEntry2 = new JarEntry(jarEntry.getName());
                            jarEntry2.setTime(jarEntry.getTime());
                            jarOutputStream.putNextEntry(jarEntry2);
                            jarOutputStream.write(bytes);
                            jarOutputStream.closeEntry();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println();
                }
                zis.close();
            }
            rs.close();
            JarEntry jarEntry2 = new JarEntry("plugins/list.txt");
            jarEntry2.setTime(System.currentTimeMillis());
            jarClientOutputStream.putNextEntry(jarEntry2);
            jarClientOutputStream.write(pluginList.toString().getBytes());
            jarClientOutputStream.closeEntry();
            jarClientOutputStream.close();
            jarLibOutputStream.close();
        }
        catch (Exception ex) {
            System.err.println("db.driver = " + db_driver);
            System.err.println("db.url = " + db_url);
            System.err.println("db.user = " + db_user);
            System.err.println("db.pswd = " + db_pswd);
            ex.printStackTrace();
        }
    }

    public static byte[] readByBlock(InputStream input) throws IOException {
        BufferedInputStream bf = new BufferedInputStream(input);
        Vector<byte[]> blocks = new Vector<byte[]>(5, 5);
        Vector<Integer> blocksLength = new Vector<Integer>(5, 5);
        int BLOCK_LENGTH = 1024;
        int readByte = 0;
        int bytesTotal = 0;
        do {
            byte[] data;
            if ((readByte = bf.read(data = new byte[1024], 0, 1024)) <= 0) continue;
            bytesTotal += readByte;
            blocks.addElement(data);
            blocksLength.addElement(readByte);
        } while (readByte != -1);
        int joffset = 0;
        byte[] allData = new byte[bytesTotal];
        for (int i = 0; i < blocks.size(); ++i) {
            readByte = (Integer)blocksLength.elementAt(i);
            System.arraycopy(blocks.elementAt(i), 0, allData, joffset, readByte);
            joffset += readByte;
        }
        return allData;
    }
}

