/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.util.MailMsg;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class Checker {
    private static final int MIN_IDLE_DEFAULT = 1;
    private static final int MAX_IDLE_DEFAULT = 20;
    private static final int MAX_ACTIVE_DEFAULT = 300;
    private static final String PROPERTY_USER = "user";
    private static final String PROPERTY_PASSWORD = "password";
    private DataSource dataSource = null;

    public Checker() throws BGException {
        DefaultServerSetup setup = new DefaultServerSetup("data.data");
        this.dataSource = Checker.getDataSource(setup);
        StringBuilder result = new StringBuilder();
        result.append(this.checkContractCheckFlag());
        result.append(this.checkContractPatternCommentId());
        result.append(this.checkContractModule("^DU", "6,10,17"));
        result.append(this.checkContractModule("^DF", "3,4,5,6,17"));
        result.append(this.checkContractModule("^HU", "6,10,17"));
        result.append(this.checkContractModule("^HF", "3,4,5,6,17"));
        result.append(this.checkContractParamGroupIdByContractMask("^DF", 5));
        result.append(this.checkContractParamGroupIdByContractMask("^HF", 2));
        result.append(this.checkContractParamGroupIdByContractMask("^DU", 4));
        result.append(this.checkContractParamGroupIdByContractMask("^HU", 3));
        result.append(this.checkHelpdfeskModeByContractMask("^BS", "package"));
        result.append(this.checkHelpdfeskModeByContractMask("^B[0-9]+", "off"));
        result.append(this.checkHelpdfeskModeByContractMask("^[DH]", "on"));
        result.append(this.checkBalanceByContractMask("^H[FU]", 0));
        MailMsg mailMsg = new MailMsg(setup);
        mailMsg.sendMessage("kirill@bitel.ru", "BILLING CHECKER", result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkContractCheckFlag() {
        StringBuilder result = new StringBuilder("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u043b\u0430\u0433\u0430 \u0421\u041a\u0420\u042b\u0422\u042b\u0419 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0445 \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0434\u0430\u0442\u0443...\t");
        int count = 0;
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            Statement st = con.createStatement();
            String query = "SELECT title, del, date1, date2 FROM contract WHERE del=1 AND ( isNull(date2) OR date2>now() )";
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                result.append("\n\t");
                result.append(++count);
                result.append(") ");
                result.append(rs.getString("title"));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        if (count == 0) {
            result.append("OK\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkContractPatternCommentId() {
        StringBuilder result = new StringBuilder("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \"\u043a\u043e\u0434 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043a\u043e\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 == 0\"...\t");
        int count = 0;
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT title FROM contract WHERE title_pattern_id=0");
            while (rs.next()) {
                result.append("\n\t");
                result.append(++count);
                result.append(") ");
                result.append(rs.getString("title"));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        if (count == 0) {
            result.append("OK\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkContractModule(String contractMask, String moduleIds) throws BGException {
        StringBuilder result = new StringBuilder("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u043c\u043e\u0434\u0443\u043b\u0435\u0439 (" + moduleIds + ") \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (" + contractMask + ")...\t");
        int count = 0;
        Connection con = null;
        try {
            HashSet<Integer> moduleSet = new HashSet<Integer>();
            for (String moduleId : moduleIds.split(",")) {
                moduleSet.add(Integer.parseInt(moduleId.trim()));
            }
            con = this.dataSource.getConnection();
            ContractModuleManager manager = new ContractModuleManager(con);
            String query = "SELECT id, title FROM contract WHERE title REGEXP ?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, contractMask);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Set<Integer> contractModuleSet = manager.getContractModuleSet(rs.getInt("id"));
                boolean flagA = false;
                Iterator iterator = moduleSet.iterator();
                while (iterator.hasNext()) {
                    int moduleId = (Integer)iterator.next();
                    if (contractModuleSet.contains(moduleId)) continue;
                    flagA = true;
                    break;
                }
                boolean flagB = false;
                for (int moduleId : contractModuleSet) {
                    if (moduleSet.contains(moduleId)) continue;
                    flagB = true;
                    break;
                }
                if (!flagA && !flagB) continue;
                result.append("\n\t");
                result.append(++count);
                result.append(") ");
                result.append(rs.getString("title"));
                if (flagA) {
                    result.append(" [\u043d\u0435 \u0432\u0441\u0435 \u043c\u043e\u0434\u0443\u043b\u0438]");
                }
                if (!flagB) continue;
                result.append(" [\u043b\u0438\u0448\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u0438]");
            }
            rs.close();
            ps.close();
            ServerUtils.closeConnection(con);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        if (count == 0) {
            result.append("OK\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkContractParamGroupIdByContractMask(String contractMask, int paramGroupId) {
        StringBuilder result = new StringBuilder("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0433\u0440\u0443\u043f\u043f\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 (" + paramGroupId + ") \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (" + contractMask + ")...\t");
        int count = 0;
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            String query = "SELECT pgid, title FROM contract WHERE title REGEXP ?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, contractMask);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getInt(1) == paramGroupId) continue;
                result.append("\n\t");
                result.append(++count);
                result.append(") ");
                result.append(rs.getString("title"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        if (count == 0) {
            result.append("OK\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkHelpdfeskModeByContractMask(String contractMask, String helpdeskMode) {
        StringBuilder result = new StringBuilder("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0436\u0438\u043c\u0430 helpdesk (" + helpdeskMode + ") \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (" + contractMask + ")...\t");
        int count = 0;
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            String query = "SELECT title, value FROM contract AS c LEFT JOIN helpdesk_param_13 AS p ON c.id=p.cid AND p.name='mode.id' WHERE c.title REGEXP ?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, contractMask);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String value = rs.getString("value");
                if (value != null && helpdeskMode.equals(value)) continue;
                result.append("\n\t");
                result.append(++count);
                result.append(") ");
                result.append(rs.getString("title"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        if (count == 0) {
            result.append("OK\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkBalanceByContractMask(String contractMask, int summa) {
        StringBuilder result = new StringBuilder("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0431\u0430\u043b\u0430\u043d\u0441 \u043c\u0435\u043d\u044c\u0448\u0435 - " + summa + " \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (" + contractMask + ")...\t");
        int count = 0;
        Connection con = null;
        BigDecimal summaBalance = BigDecimal.ZERO;
        try {
            String query = null;
            con = this.dataSource.getConnection();
            query = "SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? ORDER BY yy*12+mm DESC LIMIT 1";
            PreparedStatement psBalance = con.prepareStatement(query);
            query = "SELECT id, title FROM contract WHERE title REGEXP ? AND ( date2 is null OR date2>now() )";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, contractMask);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BigDecimal balance = null;
                int contractId = rs.getInt("id");
                psBalance.setInt(1, contractId);
                ResultSet rsBalance = psBalance.executeQuery();
                while (rsBalance.next()) {
                    balance = rsBalance.getBigDecimal(1);
                }
                rsBalance.close();
                if (balance != null && balance.intValue() >= summa) continue;
                result.append("\n\t");
                result.append(++count);
                result.append(") ");
                result.append(rs.getString("title"));
                if (balance == null) continue;
                result.append(" [");
                result.append(balance.toPlainString());
                result.append("]");
                summaBalance = summaBalance.add(balance);
            }
            rs.close();
            ps.close();
            psBalance.close();
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(con);
                throw throwable;
            }
            ServerUtils.closeConnection(con);
        }
        ServerUtils.closeConnection(con);
        if (count == 0) {
            result.append("OK\n");
        } else {
            result.append("\n\u0418\u0442\u043e\u0433\u043e: ");
            result.append(summaBalance.toPlainString());
        }
        return result.toString();
    }

    public static final DataSource getDataSource(DefaultServerSetup setup) {
        PoolingDataSource result = null;
        String dbDriver = setup.get("db.driver", null);
        String dbURL = setup.get("db.url", null);
        String dbUser = setup.get("db.user", null);
        String dbPswd = setup.get("db.pswd", null);
        int minIdle = setup.getInt("db.minIdle", 1);
        int maxIdle = setup.getInt("db.maxIdle", 20);
        int maxActive = setup.getInt("db.maxActive", 300);
        Properties properties = new Properties();
        Checker.setDataSourceProperty(properties, PROPERTY_USER, dbUser);
        Checker.setDataSourceProperty(properties, PROPERTY_PASSWORD, dbPswd);
        boolean testOnBorrow = true;
        boolean testOnReturn = false;
        try {
            Class.forName(dbDriver).newInstance();
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, properties);
            GenericObjectPool connectionPool = new GenericObjectPool(null);
            connectionPool.setMinIdle(minIdle);
            connectionPool.setMaxIdle(maxIdle);
            connectionPool.setMaxActive(maxActive);
            connectionPool.setTestOnBorrow(testOnBorrow);
            connectionPool.setTestOnReturn(testOnReturn);
            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, "SELECT 1", false, true);
            result = new PoolingDataSource((ObjectPool)connectionPool);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static final void setDataSourceProperty(Properties properties, String key, String value) {
        if (key != null && value != null) {
            properties.setProperty(key, value);
        }
    }

    public static void main(String[] args) {
        try {
            new Checker();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

