/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.common;

import bitel.billing.common.IPUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiPacketRecord;
import ru.bitel.common.Utils;

public class WiFiPacket {
    public static final byte TYPE_CHECK_RADIUS = 1;
    public static final byte TYPE_CHECK_CLIENT = 2;
    public static final byte TYPE_KILL = 3;
    public static final byte TYPE_ANSWER = 5;
    private String secret = "";
    byte type = 1;
    List<WiFiPacketRecord> ipList = new ArrayList<WiFiPacketRecord>();
    Map<Integer, WiFiPacketRecord> ipMap = new HashMap<Integer, WiFiPacketRecord>();

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public boolean parse(byte[] data) {
        try {
            this.ipList.clear();
            ByteArrayInputStream binput = new ByteArrayInputStream(data);
            DataInputStream in = new DataInputStream(binput);
            this.type = in.readByte();
            if (this.type != 1 && this.type != 2 && this.type != 3 && this.type != 5) {
                throw new RuntimeException("Unxpected type of WiFi packet!!");
            }
            int count = in.readInt();
            if (5 + count * 4 > data.length) {
                throw new RuntimeException("length of count > length of wifi packet");
            }
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                int ip = in.readInt();
                WiFiPacketRecord record = new WiFiPacketRecord(ip);
                this.ipList.add(record);
                buffer.append(IPUtils.convertIpToString(record.getIp()));
            }
            if (!Utils.isEmptyString(this.secret)) {
                buffer.append(this.secret);
                String digest = Utils.getDigest(buffer.toString(), "UTF-8");
                byte len = in.readByte();
                byte[] buff = new byte[len];
                in.read(buff);
                String incomingDigest = null;
                if (len > 0) {
                    incomingDigest = new String(buff, Charset.forName("UTF-8"));
                }
                if (!digest.equals(incomingDigest)) {
                    throw new RuntimeException("security error: digest error!");
                }
            }
            if (this.ipList.size() == 0) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public byte[] serialize() {
        int size = 5 + this.ipList.size() * 4;
        byte[] data = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(size);
            DataOutputStream out = new DataOutputStream(bout);
            out.writeByte(this.type);
            out.writeInt(this.ipList.size());
            StringBuffer buffer = new StringBuffer();
            for (WiFiPacketRecord record : this.ipList) {
                out.writeInt(record.getIp());
                buffer.append(IPUtils.convertIpToString(record.getIp()));
            }
            if (!Utils.isEmptyString(this.secret)) {
                buffer.append(this.secret);
                String digest = Utils.getDigest(buffer.toString(), "UTF-8");
                out.writeByte(digest.length());
                out.write(digest.getBytes(Charset.forName("UTF-8")));
            } else {
                out.write(0);
            }
            out.flush();
            data = bout.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public List<WiFiPacketRecord> getIpList() {
        return this.ipList;
    }

    public void clear() {
        this.ipList.clear();
        this.ipMap.clear();
    }

    public void add(int ip) {
        WiFiPacketRecord record = new WiFiPacketRecord(ip);
        this.add(record);
    }

    public void add(WiFiPacketRecord record) {
        WiFiPacketRecord pair = new WiFiPacketRecord(record.getIp());
        this.ipList.add(pair);
        this.ipMap.put(pair.getIp(), pair);
    }

    public WiFiPacketRecord getIpRecord(int ip) {
        return this.ipMap.get(ip);
    }

    public WiFiPacketRecord getFirstRecord() {
        return this.ipList.size() > 0 ? this.ipList.get(0) : null;
    }

    public StringBuffer print() {
        StringBuffer result = new StringBuffer();
        result.append("packet start............\n");
        result.append("type : " + this.type + "\n");
        result.append("count : " + this.ipList.size() + "\n");
        for (WiFiPacketRecord record : this.ipList) {
            result.append("ip : " + record.getIp() + "\n");
        }
        result.append("packet end............\n");
        return result;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }
}

