/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.task;

import bitel.billing.server.admin.bean.AddressUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.directory.address.AddressArea;
import ru.bitel.bgbilling.kernel.directory.address.AddressCity;
import ru.bitel.bgbilling.kernel.directory.address.AddressDirectoryManager;
import ru.bitel.bgbilling.kernel.directory.address.AddressHouse;
import ru.bitel.bgbilling.kernel.directory.address.AddressQuarter;
import ru.bitel.bgbilling.kernel.directory.address.AddressStreet;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class TaskUpdateAddressDirectory
extends TaskBase {
    private static final String SETUP_KEY_TIME = "address.time";
    private static final String SETUP_KEY_DELETE_ROWS = "address.delete.rows";
    private static final String SETUP_KEY_FLAT_AMOUNT = "key.flat.amount";
    private static final String SETUP_KEY_BOX_INDEX = "key.box.index";
    private static final String DEFAULT_VALUE_FLAT_AMOUNT = ".i.flat.amount";
    private static final String DEFAULT_VALUE_BOX_INDEX = "s.box.index";
    private boolean addressDeleteRows = false;
    private String url = null;
    private String keyFlatAmount = null;
    private String keyBoxIndex = null;

    @Override
    protected boolean initTask() {
        this.url = this.taskSetup.get("url", null);
        this.keyBoxIndex = this.taskSetup.get(SETUP_KEY_BOX_INDEX, DEFAULT_VALUE_BOX_INDEX);
        this.keyFlatAmount = this.taskSetup.get(SETUP_KEY_FLAT_AMOUNT, DEFAULT_VALUE_FLAT_AMOUNT);
        this.addressDeleteRows = Utils.parseBoolean(this.taskSetup.get(SETUP_KEY_DELETE_ROWS, "false"));
        return this.url != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(this.url);
            if (this.url.indexOf("?") > -1) {
                buf.append("&");
            } else {
                buf.append("?");
            }
            buf.append("time=");
            if (this.addressDeleteRows) {
                buf.append("0");
            } else {
                buf.append(ServerUtils.getSetupValue(con, SETUP_KEY_TIME, "0"));
            }
            URL serverURL = new URL(buf.toString());
            HttpURLConnection httpCon = (HttpURLConnection)serverURL.openConnection();
            httpCon.setRequestMethod("GET");
            httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            httpCon.setDoOutput(false);
            httpCon.setDoInput(true);
            if (httpCon.getResponseCode() == 200) {
                Document doc = XMLUtils.parseDocument(new InputSource(httpCon.getInputStream()));
                Element rootElement = doc.getDocumentElement();
                AddressDirectoryManager directoryManager = new AddressDirectoryManager(con);
                try {
                    if (this.addressDeleteRows) {
                        this.deleteAddressRows(directoryManager);
                    }
                    int cc = this.updateAddressCity(directoryManager, XMLUtils.selectElement(rootElement, "//address_city"));
                    int ac = this.updateAddressArea(directoryManager, XMLUtils.selectElement(rootElement, "//address_area"));
                    int qc = this.updateAddressQuarter(directoryManager, XMLUtils.selectElement(rootElement, "//address_quarter"));
                    int sc = this.updateAddressStreet(directoryManager, XMLUtils.selectElement(rootElement, "//address_street"));
                    int hc = this.updateAddressHouse(directoryManager, XMLUtils.selectElement(rootElement, "//address_house"));
                    ServerUtils.setSetupValue(con, SETUP_KEY_TIME, rootElement.getAttribute("time"));
                    this.log.info((Object)(" Records updated: city's = " + cc + "; areas = + " + ac + ";quarters = " + qc + ";streets = " + sc + ";houses = " + hc));
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    private void deleteAddressRows(AddressDirectoryManager directoryManager) throws SQLException {
        directoryManager.deleteCityRows();
        directoryManager.deleteAreaRows();
        directoryManager.deleteStreetRows();
        directoryManager.deleteQuarterRows();
        directoryManager.deleteHouseRows();
    }

    private int updateAddressCity(AddressDirectoryManager directoryManager, Element cityElement) {
        int result = 0;
        if (cityElement != null) {
            for (Element recordElement : XMLUtils.selectElements(cityElement, "record")) {
                AddressCity addressCity = new AddressCity();
                addressCity.setId(Utils.parseInt(recordElement.getAttribute("id"), -1));
                addressCity.setCountryId(Utils.parseInt(recordElement.getAttribute("countryId"), -1));
                addressCity.setTitle(XMLUtils.getAttribute(recordElement, "title", null));
                NodeList recordConfigNodeList = recordElement.getElementsByTagName("config");
                for (int configIndex = 0; configIndex < recordConfigNodeList.getLength(); ++configIndex) {
                    Element recordConfigElement = (Element)recordConfigNodeList.item(configIndex);
                    if (!"pos".equals(recordConfigElement.getAttribute("name"))) continue;
                    addressCity.setPositionIndex(Utils.parseInt(recordConfigElement.getAttribute("value"), 0));
                    break;
                }
                if (addressCity.getId() <= 0 || addressCity.getCountryId() <= 0 || addressCity.getTitle() == null) continue;
                try {
                    this.log.debug((Object)("updateAddressCity country_id: " + addressCity.getCountryId() + ", city_id" + addressCity.getId()));
                    directoryManager.updateCity(addressCity);
                    AddressUtils.onUpdateAddressCity(this.setup, addressCity.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressArea(AddressDirectoryManager directoryManager, Element areaElement) {
        int result = 0;
        if (areaElement != null) {
            for (Element recordElement : XMLUtils.selectElements(areaElement, "record")) {
                AddressArea addressArea = new AddressArea();
                addressArea.setId(Utils.parseInt(recordElement.getAttribute("id"), -1));
                addressArea.setCityId(Utils.parseInt(recordElement.getAttribute("cityId"), -1));
                addressArea.setTitle(XMLUtils.getAttribute(recordElement, "title", null));
                if (addressArea.getId() <= 0 || addressArea.getCityId() <= 0 || addressArea.getTitle() == null) continue;
                try {
                    this.log.debug((Object)("updateAddressArea city_id: " + addressArea.getCityId() + ", area_id" + addressArea.getId()));
                    directoryManager.updateArea(addressArea);
                    AddressUtils.onUpdateAddressArea(this.setup, addressArea.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressQuarter(AddressDirectoryManager directoryManager, Element quarterElement) {
        int result = 0;
        if (quarterElement != null) {
            for (Element recordElement : XMLUtils.selectElements(quarterElement, "record")) {
                AddressQuarter addressQuarter = new AddressQuarter();
                addressQuarter.setId(Utils.parseInt(recordElement.getAttribute("id"), -1));
                addressQuarter.setCityId(Utils.parseInt(recordElement.getAttribute("cityId"), -1));
                addressQuarter.setTitle(XMLUtils.getAttribute(recordElement, "title", null));
                if (addressQuarter.getId() <= 0 || addressQuarter.getCityId() <= 0 || addressQuarter.getTitle() == null) continue;
                try {
                    this.log.debug((Object)("updateAddressQuarter city_id: " + addressQuarter.getCityId() + ", quarter_id" + addressQuarter.getId()));
                    directoryManager.updateQuarter(addressQuarter);
                    AddressUtils.onUpdateAddressQuarter(this.setup, addressQuarter.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressStreet(AddressDirectoryManager directoryManager, Element streetElement) {
        int result = 0;
        if (streetElement != null) {
            for (Element recordElement : XMLUtils.selectElements(streetElement, "record")) {
                AddressStreet addressStreet = new AddressStreet();
                addressStreet.setId(Utils.parseInt(recordElement.getAttribute("id"), -1));
                addressStreet.setCityId(Utils.parseInt(recordElement.getAttribute("cityId"), -1));
                addressStreet.setTitle(XMLUtils.getAttribute(recordElement, "title", null));
                if (addressStreet.getId() <= 0 || addressStreet.getCityId() <= 0 || addressStreet.getTitle() == null) continue;
                this.log.debug((Object)("updateAddressStreet city_id: " + addressStreet.getCityId() + ", street_id" + addressStreet.getId()));
                try {
                    directoryManager.updateStreet(addressStreet);
                    AddressUtils.onUpdateAddressStreet(this.setup, addressStreet.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressHouse(AddressDirectoryManager directoryManager, Element houseElement) {
        int result = 0;
        if (houseElement != null) {
            for (Element recordElement : XMLUtils.selectElements(houseElement, "record")) {
                AddressHouse addressHouse = new AddressHouse();
                addressHouse.setId(Utils.parseInt(recordElement.getAttribute("id"), -1));
                addressHouse.setAreaId(Utils.parseInt(recordElement.getAttribute("areaId"), -1));
                addressHouse.setStreetId(Utils.parseInt(recordElement.getAttribute("streetId"), -1));
                addressHouse.setQuarterId(Utils.parseInt(recordElement.getAttribute("quarterId"), -1));
                addressHouse.setHouse(Utils.parseInt(recordElement.getAttribute("house"), -1));
                addressHouse.setFrac(XMLUtils.getAttribute(recordElement, "frac", null));
                addressHouse.setComment(XMLUtils.getAttribute(recordElement, "comment", null));
                NodeList recordConfigNodeList = recordElement.getElementsByTagName("config");
                for (int configIndex = 0; configIndex < recordConfigNodeList.getLength(); ++configIndex) {
                    Element recordConfigElement = (Element)recordConfigNodeList.item(configIndex);
                    String name = recordConfigElement.getAttribute("name");
                    String value = recordConfigElement.getAttribute("value");
                    if (this.keyBoxIndex.equals(name)) {
                        addressHouse.setPostIndex(value);
                        continue;
                    }
                    if (!this.keyFlatAmount.equals(name)) continue;
                    addressHouse.setAmount(Utils.parseInt(value, 0));
                }
                if (addressHouse.getId() <= 0 || addressHouse.getStreetId() <= 0 || addressHouse.getHouse() <= 0) continue;
                this.log.debug((Object)("updateAddressHouse: " + addressHouse.getId() + ", street_id" + addressHouse.getStreetId() + ", house_id" + addressHouse.getId()));
                try {
                    directoryManager.updateHouse(addressHouse);
                    AddressUtils.onUpdateHouse(this.setup, addressHouse.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }
}

