/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.task;

import bitel.billing.server.admin.integration.bean.Register;
import bitel.billing.server.admin.integration.bean.RegisterLoadData;
import bitel.billing.server.admin.integration.bean.RegisterLoadPattern;
import bitel.billing.server.admin.integration.bean.RegisterLoadPatternManager;
import bitel.billing.server.admin.integration.bean.RegisterManager;
import bitel.billing.server.util.MailMsg;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class PaymentLoader
extends TaskBase {
    private String reportMail;
    private File loadFromDir;
    private File processedToDir;
    private List<FileType> typeList = new ArrayList<FileType>();

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u0418\u0437 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438: " + (this.loadFromDir != null ? this.loadFromDir.getAbsolutePath() : "") + ". \u0412 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e: " + (this.processedToDir != null ? this.processedToDir.getAbsolutePath() : "") + ".";
    }

    @Override
    protected boolean initTask() {
        this.reportMail = this.taskSetup.get("report.mail", null);
        if (Utils.isBlankString(this.reportMail)) {
            this.log.error((Object)"Parameter report.mail not defined!");
            return false;
        }
        this.loadFromDir = new File(this.taskSetup.get("load.from.dir", ""));
        if (!(this.loadFromDir.exists() && this.loadFromDir.isDirectory() && this.loadFromDir.canRead())) {
            this.log.error((Object)("Can't read from directory '" + this.loadFromDir.getName() + "'"));
            return false;
        }
        this.processedToDir = new File(this.taskSetup.get("processed.to.dir", null));
        if (!(this.processedToDir.exists() && this.processedToDir.isDirectory() && this.processedToDir.canWrite())) {
            this.log.error((Object)("Can't write to directory '" + this.processedToDir.getName() + "'"));
            return false;
        }
        this.log.debug((Object)"Load file types");
        RegisterLoadPatternManager patternManager = new RegisterLoadPatternManager(this.setup);
        Map<String, RegisterLoadPattern> patternMap = patternManager.getLoadPatternMap();
        List<Map<String, String>> typeList = this.taskSetup.parseObjects("filetype.");
        for (Map<String, String> type : typeList) {
            FileType fileType = new FileType();
            fileType.id = type.get("id");
            try {
                fileType.namePattern = Pattern.compile(type.get("name_pattern"));
            }
            catch (Exception e) {
                this.log.error((Object)("Error name_pattern parse for type " + fileType.id));
                continue;
            }
            String loadPatternKey = type.get("load_pattern");
            fileType.loadPattern = patternMap.get(loadPatternKey);
            if (fileType.loadPattern == null) {
                this.log.error((Object)("Not found load pattern with id=" + loadPatternKey));
                continue;
            }
            fileType.datePosition = Utils.parseInt(type.get("position_date"));
            if (fileType.datePosition > 0) {
                try {
                    fileType.dateFormat = new SimpleDateFormat(type.get("date_format"));
                }
                catch (Exception e) {
                    this.log.error((Object)("Incorrect date_format in type " + fileType.id));
                    continue;
                }
            }
            this.typeList.add(fileType);
        }
        this.log.info((Object)("Loaded " + this.typeList.size() + " file types."));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            boolean autoCommit = con.getAutoCommit();
            con.setAutoCommit(false);
            RegisterManager registerManager = new RegisterManager(con);
            StringBuilder errors = new StringBuilder(100);
            for (File file : this.loadFromDir.listFiles()) {
                if (file.isDirectory()) continue;
                String name = file.getName();
                this.log.info((Object)("Found file " + name));
                FileType fileType = null;
                Matcher m = null;
                for (FileType type : this.typeList) {
                    m = type.namePattern.matcher(name);
                    if (!m.find()) continue;
                    fileType = type;
                    break;
                }
                if (fileType == null) {
                    errors.append("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u0434\u043b\u044f \u0444\u0430\u0439\u043b\u0430 " + name + "\n");
                    this.log.error((Object)("Not found type for file " + name));
                } else {
                    RegisterLoadData data = new RegisterLoadData();
                    data.date = new Date(file.lastModified());
                    if (fileType.datePosition > 0) {
                        try {
                            data.date = fileType.dateFormat.parse(m.group(fileType.datePosition));
                        }
                        catch (Exception e) {
                            errors.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0438\u0437 \u043c\u0435\u043d\u0438 \u0444\u0430\u0439\u043b\u0430 " + name + "\n");
                        }
                    }
                    data.title = name;
                    FileInputStream fis = new FileInputStream(file);
                    data.file = Utils.readByBlock(fis);
                    fis.close();
                    Register register = fileType.loadPattern.loadRegister(con, data);
                    if (data.errorCount > 0) {
                        errors.append("\n\u0424\u0430\u0439\u043b " + name + " \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438:\n");
                        errors.append((CharSequence)data.loadLog);
                    }
                    registerManager.processRegister(0, register);
                    file.renameTo(new File(this.processedToDir.getAbsolutePath() + File.separator + file.getName()));
                }
                con.commit();
            }
            con.setAutoCommit(autoCommit);
            if (Utils.notBlankString(errors.toString())) {
                new MailMsg(this.setup).sendMessage(this.reportMail, "\u041e\u0448\u0438\u0431\u043a\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", errors.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private static class FileType {
        public String id;
        public int datePosition;
        public Pattern namePattern;
        public DateFormat dateFormat;
        public RegisterLoadPattern loadPattern;

        private FileType() {
        }
    }
}

