/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class TariffOptionDao
extends AbstractIdDao<TariffOption> {
    public TariffOptionDao(Connection con) {
        super(con, 0, " tariff_option ");
    }

    public List<TariffOption> list(Date date) throws BGException {
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
        return this.list("(date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)", "title", sqlDate, sqlDate);
    }

    @Override
    protected TariffOption getFromRS(ResultSet rs) throws SQLException {
        TariffOption result = new TariffOption();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setTariffIdSet(Utils.toIntegerSet(rs.getString("tariff_ids")));
        result.setContractGroups(rs.getLong("contract_groups"));
        result.setComment(rs.getString("comment"));
        result.setDescription(rs.getString("description"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setDepends(Utils.toIntegerSet(rs.getString("depends")));
        result.setIncompatible(Utils.toIntegerSet(rs.getString("incompatible")));
        result.setHideForWeb(rs.getBoolean("hideForWeb"));
        result.setHideForContractGroups(rs.getLong("hideForWebContractGroups"));
        result.setHideForContractGroupsMode(rs.getInt("hideForWebContractGroupsMode"));
        return result;
    }

    @Override
    protected void updateImpl(TariffOption option) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (option.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title, tariff_ids, contract_groups, comment, description, date1, date2, depends, incompatible, hideForWeb, hideForWebContractGroups, hideForWebContractGroupsMode ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=?, tariff_ids=?, contract_groups=?, comment=?, description=?, date1=?, date2=?, depends=?, incompatible=?, hideForWeb=?, hideForWebContractGroups=?, hideForWebContractGroupsMode=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(13, option.getId());
        }
        ps.setString(1, option.getTitle());
        ps.setString(2, Utils.toString(option.getTariffIdSet()));
        ps.setLong(3, option.getContractGroups());
        ps.setString(4, option.getComment());
        ps.setString(5, option.getDescription());
        ps.setDate(6, TimeUtils.convertDateToSqlDate(option.getDateFrom()));
        ps.setDate(7, TimeUtils.convertDateToSqlDate(option.getDateTo()));
        ps.setString(8, Utils.toString(option.getDepends()));
        ps.setString(9, Utils.toString(option.getIncompatible()));
        ps.setBoolean(10, option.isHideForWeb());
        ps.setLong(11, option.getHideForContractGroups());
        ps.setInt(12, option.getHideForContractGroupsMode());
        ps.executeUpdate();
        if (option.getId() <= 0) {
            option.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }
}

