/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.common.IPUtils;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Map;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiPacket;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiPacketRecord;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class WiFiConnectionInspector
extends NasConnectionInspector {
    private String host;
    private int port;
    private String secret;
    DatagramSocket socket = null;

    public WiFiConnectionInspector(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connections, ParameterMap params, NasConnectionInspector old) {
        super(setup, nasIPAddress, secret, connections, params, old);
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(3000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            this.host = params.get("nas.inspector.wifi.host", nasIPAddress.getHostAddress());
            this.port = params.getInt("nas.inspector.wifi.port", 0);
            this.secret = new String(secret, "ISO-8859-1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> connection) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
        try {
            long ip = Long.valueOf(session.getNasPort());
            WiFiPacketRecord record = this.communicate((int)ip, (byte)1);
            if (record != null && Utils.unsignedIntToLong(record.getIp()) == ip) {
                if (connection.getStatus() == NasConnection.Status.suspended) {
                    connection.setStatus(NasConnection.Status.working);
                }
                session.addLogInfo("ip " + IPUtils.convertLongIpToString(ip) + " is alive ");
            } else {
                if (connection.getStatus() == NasConnection.Status.working) {
                    connection.setStatus(NasConnection.Status.suspended);
                }
                session.addLogInfo("ip " + IPUtils.convertLongIpToString(ip) + " is dead ");
            }
        }
        catch (Exception e) {
            session.addLogError("WiFi check request error , host=" + this.getHost() + ", msg=" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long sendKillRequest(NasConnection<?> connection) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
        session.addLogDebug("start wifi killer...");
        try {
            long ip = Long.valueOf(session.getNasPort());
            WiFiPacketRecord record = this.communicate((int)ip, (byte)3);
            if (record != null && (long)record.getIp() != ip) {
                // empty if block
            }
        }
        catch (Exception e) {
            session.addLogError("WiFi kill request error , host=" + this.getHost() + ", msg=" + e.getMessage());
        }
        session.addLogDebug("end wifi killer...");
        return 0L;
    }

    private WiFiPacketRecord communicate(int ip, byte type) throws IOException {
        WiFiPacketRecord record = null;
        WiFiPacket packetOut = new WiFiPacket();
        packetOut.setSecret(this.secret);
        packetOut.setType(type);
        packetOut.add(ip);
        WiFiUtil.sendPacket(this.socket, packetOut, this.host, this.port);
        WiFiPacket packetIn = WiFiUtil.recievePacket(this.socket, this.secret);
        if (packetIn != null) {
            record = packetIn.getFirstRecord();
        }
        return record;
    }
}

