/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Observer;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionCheckObserver;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.pdu.OneGetPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;

public class SNMPNasConnectionInspectorMPD
extends SNMPNasConnectionInspector {
    private static final Logger log = Logger.getLogger(SNMPNasConnectionInspectorMPD.class);

    public SNMPNasConnectionInspectorMPD(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connection, ParameterMap params, NasConnectionInspector old) throws IOException {
        super(setup, nasIPAddress, secret, connection, params, old);
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> con) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
        int ver = this.context.getVersion();
        try {
            OneGetPdu getPdu = new OneGetPdu((SnmpContextBasisFace)this.context);
            getPdu.addOid(this.snmp_oid_check + "." + session.getNasPort());
            getPdu.addObserver((Observer)new SNMPNasConnectionCheckObserver(ver, con, this.nasIPAddress));
            getPdu.send();
            session.addLogDebug("SNMP check request: " + this.snmp_oid_check + "." + session.getNasPort());
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP check request  [ SNMP ver. " + ver + ", host=" + this.getHost() + ", msg=" + ex.getMessage() + " ]");
        }
    }

    @Override
    protected long sendKillRequest(NasConnection<?> con) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
        try {
            SetPdu setPdu = new SetPdu((SnmpContextBasisFace)this.context);
            setPdu.addOid(this.snmp_oid_kill, (AsnObject)new AsnInteger(Utils.parseInt(session.getNasPort(), -1)));
            setPdu.send();
            session.addLogInfo("SNMP reset request: set " + this.snmp_oid_kill + " i " + session.getNasPort());
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP reset request [ SNMP ver." + this.context.getVersion() + ", host=" + this.getHost() + ", msg=" + ex.getMessage() + " ]");
        }
        return 0L;
    }
}

