/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class NetFlow9Template
implements Serializable {
    private static final long serialVersionUID = 46633705229813869L;
    private static final Logger log = Logger.getLogger(NetFlow9Template.class);
    public int templateId;
    public int fieldCount;
    public int dataLength;
    public int minDataLength;
    public int length;
    public NetFlow9TemplateItem nextHopItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem inSnmpIfaceItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem outSnmpIfaceItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem inOctetsItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem ip4SrcAddressItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem ip4DstAddressItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem ip6SrcAddressItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem ip6DstAddressItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem l4SrcPortItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem l4DstPortItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem srcTosBytesItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem firstSwitchedItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem lastSwitchedItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem ip4NextHopItem = new NetFlow9TemplateItem();
    public NetFlow9TemplateItem protocolItem = new NetFlow9TemplateItem();
    public byte[] data;
    private final NetFlow9TemplateItem[] typeItems = new NetFlow9TemplateItem[]{null, this.inOctetsItem, null, null, this.protocolItem, this.srcTosBytesItem, null, this.l4SrcPortItem, this.ip4SrcAddressItem, null, this.inSnmpIfaceItem, this.l4DstPortItem, this.ip4DstAddressItem, null, this.outSnmpIfaceItem, this.ip4NextHopItem, null, null, null, null, null, this.lastSwitchedItem, this.firstSwitchedItem, null, null, null, null, this.ip6SrcAddressItem, this.ip6DstAddressItem, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    public final NetFlow9TemplateItem natLogFieldIdxContextId = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxContextName = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxAssignTsSec = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxUnassignTsSec = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxIpv4IntAddr = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxIpv4ExtAddr = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxExtPortFirst = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem natLogFieldIdxExtPortLast = new NetFlow9TemplateItem();
    public final NetFlow9TemplateItem hslNatLogFieldTranslatedDestinationIPv4Addr = new NetFlow9TemplateItem(226);
    public final NetFlow9TemplateItem hslNatLogFieldTranslatedDestinationPort = new NetFlow9TemplateItem(228);
    public final NetFlow9TemplateItem hslNatLogFieldTranslatedSourceIpv4Addr = new NetFlow9TemplateItem(225);
    public final NetFlow9TemplateItem hslNatLogFieldTranslatedSourcePort = new NetFlow9TemplateItem(227);
    public final NetFlow9TemplateItem hslNatLogFieldEvent = new NetFlow9TemplateItem(230);
    public final NetFlow9TemplateItem hslNatLogFieldVrfId = new NetFlow9TemplateItem(234);
    public final NetFlow9TemplateItem hslNatLogFieldTimestamp = new NetFlow9TemplateItem(323);
    public NetFlow9TemplateItem[] items;
    public boolean flowLog;
    public boolean natLog;
    public boolean seNatLog;
    public boolean hslNatLog;

    public void parse(ByteBuffer readBuffer) {
        int offset;
        int beginOffset = offset = readBuffer.position();
        this.templateId = readBuffer.getShort(offset) & 0xFFFF;
        this.fieldCount = readBuffer.getShort(offset + 2) & 0xFFFF;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Template id: " + this.templateId + "; fieldCount: " + this.fieldCount));
        }
        offset += 4;
        ArrayList<NetFlow9TemplateItem> items = new ArrayList<NetFlow9TemplateItem>();
        int itemPosition = -1;
        int minDataLength = 0;
        int fieldOffset = 0;
        for (int j = 0; j < this.fieldCount; ++j) {
            int pen;
            int type = readBuffer.getShort(offset) & 0xFFFF;
            int length = readBuffer.getShort(offset + 2) & 0xFFFF;
            if ((type & 0x8000) == 32768) {
                type &= Short.MAX_VALUE;
                pen = readBuffer.getInt(offset + 4);
            } else {
                pen = 0;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Field type: " + type + "; offset: " + fieldOffset + "; length: " + length));
            }
            ++itemPosition;
            NetFlow9TemplateItem item = null;
            if (type < this.typeItems.length) {
                item = this.typeItems[type];
            } else {
                switch (type) {
                    case 24628: {
                        item = this.natLogFieldIdxContextId;
                        break;
                    }
                    case 24629: {
                        item = this.natLogFieldIdxContextName;
                        break;
                    }
                    case 24630: {
                        item = this.natLogFieldIdxAssignTsSec;
                        break;
                    }
                    case 24631: {
                        item = this.natLogFieldIdxUnassignTsSec;
                        break;
                    }
                    case 24632: {
                        item = this.natLogFieldIdxIpv4IntAddr;
                        break;
                    }
                    case 24633: {
                        item = this.natLogFieldIdxIpv4ExtAddr;
                        break;
                    }
                    case 24634: {
                        item = this.natLogFieldIdxExtPortFirst;
                        break;
                    }
                    case 24635: {
                        item = this.natLogFieldIdxExtPortLast;
                        break;
                    }
                    case 225: {
                        item = this.hslNatLogFieldTranslatedSourceIpv4Addr;
                        break;
                    }
                    case 226: {
                        item = this.hslNatLogFieldTranslatedDestinationIPv4Addr;
                        break;
                    }
                    case 227: {
                        item = this.hslNatLogFieldTranslatedSourcePort;
                        break;
                    }
                    case 228: {
                        item = this.hslNatLogFieldTranslatedDestinationPort;
                        break;
                    }
                    case 230: {
                        item = this.hslNatLogFieldEvent;
                        break;
                    }
                    case 234: {
                        item = this.hslNatLogFieldVrfId;
                        break;
                    }
                    case 323: {
                        item = this.hslNatLogFieldTimestamp;
                        break;
                    }
                }
            }
            if (item == null) {
                item = new NetFlow9TemplateItem();
            } else {
                item.init = true;
            }
            items.add(item);
            item.type = type;
            item.position = itemPosition;
            item.offset = fieldOffset;
            if (length == 65535) {
                item.length = -1;
                fieldOffset = -1;
            } else {
                item.length = length;
                minDataLength += length;
            }
            if (fieldOffset >= 0) {
                fieldOffset += length;
            }
            if (pen > 0) {
                offset += 8;
                continue;
            }
            offset += 4;
        }
        this.length = offset - beginOffset;
        this.flowLog = false;
        this.seNatLog = false;
        this.hslNatLog = false;
        this.natLog = false;
        if (this.inOctetsItem.init) {
            if (this.inOctetsItem.length != 4 && this.inOctetsItem.length != 8) {
                log.warn((Object)("Template " + this.templateId + ". Collector support only 4 and 8 bytes length for IN_BYTES field!"));
            } else {
                this.flowLog = true;
            }
        } else if (this.natLogFieldIdxIpv4ExtAddr.init) {
            this.seNatLog = true;
        } else if (this.hslNatLogFieldEvent != null && this.hslNatLogFieldEvent.init) {
            this.hslNatLog = true;
        } else if (this.hslNatLogFieldTranslatedSourceIpv4Addr.init) {
            this.natLog = true;
        } else {
            log.warn((Object)("Template " + this.templateId + ". Field IN_BYTES not init!"));
        }
        this.dataLength = fieldOffset;
        this.minDataLength = minDataLength;
        this.items = items.toArray(new NetFlow9TemplateItem[items.size()]);
        int position = readBuffer.position();
        byte[] data = new byte[this.length];
        readBuffer.get(data);
        readBuffer.position(position);
        this.data = data;
    }

    public int skipData(ByteBuffer data, int beginPosition) {
        if (this.dataLength >= 0) {
            return this.dataLength;
        }
        int position = beginPosition;
        for (int i = 0; i < this.items.length; ++i) {
            NetFlow9TemplateItem item = this.items[i];
            if (item.length == -1) {
                int len = data.get(position) & 0xFF;
                if (len == 255) {
                    len = data.getShort(++position) & 0xFFFF;
                    position += len + 2;
                    continue;
                }
                position += len + 1;
                continue;
            }
            position += item.length;
        }
        return position - beginPosition;
    }

    public static class NetFlow9TemplateItem
    implements Serializable {
        private static final long serialVersionUID = -2298034320202411405L;
        public boolean init = false;
        public int type;
        public int position;
        public int offset;
        public int length;

        public NetFlow9TemplateItem() {
        }

        public NetFlow9TemplateItem(int type) {
            this.type = type;
        }
    }
}

