/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.WritableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.StreamReadableChannel;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.ZLIBReadableChannel;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogWriter;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.IPFIXDataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.IPFIXDataLogWriter;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.Netflow9DataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.Netflow9DataLogReader0;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.Netflow9DataLogWriter;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.NetflowDataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.sflow.SFlowDataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.snmp.SnmpDataLogReader;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;

public class IPDataLog
extends BGDataLog<IPDataLog>
implements ReadableDataLog<BGDataLogReader<?>>,
WritableDataLog<IPDataLogWriter> {
    private static final Logger logger = Logger.getLogger(IPDataLog.class);
    public static final int DATALOG_TYPE_IP = 1;
    private static final int IP_DATALOG_TYPE_ID = 100;
    public static final IPDataLogType IP_DATALOG_TYPE = new IPDataLogType();
    private static final int NETFLOW9_TEMPLATES_ID = 110;
    public static final Netflow9Templates NETFLOW9_TEMPLATES = new Netflow9Templates();
    private boolean netflow9Stream;

    public IPDataLog(int id, File file, RandomAccessFile randomAccessFile, FileChannel fileChannel) {
        super(id, file, randomAccessFile, fileChannel, 1);
    }

    @Override
    protected boolean readTLV(int type, int length, ByteBuffer readBuffer) throws IOException {
        if (!super.readTLV(type, length, readBuffer)) {
            switch (type) {
                case 10: {
                    if (this.version > 4) break;
                }
                case 100: {
                    IPDataLogType ipDataLogType = new IPDataLogType();
                    this.readParameter(readBuffer, IP_DATALOG_TYPE, ipDataLogType, length);
                    this.setParameter(IP_DATALOG_TYPE, ipDataLogType);
                    break;
                }
                case 110: {
                    Netflow9Templates netflow9Templates = new Netflow9Templates();
                    this.readParameter(readBuffer, NETFLOW9_TEMPLATES, netflow9Templates, length);
                    this.setParameter(NETFLOW9_TEMPLATES, netflow9Templates);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected void asReaderImpl() throws IOException {
        super.asReaderImpl();
        try {
            IPDataLogType type = this.getParameter(IP_DATALOG_TYPE);
            if (type == null || type.logType == type.NETFLOW) {
                this.checkStream();
            }
        }
        catch (BufferUnderflowException e) {
            throw new IOException("Unexpected end of stream", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Unexpected end of stream", e);
        }
    }

    private void checkStream() throws IOException {
        BGDataLog.Finished finished = this.getParameter(FINISHED);
        if (finished != null && finished.get() == 0) {
            return;
        }
        BGDataLog.Compression compression = this.getParameter(COMPRESSION);
        if (compression.type == 3) {
            return;
        }
        FileChannel fileChannel = this.fileChannel;
        BGDataLog.Distributed distributed = this.getParameter(DISTRIBUTED);
        if (distributed != null && distributed.value > 0) {
            fileChannel = this.dataFileChannel;
        }
        long pos = fileChannel.position();
        int h = 0;
        ReadableByteChannel readableByteChannel = fileChannel;
        readableByteChannel = compression.type == 1 ? new ZLIBReadableChannel(fileChannel, ByteBuffer.allocate(this.readBufferSize)) : (compression.type == 2 ? new StreamReadableChannel(fileChannel, new GZIPInputStream(Channels.newInputStream(fileChannel), this.readBufferSize)) : fileChannel);
        if (this.chunkSize > 0) {
            ByteBuffer bb = ByteBuffer.allocate(36);
            readableByteChannel.read(bb);
            bb.flip();
            if (bb.capacity() == bb.remaining()) {
                h = bb.getShort(24);
            }
        }
        fileChannel.position(pos);
        readableByteChannel = null;
        this.netflow9Stream = h == 9;
    }

    @Override
    public synchronized BGDataLogReader<?> newReader(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        IPDataLogType type = this.getParameter(IP_DATALOG_TYPE);
        if (type == null || type.logType == type.NETFLOW) {
            if (!this.netflow9Stream) {
                return this.initReader(new NetflowDataLogReader(this));
            }
            return this.initReader(new Netflow9DataLogReader0(this));
        }
        if (type.logType == type.NETFLOW9) {
            return this.initReader(new Netflow9DataLogReader(this));
        }
        if (type.logType == type.IPFIX) {
            return this.initReader(new IPFIXDataLogReader(this));
        }
        if (type.logType == type.SFLOW) {
            return this.initReader(new SFlowDataLogReader(this));
        }
        if (type.logType == type.SNMP) {
            if (type.logType == type.SNMP && this.readerList.size() > 0) {
                return null;
            }
            return this.initReader(new SnmpDataLogReader(this, params));
        }
        throw new RuntimeException(this.toString());
    }

    @Override
    public IPDataLogWriter newWriter(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        IPDataLogType type = this.getParameter(IP_DATALOG_TYPE);
        if (type.logType == type.SNMP && this.writerList.size() > 0) {
            throw new IllegalStateException("You can't create more than one writer for SNMP log!");
        }
        if (type.logType == type.NETFLOW9) {
            return this.initWriter(new Netflow9DataLogWriter(this));
        }
        if (type.logType == type.IPFIX) {
            return this.initWriter(new IPFIXDataLogWriter(this));
        }
        return this.initWriter(new IPDataLogWriter(this));
    }

    public static class Netflow9Templates
    extends DataLog.Parameter<Netflow9Templates> {
        public Map<Integer, NetFlow9Template> templates = null;

        public Netflow9Templates() {
            super(110, "netflowTemplates", Netflow9Templates.class);
        }

        @Override
        protected void write(Netflow9Templates c, ByteBuffer writeBuffer) {
            if (this.templates == null || this.templates.size() == 0) {
                return;
            }
            int length = 0;
            for (NetFlow9Template template : this.templates.values()) {
                length += template.data.length;
            }
            writeBuffer.putInt(c.id);
            writeBuffer.putInt(length);
            for (NetFlow9Template template : this.templates.values()) {
                writeBuffer.put(template.data);
            }
        }

        @Override
        protected Netflow9Templates read(Netflow9Templates c, ByteBuffer byteBuffer, int length) {
            HashMap<Integer, NetFlow9Template> templates = new HashMap<Integer, NetFlow9Template>();
            try {
                NetFlow9Template template;
                ByteBuffer localByteBuffer = ByteBuffer.allocate(length);
                localByteBuffer.put(byteBuffer);
                localByteBuffer.rewind();
                for (int position = 0; position < localByteBuffer.capacity(); position += template.length) {
                    localByteBuffer.position(position);
                    template = new NetFlow9Template();
                    template.parse(localByteBuffer);
                    templates.put(template.templateId, template);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            c.templates = templates.size() > 0 ? templates : null;
            return this;
        }

        public String toString() {
            return "NetflowTemplates [" + (this.templates != null ? this.templates.size() : 0) + "]";
        }
    }

    public static class IPDataLogType
    extends DataLog.Parameter<IPDataLogType> {
        public final int RAW = 0;
        public final int NETFLOW = 1;
        public final int SFLOW = 2;
        public final int SNMP = 3;
        public final int NETFLOW9 = 4;
        public final int IPFIX = 5;
        public int logType = -1;
        public int logSubType = -1;
        public int logSubTypeVersion = -1;

        public IPDataLogType() {
            super(100, "ipDataLogType", IPDataLogType.class);
        }

        @Override
        protected void write(IPDataLogType c, ByteBuffer writeBuffer) {
            if (c.logType < 0 || c.logSubType < 0 || c.logSubTypeVersion < 0) {
                throw new IllegalStateException(c.logType + " " + c.logSubType + " " + c.logSubTypeVersion);
            }
            writeBuffer.putInt(c.id);
            writeBuffer.putInt(3);
            writeBuffer.put((byte)c.logType);
            writeBuffer.put((byte)c.logSubType);
            writeBuffer.put((byte)c.logSubTypeVersion);
        }

        @Override
        protected IPDataLogType read(IPDataLogType c, ByteBuffer byteBuffer, int length) {
            c.logType = byteBuffer.get() & 0xFF;
            c.logSubType = byteBuffer.get() & 0xFF;
            c.logSubTypeVersion = byteBuffer.get() & 0xFF;
            return c;
        }

        public String toString() {
            return "IPDataLogType [" + this.logType + " " + this.logSubType + " " + this.logSubTypeVersion + "]";
        }
    }
}

