/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ServiceDao
extends AbstractIdDao<Service>
implements Directory<Service> {
    public ServiceDao(Connection con) {
        super(con, 0, "service");
    }

    @Override
    public Service get(String title) throws BGException {
        return null;
    }

    @Override
    public List<Service> list() throws BGException {
        return this.list(null, "mid, title", new Object[0]);
    }

    public List<Service> listUsing() throws BGException {
        return this.list("isusing", "mid, title", new Object[0]);
    }

    public List<Service> list(int moduleId) throws BGException {
        return this.list("mid=?", "title", moduleId);
    }

    public List<Service> listUsing(int moduleId) throws BGException {
        return this.list("mid=?, isusing", "mid, title", new Object[0]);
    }

    @Override
    protected void updateImpl(Service service) throws BGException, SQLException {
        PreparedStatement ps;
        if (service.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO service SET title=?, mid=?, isusing=?, unit=?", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE service SET title=?, mid=?, isusing=?, unit=? WHERE id=?");
            ps.setInt(5, service.getId());
        }
        ps.setString(1, service.getTitle());
        ps.setInt(2, service.getModuleId());
        ps.setBoolean(3, service.isUsing());
        ps.setInt(4, service.getUnit());
        ps.executeUpdate();
        if (service.getId() <= 0) {
            service.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    protected Service getFromRS(ResultSet rs) throws SQLException {
        Service service = new Service();
        service.setId(rs.getInt("id"));
        service.setTitle(rs.getString("title"));
        service.setModuleId(rs.getInt("mid"));
        service.setUsing(rs.getInt("isusing") == 1);
        service.setUnit(rs.getInt("unit"));
        return service;
    }
}

