/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.installer.InstallerModule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class ModuleManager {
    private static final Logger logger = Logger.getLogger(ModuleManager.class);
    private static final String IMC = "id, enabled, type, name, title, version, pack_client, pack_server";
    private Connection con;
    private static long lastUpdateTime = 0L;
    private static Map<String, int[]> moduleIds = new HashMap<String, int[]>();

    public ModuleManager(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModuleIdByName(String moduleName) {
        int[] ids;
        int moduleId = 0;
        if (System.currentTimeMillis() > lastUpdateTime + 1000L * Setup.getSetup().getLong("module.ids.update.period", 300L)) {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                HashMap<String, int[]> newModuleIds = new HashMap<String, int[]>();
                String query = "SELECT id, name FROM module";
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    String module = rs.getString(2);
                    int[] ids2 = (int[])newModuleIds.get(module);
                    ids2 = ids2 == null ? new int[1] : Arrays.copyOf(ids2, ids2.length + 1);
                    newModuleIds.put(module, ids2);
                    ids2[ids2.length - 1] = rs.getInt(1);
                }
                rs.close();
                st.close();
                moduleIds = newModuleIds;
                lastUpdateTime = System.currentTimeMillis();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
                con = null;
            }
        }
        if ((ids = moduleIds.get(moduleName)) != null && ids.length == 1) {
            moduleId = ids[0];
        }
        return moduleId;
    }

    public List<BGModule> getModules(String name) throws BGException {
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append("module");
            if (name != null) {
                query.append(" WHERE name=?");
            }
            query.append(" ORDER BY title");
            ps = this.con.prepareStatement(query.toString());
            if (name != null) {
                ps.setString(1, name);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getModuleFromRs(rs));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException();
        }
        return result;
    }

    public List<BGModule> getModules() throws BGException {
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT *, ");
            query.append(" ABS(STRCMP(name, 'npay')) AS cmp FROM ");
            query.append("module");
            query.append(" ORDER BY cmp DESC");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getModuleFromRs(rs));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public BGModule getModule(int id) throws BGException {
        BGModule module = null;
        try {
            int index = 1;
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append("module");
            query.append(" WHERE id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, id);
            rs = ps.executeQuery();
            while (rs.next()) {
                module = this.getModuleFromRs(rs);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return module;
    }

    public Map<Integer, BGModule> getModulesMap() throws BGException {
        HashMap<Integer, BGModule> result = new HashMap<Integer, BGModule>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append("module");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BGModule module = this.getModuleFromRs(rs);
                result.put(module.getId(), module);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public int addModule(BGInstalledModule module, String title, int userId) throws BGException {
        try {
            PreparedStatement ps = null;
            if (ServerUtils.getSetupValue(this.con, "20") != null) {
                throw new BGMessageException("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0431\u044b\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
            }
            ps = this.con.prepareStatement("INSERT INTO module SET title=?, name=?", 1);
            ps.setString(1, title);
            ps.setString(2, module.getName());
            ps.executeUpdate();
            int mid = ServerUtils.lastInsertId(ps);
            InstallerModule.initModule(this.con, module.getName(), mid);
            try {
                Context env = Setup.getEnvironment();
                Context ctx = env.createSubcontext(String.valueOf(mid));
                ModuleCache.getInstance().reloadModules(this.con);
                BGModule bgModule = ModuleCache.getInstance().getModule(mid);
                ApplicationModule am = ModuleCache.getInstance().getApplicationModule(module.getName());
                if (am != null && bgModule != null) {
                    try {
                        am.start(this.con, ctx, bgModule);
                    }
                    catch (BGException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (NamingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return mid;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateModule(BGModule b2) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE module SET title=? WHERE id=?");
            ps.setString(1, b2.getTitle());
            ps.setInt(2, b2.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteModule(BGInstalledModule module, int id) throws BGException {
        try {
            String query = "SELECT cid FROM contract_module WHERE mid=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ps.close();
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c \u0438\u0437 \u0432\u0441\u0435\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0447\u0435\u0440\u0435\u0437 \u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438.");
            }
            rs.close();
            ps.close();
            InstallerModule.uninstallModuleInstance(this.con, module.getName(), id);
            query = "DELETE FROM module WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            this.deleteModuleEventTypes(id);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public List<String> getInstalledModules() throws BGException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String query = "SELECT name FROM installed_modules WHERE type IN ('module', 'plugin')";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<BGInstalledModule> getInstalledModules(String ... types) {
        ArrayList<BGInstalledModule> result = new ArrayList<BGInstalledModule>();
        try {
            int index = 1;
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT ").append(IMC).append(" FROM ").append("installed_modules");
            if (types != null && types.length > 0) {
                query.append(" WHERE type IN ( ");
                for (int i = 0; i < types.length; ++i) {
                    if (i > 0) {
                        query.append(", ");
                    }
                    query.append("?");
                }
                query.append(" )");
            }
            query.append(" ORDER BY title");
            ps = this.con.prepareStatement(query.toString());
            if (types != null && types.length > 0) {
                for (String type : types) {
                    ps.setString(index++, type);
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInstalledModuleFromRs(rs));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private BGModule getModuleFromRs(ResultSet rs) throws SQLException {
        BGModule result = new BGModule();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    private BGInstalledModule getInstalledModuleFromRs(ResultSet rs) throws SQLException {
        BGInstalledModule result = new BGInstalledModule();
        result.setId(rs.getInt("id"));
        result.setEnabled(rs.getBoolean("enabled"));
        result.setType(rs.getString("type"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        result.setVersion(rs.getString("version"));
        result.setPackageClient(rs.getString("pack_client"));
        result.setPackageServer(rs.getString("pack_server"));
        return result;
    }

    private void deleteModuleEventTypes(int id) throws SQLException {
        String query = "DELETE FROM script_event_type WHERE mid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }
}

