/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.events;

import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import java.util.Collections;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

@XmlRootElement
public class ContractParamBeforeChangeEvent
extends LocalEvent {
    private int paramId;
    private Object value;
    private String error;
    private EntityAttr entityAttr;

    protected ContractParamBeforeChangeEvent() {
    }

    public ContractParamBeforeChangeEvent(int userId, int cid, int pid, Object value) {
        super(0, cid, userId);
        this.paramId = pid;
        if (value instanceof EntityAttr) {
            this.entityAttr = (EntityAttr)value;
            value = ContractParamBeforeChangeEvent.convertEntityAttrToOldValue(this.entityAttr);
        }
        this.value = value;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public int getParamId() {
        return this.paramId;
    }

    public Object getValue() {
        return this.value;
    }

    public EntityAttr getEntityAttr() {
        return this.entityAttr;
    }

    static Object convertEntityAttrToOldValue(EntityAttr entityAttr) {
        if (entityAttr == null) {
            return null;
        }
        switch (EntitySpecAttrType.getEntitySpecAttrType(entityAttr.getType())) {
            case TEXT: {
                return ((EntityAttrText)entityAttr).getValue();
            }
            case LIST: {
                return ((EntityAttrList)entityAttr).getValue();
            }
            case BOOLEAN: {
                return ((EntityAttrBoolean)entityAttr).getValue();
            }
            case CONTRACT: {
                return ((EntityAttrContract)entityAttr).getValue();
            }
            case ADDRESS: {
                EntityAttrAddress a2 = (EntityAttrAddress)entityAttr;
                ContractAddressParamValue value = new ContractAddressParamValue();
                value.setHouseId(a2.getHouseId());
                value.setFlat(a2.getFlat());
                value.setRoom(a2.getRoom());
                value.setPod(a2.getPod());
                value.setFloor(a2.getFloor());
                value.setComment(a2.getComment());
                value.setFormatKey(a2.getFormatKey());
                value.setAddress(a2.getTitle());
                return value;
            }
            case EMAIL: {
                EntityAttrEmail a3 = (EntityAttrEmail)entityAttr;
                ContractEmailParamValue value = new ContractEmailParamValue();
                value.setEmailId(0);
                value.setEmail(a3.getData());
                value.setMailSet(Collections.emptySet());
                return value;
            }
            case PHONE: {
                EntityAttrPhone a4 = (EntityAttrPhone)entityAttr;
                PhoneParamValue value = new PhoneParamValue();
                for (EntityAttrPhone.PhoneContact contact : a4.getContactList()) {
                    PhoneParamItem item = new PhoneParamItem();
                    item.setPhone(contact.getPhone());
                    item.setFormat("");
                    item.setComment(contact.getComment());
                    value.addPhoneItem(item);
                }
                value.setPhones(a4.getData());
                return value;
            }
            case MULTILIST: {
                EntityAttrMultiList a5 = (EntityAttrMultiList)entityAttr;
                MultiListParamValues value = new MultiListParamValues();
                value.parseTitleValue(a5.getTitle());
                return value;
            }
        }
        return entityAttr;
    }
}

