/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.common.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationResult;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.GeneratorOptions;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.RunMessage;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.CodeGenerator;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptSavingEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Description;
import ru.bitel.common.sql.ConnectionSet;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.dynamic.common.DynamicCodeService")
public class DynamicCodeServiceImpl
extends AbstractService
implements DynamicCodeService {
    private static final Logger logger = Logger.getLogger(DynamicCodeServiceImpl.class);
    private DynamicCodeDao dao;

    @PostConstruct
    public void init() {
        this.dao = new DynamicCodeDao(this.getConnection());
    }

    @Override
    public void updateSource(String className, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data) throws BGException {
        if (Utils.isBlankString(className)) {
            throw new BGMessageException("\u041f\u0443c\u0442\u043e\u0435 \u0438\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430!");
        }
        DynamicCodeDao.updateClassSource(className, (DataHandler)data.value);
    }

    @Override
    public CompilationResult recompileAll() throws BGException {
        List<String> classNames = this.dao.getDynamicClasses().stream().map(f -> f.getClassName()).collect(Collectors.toList());
        return EventProcessor.getInstance().request(new ScriptSavingEvent(classNames, true)).getCompilationResult();
    }

    @Override
    public String getSource(final String className, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data) throws BGException {
        final File file = DynamicCodeDao.getClassFile(className);
        if (!file.exists() || !file.isFile()) {
            throw new BGMessageException("\u041a\u043b\u0430\u0441\u0441 \"" + className + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        data.value = new DataHandler(new DataSource(){

            public String getContentType() {
                return "text/plain";
            }

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(file);
            }

            public String getName() {
                return className;
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
        return "UTF-8";
    }

    @Override
    public List<DynamicClass> getDynamicClasses() throws BGException {
        DynamicClassManager classManager = DynamicClassManager.getInstance();
        List<DynamicClass> result = this.dao.getDynamicClasses();
        for (DynamicClass dynamicClass : result) {
            try {
                Class<?> clazz = classManager.loadClass(dynamicClass.getClassName());
                dynamicClass.setDeprecated(clazz.getAnnotation(Deprecated.class) != null);
            }
            catch (BGException clazz) {
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
            }
        }
        return result;
    }

    @Override
    public List<String> getClassNamesByInterface(String ifaceName) throws BGException {
        return this.dao.getActualClassesByInterface(ifaceName);
    }

    @Override
    public List<DynamicClass> getDynamicClassesByInterface(String ifaceName) throws BGException {
        DynamicClassManager classManager = DynamicClassManager.getInstance();
        ArrayList<DynamicClass> result = new ArrayList<DynamicClass>();
        List<String> classNames = this.dao.getActualClassesByInterface(ifaceName);
        for (String className : classNames) {
            Class<?> clazz = classManager.loadClass(className);
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            DynamicClass dynamicClass = new DynamicClass();
            dynamicClass.setClassName(className);
            dynamicClass.setDeprecated(clazz.getAnnotation(Deprecated.class) != null);
            Description description = clazz.getAnnotation(Description.class);
            dynamicClass.setDescription(Utils.maskNull(description != null ? description.value() : null));
            result.add(dynamicClass);
        }
        return result;
    }

    @Override
    public CompilationResult compile(String className) throws BGException {
        ScriptSavingEvent event = EventProcessor.getInstance().request(new ScriptSavingEvent(Collections.singletonList(className), false));
        return event.getCompilationResult();
    }

    @Override
    public CompilationResult deleteClasses(String ... classNames) throws BGException {
        for (String className : classNames) {
            DynamicCodeDao.backupAndDelete(className);
        }
        CompilationResult result = this.recompileAll();
        if (result.getErrors().size() > 0) {
            for (String className : classNames) {
                DynamicCodeDao.restoreSourcesFromBackup(className);
            }
        } else {
            for (String className : classNames) {
                DynamicCodeDao.deleteSourcesBackup(className);
                this.dao.deleteClassFromDb(className);
            }
        }
        return result;
    }

    @Override
    public String generateCode(GeneratorOptions options) throws BGException {
        return new CodeGenerator(options).generateCode();
    }

    @Override
    public boolean isClassExists(String className) throws BGException {
        return DynamicCodeDao.getClassFile(className).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunMessage> run(String className, String[] parameters) throws BGException {
        final ArrayList<RunMessage> result = new ArrayList<RunMessage>();
        if (parameters == null) {
            parameters = new String[]{};
        }
        final PrintStream originalOut = System.out;
        PrintStream filterOut = new PrintStream(new OutputStream(){
            private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b2) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    originalOut.write(b2);
                    this.bos.write(b2);
                }
            }

            @Override
            public void flush() throws IOException {
                originalOut.flush();
                if (this.bos.size() > 0) {
                    result.add(new RunMessage(this.bos.toString(), RunMessage.RunMessageType.OUT));
                    this.bos.reset();
                }
            }
        }, true);
        final PrintStream originalErr = System.err;
        PrintStream filterErr = new PrintStream(new OutputStream(){
            private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b2) {
                3 var2_2 = this;
                synchronized (var2_2) {
                    originalErr.write(b2);
                    this.bos.write(b2);
                }
            }

            @Override
            public void flush() throws IOException {
                originalErr.flush();
                if (this.bos.size() > 0) {
                    result.add(new RunMessage(this.bos.toString(), RunMessage.RunMessageType.ERR));
                    this.bos.reset();
                }
            }
        }, true);
        try {
            System.setOut(filterOut);
            System.setErr(filterErr);
            Class<?> clazz = DynamicClassManager.getInstance().loadClass(className);
            result.add(new RunMessage("load class " + clazz.getCanonicalName() + "\n", RunMessage.RunMessageType.INFO));
            try {
                Method methot1 = clazz.getMethod("execute", Setup.class, ConnectionSet.class);
                result.add(new RunMessage("get method " + methot1.toString() + "\n", RunMessage.RunMessageType.INFO));
                Object objekt = clazz.newInstance();
                result.add(new RunMessage("new instance " + objekt.toString() + "\n", RunMessage.RunMessageType.INFO));
                try {
                    clazz.getMethod("setOutputStream", PrintStream.class).invoke(objekt, filterOut);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    clazz.getMethod("setErrorStream", PrintStream.class).invoke(objekt, filterErr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                methot1.invoke(objekt, this.getSetup(), this.getConnectionSet());
            }
            catch (NoSuchMethodException e1) {
                try {
                    Method methot2 = clazz.getMethod("main", String[].class);
                    result.add(new RunMessage("get method " + methot2.toString() + "\n", RunMessage.RunMessageType.INFO));
                    methot2.invoke(null, new Object[]{parameters});
                }
                catch (NoSuchMethodException e2) {
                    result.add(new RunMessage("need a method \"execute(Setup,ConnectionSet)\" or \"static main(String[])\" to run\n", RunMessage.RunMessageType.ERR));
                }
            }
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            filterOut.flush();
            filterErr.flush();
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        return result;
    }
}

