/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server;

import bitel.billing.server.contract.bean.ContractStatus;
import java.util.Calendar;
import java.util.List;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.common.util.PeriodItemSet;

public class ContractStatusList
extends PeriodItemSet {
    public ContractStatusList(List<ContractStatus> periodList, Calendar utilCalendar) {
        super(ContractStatusList.convert(periodList, utilCalendar));
    }

    private static AbstractPeriodItemSet.PeriodItem[] convert(List<ContractStatus> periodList, Calendar utilCalendar) {
        int size = periodList.size();
        AbstractPeriodItemSet.PeriodItem[] result = new AbstractPeriodItemSet.PeriodItem[size];
        for (int i = 0; i < size; ++i) {
            ContractStatus period = periodList.get(i);
            result[i] = new AbstractPeriodItemSet.PeriodItem(period.getId(), TimeUtils.convertDateToMillisFrom(utilCalendar, period.getDateFrom()), TimeUtils.convertDateToMillisTo(utilCalendar, period.getDateTo()));
        }
        return result;
    }

    protected ContractStatusList(List<AbstractPeriodItemSet.PeriodItem> entryList) {
        super(entryList);
    }

    private ContractStatusList(AbstractPeriodItemSet.PeriodItem[] entries) {
        super(entries);
    }

    @Override
    protected boolean isCoincide(AbstractPeriodItemSet.PeriodItem item, AbstractPeriodItemSet.PeriodItem other) {
        return other.id == item.id;
    }

    public ContractStatusList update(int id, long millisFrom, long millisTo) {
        return new ContractStatusList(super.update(new AbstractPeriodItemSet.PeriodItem(id, millisFrom, millisTo)));
    }

    public ContractStatusList remove(int id, long millisFrom, long millisTo) {
        return new ContractStatusList(super.remove(new AbstractPeriodItemSet.PeriodItem(id, millisFrom, millisTo)));
    }
}

