/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScriptLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ContractScriptLogDao
extends AbstractDao<ContractScriptLog> {
    public ContractScriptLogDao(Connection con, String tableName) {
        super(con, -1, tableName);
    }

    public List<String> getScriptLogTitleList(int contractId, Period period) throws BGException {
        ArrayList<String> result = new ArrayList<String>();
        if (ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "SELECT DISTINCT title FROM " + this.tableName + " WHERE cid=" + contractId + " AND TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateFrom());
            query = query + (period.getDateTo() != null ? "') AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateTo()) : "");
            query = query + "') ORDER BY time ";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BGException(e.getMessage(), e);
            }
        }
        return result;
    }

    public List<ContractScriptLog> getScriptLogList(int contractId, Period period) throws BGException {
        return this.getScriptLogList(contractId, period, null, null);
    }

    public List<ContractScriptLog> getScriptLogList(int contractId, Period period, String title, Page page) throws BGException {
        ArrayList<ContractScriptLog> result = new ArrayList<ContractScriptLog>();
        if (period == null || period.getDateFrom() == null) {
            return result;
        }
        if (ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE cid=" + contractId + " AND TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateFrom()) + "')";
            if (period.getDateTo() != null) {
                query = query + " AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateTo()) + "')";
            }
            if (title != null) {
                query = query + " AND title=?";
            }
            query = query + " ORDER BY time DESC ";
            if (page != null && page.getPageSize() > 0) {
                query = query + page.sqlLimit();
            }
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                if (title != null) {
                    ps.setString(1, title);
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
                if (page != null && page.getPageSize() > 0) {
                    page.setRecordCount(ServerUtils.foundRows(this.con));
                }
            }
            catch (SQLException e) {
                throw new BGException(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    protected void updateImpl(ContractScriptLog b2) throws BGException, SQLException {
    }

    @Override
    protected ContractScriptLog getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractScriptLog result = new ContractScriptLog();
        result.setCid(rs.getInt("cid"));
        result.setDate(rs.getTimestamp("time"));
        result.setTitle(rs.getString("title"));
        result.setData(rs.getString("data"));
        return result;
    }
}

