/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.task;

import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.LimitChangeTask;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class DebtMailSender
extends TaskBase {
    private int pid = 0;
    private String subject = "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e \u0437\u0430\u0434\u043e\u043b\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u0438";

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u0438\u043a\u0430\u043c.";
    }

    @Override
    protected boolean initTask() {
        boolean result = true;
        this.pid = this.taskSetup.getInt("email.pid", -1);
        if (this.pid <= 0) {
            result = false;
            this.log.error((Object)"Param pid not found!");
        }
        this.subject = this.taskSetup.get("email.subject", this.subject);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(con);){
            ContractManager cm = new ContractManager(conSlave);
            LimitManager moveTaskManager = new LimitManager(conSlave);
            ContractParameterManager cpm = new ContractParameterManager(conSlave);
            List<LimitChangeTask> tasks = moveTaskManager.getFullTaskList();
            for (LimitChangeTask task : tasks) {
                String email;
                Contract contract = cm.getContractById(task.getContractId());
                if (contract == null) {
                    this.log.error((Object)("Contract " + task.getId() + " not found!"));
                }
                BigDecimal limitAfterTaskDo = contract.getBalanceLimit().subtract(task.getDeltaSum());
                BigDecimal balance = bu.getBalance(this.getOperatingTime().getTime(), contract.getId());
                if (balance.compareTo(limitAfterTaskDo) >= 0 || !Utils.isBlankString(email = cpm.getStringParam(contract.getId(), this.pid))) continue;
                ContractEmailParamValue mail = cpm.getEmailParam(contract.getId(), this.pid);
                if (mail != null) {
                    if (Utils.notBlankString(mail.getEmail())) {
                        this.log.info((Object)("Sending " + contract.getTitle() + " on " + email));
                        this.sendEmail(contract, balance, task, mail);
                        continue;
                    }
                    this.log.debug((Object)("Contract " + contract.getTitle() + " not email found"));
                    continue;
                }
                this.log.debug((Object)("Contract " + contract.getTitle() + " not email found"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con, conSlave);
        }
    }

    private void sendEmail(Contract contract, BigDecimal balance, LimitChangeTask task, ContractEmailParamValue email) {
        try {
            Document doc = XMLUtils.newDocument();
            Element data = doc.createElement("data");
            doc.appendChild(data);
            Element contractEl = XMLUtils.createElement(data, "contract");
            contractEl.setAttribute("title", contract.getTitle());
            contractEl.setAttribute("balance", Utils.formatBigDecimalSumm(balance));
            Element taskEl = XMLUtils.createElement(data, "task");
            taskEl.setAttribute("date", TimeUtils.formatDate(task.getDate()));
            XSLManager.getInstance().transformAndSend("debt_mail.xsl", new DOMSource(doc), null, "text/html", null, false, email.getEmail().replaceAll("\n", ";"), this.subject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

