/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.common.bean;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccount;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.common.TimeUtils;

public class BalanceDetailItem
implements Comparable<BalanceDetailItem> {
    public static final int TYPE_PAYMENT = 1;
    public static final int TYPE_CHARGE = 2;
    public static final int TYPE_PAYBACK = 3;
    public static final int TYPE_ACCOUNT = 4;
    public static final int TYPE_RESERVE_CREATE = 5;
    public static final int TYPE_RESERVE_CLOSE = 6;
    public static final int TYPE_START_MONTH = 7;
    public static final int TYPE_END_MONTH = 8;
    private int type = 1;
    private Date date;
    private String title;
    private BigDecimal sum;
    private String comment;
    private String contractTitle;
    private BigDecimal sumAfterChange;

    public BalanceDetailItem() {
    }

    public BalanceDetailItem(int type, Date date, BigDecimal sumAfterChange) {
        this.type = type;
        this.date = date;
        this.sumAfterChange = sumAfterChange;
        this.title = this.getTypeTitle();
    }

    public BalanceDetailItem(Payment payment, String contractTitle, String typeTitle) {
        this.date = payment.getDate();
        this.title = typeTitle;
        this.sum = payment.getSum();
        this.comment = payment.getComment();
        this.contractTitle = contractTitle;
    }

    public BalanceDetailItem(Charge charge, String contractTitle, String typeTitle) {
        this.type = charge.isPayback() ? 3 : 2;
        this.date = charge.getDate();
        this.title = typeTitle;
        this.sum = charge.getSum().negate();
        this.comment = charge.getComment();
        this.contractTitle = contractTitle;
    }

    public BalanceDetailItem(Reserve reserve, int type, String contractTitle, String typeTitle) {
        if (type != 6 && type != 5) {
            return;
        }
        this.type = type;
        this.date = type == 6 ? reserve.getDateClose() : reserve.getPeriod().getDateFrom();
        this.title = typeTitle;
        this.sum = type == 6 ? reserve.getSum() : reserve.getSum().negate();
        this.comment = reserve.getComment();
        this.contractTitle = contractTitle;
    }

    public BalanceDetailItem(ContractAccount account, String contractTitle, String serviceTitle) {
        this.type = 4;
        this.title = serviceTitle;
        this.sum = account.getSum().negate();
        this.contractTitle = contractTitle;
        Calendar dt = TimeUtils.convertDateToCalendar(account.getDate());
        dt.set(5, dt.getActualMaximum(5));
        dt.set(11, 23);
        this.date = dt.getTime();
    }

    @Override
    public int compareTo(BalanceDetailItem o) {
        return this.date.compareTo(o.date);
    }

    public String getTypeTitle() {
        switch (this.type) {
            case 4: {
                return "\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \"" + this.title + "\"";
            }
            case 1: {
                return "\u041f\u0440\u0438\u0445\u043e\u0434 \"" + this.title + "\"";
            }
            case 2: {
                return "\u0420\u0430\u0441\u0445\u043e\u0434 \"" + this.title + "\"";
            }
            case 3: {
                return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \"" + this.title + "\"";
            }
            case 5: {
                return "\u0420\u0435\u0437\u0435\u0440\u0432 \u0441\u043e\u0437\u0434\u0430\u043d \"" + this.title + "\"";
            }
            case 6: {
                return "\u0420\u0435\u0437\u0435\u0440\u0432 \u0437\u0430\u043a\u0440\u044b\u0442 \"" + this.title + "\"";
            }
            case 7: {
                return "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430";
            }
            case 8: {
                return "\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u043a\u043e\u043d\u0435\u0446 \u043c\u0435\u0441\u044f\u0446\u0430";
            }
        }
        return "";
    }

    @XmlAttribute
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlAttribute
    public BigDecimal getSum() {
        return this.sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    public String getContractTitle() {
        return this.contractTitle;
    }

    public void setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
    }

    public void setType(int type) {
        this.type = type;
    }

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    @XmlAttribute
    public BigDecimal getSumAfterChange() {
        return this.sumAfterChange;
    }

    public void setSumAfterChange(BigDecimal sumAfterChange) {
        this.sumAfterChange = sumAfterChange;
    }

    public BigDecimal toSetSumAfterChange(BigDecimal sumBeforChange) {
        if (this.type != 7 && this.type != 8) {
            this.sumAfterChange = sumBeforChange.add(this.sum);
        }
        return this.sumAfterChange;
    }
}

