/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractGroupDao
extends AbstractIdDao<ContractGroup>
implements Directory<ContractGroup> {
    public ContractGroupDao(Connection con) {
        super(con, 0, "contract_group");
    }

    @Override
    protected ContractGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractGroup result = new ContractGroup();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setEnabled(rs.getBoolean("enable"));
        result.setEditable(rs.getBoolean("editable"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    @Override
    protected void updateImpl(ContractGroup b2) throws BGException, SQLException {
        if (b2 == null || b2.getTitle() == null || b2.getId() < 0) {
            throw new BGIllegalArgumentException();
        }
        PreparedStatement ps = this.con.prepareStatement("UPDATE contract_group SET title=?, enable=?, editable=?, comment=? WHERE id=?");
        ps.setString(1, b2.getTitle());
        ps.setInt(2, b2.isEnabled() ? 1 : 0);
        ps.setInt(3, b2.isEditable() ? 1 : 0);
        ps.setString(4, b2.getComment());
        ps.setInt(5, b2.getId());
        boolean updated = ps.executeUpdate() > 0;
        ps.close();
        if (!updated && b2.getId() >= 0 && b2.getId() < 64) {
            ps = this.con.prepareStatement("INSERT INTO contract_group SET title=?, enable=?, editable=?, comment=?, id=?");
            ps.setString(1, b2.getTitle());
            ps.setInt(2, b2.isEnabled() ? 1 : 0);
            ps.setInt(3, b2.isEditable() ? 1 : 0);
            ps.setString(4, b2.getComment());
            ps.setInt(5, b2.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    @Override
    public List<ContractGroup> list() throws BGException {
        List list = super.list(null, null, new Object[0]);
        HashMap<Integer, ContractGroup> map = new HashMap<Integer, ContractGroup>();
        for (ContractGroup contractGroup : list) {
            map.put(contractGroup.getId(), contractGroup);
        }
        list = null;
        ArrayList<ContractGroup> result = new ArrayList<ContractGroup>(64);
        for (int index = 0; index < 63; ++index) {
            ContractGroup contractGroup = (ContractGroup)map.get(index);
            if (contractGroup == null) {
                contractGroup = new ContractGroup();
                contractGroup.setId(index);
                contractGroup.setTitle("\u0413\u0440\u0443\u043f\u043f\u0430 " + String.format("%1$02d", index));
                contractGroup.setEnabled(false);
                contractGroup.setEditable(true);
                contractGroup.setComment("");
            }
            result.add(contractGroup);
        }
        return result;
    }

    public List<ContractGroup> list(boolean all) throws BGException {
        return this.list(all, "id");
    }

    public List<ContractGroup> list(boolean all, String order) throws BGException {
        if (all) {
            return this.list();
        }
        if (order == null) {
            order = "title";
        }
        return super.list("enable=?", order, 1);
    }

    @Override
    public int delete(int id) throws BGException {
        int result = 0;
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr^(1<<?) WHERE (gr&(1<<?))>0");
            ps.setInt(1, id);
            ps.setInt(2, id);
            result = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    @Override
    public ContractGroup get(String title) throws BGException {
        return (ContractGroup)this.get("title=?", title);
    }

    @Override
    public ContractGroup get(int id) throws BGException {
        ContractGroup contractGroup = (ContractGroup)super.get(id);
        if (contractGroup != null) {
            return contractGroup;
        }
        if (id >= 0 && id < 63) {
            contractGroup = new ContractGroup();
            contractGroup.setId(id);
            contractGroup.setTitle("\u0413\u0440\u0443\u043f\u043f\u0430 " + String.format("%1$02d", id));
            contractGroup.setEnabled(false);
            contractGroup.setEditable(true);
            contractGroup.setComment("");
        }
        return contractGroup;
    }
}

