/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public final class ModuleKey {
    protected static final Pattern patternSlash = Pattern.compile("/");
    public final String module;
    public final int moduleId;
    public final String service;
    public final int entityId;

    public ModuleKey(String module, int moduleId, String service) {
        this(module, moduleId, service, 0);
    }

    public ModuleKey(String module, int moduleId, String service, int entityId) {
        this.module = module;
        this.moduleId = moduleId;
        this.service = service;
        this.entityId = entityId;
    }

    public static ModuleKey getModuleKey(String pathInfo) {
        if (pathInfo != null) {
            String[] params = patternSlash.split(pathInfo);
            if (params.length >= 4) {
                String module = params[1];
                int mid = Utils.parseInt(params[2]);
                String service = params[3];
                return new ModuleKey(module, mid, service);
            }
            if (params.length >= 3) {
                String module = params[1];
                String service = params[2];
                return new ModuleKey(module, 0, service);
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + this.moduleId;
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + this.entityId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleKey other = (ModuleKey)obj;
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        if (this.moduleId != other.moduleId) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        return this.entityId == other.entityId;
    }
}

