/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import bitel.billing.server.admin.bgsecure.bean.Group;
import bitel.billing.server.admin.bgsecure.bean.GroupManager;
import bitel.billing.server.admin.bgsecure.bean.GroupPermitionsManager;
import bitel.billing.server.admin.bgsecure.bean.UserGroupManager;
import bitel.billing.server.admin.bgsecure.bean.UserPermitionsManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.GroupRight;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RightType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRule;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleService;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.GroupRightDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserRightRuleDao;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleActionMap;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleInfo;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.directories.domain.common.event.DomainModifiedEvent;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;

public class PermissionChecker {
    private static final Logger logger = Logger.getLogger(PermissionChecker.class);
    private static final char[] CODES = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'};
    private static PermissionChecker instance = null;
    private Setup setup;
    private HashMap<Integer, PermissionEntry> usersPermition = new HashMap(50);
    private HashMap<Integer, PermissionEntry> groupsPermition = new HashMap(25);
    private HashMap<Integer, List<Integer>> usersGroups = new HashMap(25);
    private HashMap<String, String> modules = new HashMap();
    private static final Set<String> parameterActionSet = new HashSet<String>();
    private static final Set<String> objectParameterActionSet;

    private PermissionChecker() {
        this.setup = Setup.getSetup();
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModulesChangedEvent>(){

                @Override
                public void notify(ModulesChangedEvent e, EventListenerContext ctx) throws BGException {
                    PermissionChecker.this.reload();
                }
            }, ModulesChangedEvent.class);
            try (ConnectionSet connectionSet = ConnectionSet.newInstance(this.setup, true);){
                DomainRuntimeMap.getInstance(connectionSet);
            }
            EventProcessor.getInstance().addListener(new EventListener<DomainModifiedEvent>(){

                @Override
                public void notify(DomainModifiedEvent e, EventListenerContext ctx) throws BGException {
                    PermissionChecker.this.reload();
                }
            }, DomainModifiedEvent.class);
        }
        catch (BGException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.doSync();
        this.reload();
    }

    private void doSync() {
        logger.info((Object)"doSync");
        File actionsCatalog = new File("actions");
        if (!actionsCatalog.exists() || !actionsCatalog.isDirectory()) {
            logger.error((Object)"Catalog BGBillingServer/actions not found!");
            return;
        }
        Connection con = this.setup.getDBConnection();
        GroupRightDao groupRightDao = new GroupRightDao(con);
        UserRightRuleDao userRightRuleDao = new UserRightRuleDao(con);
        File kernelActions = new File(actionsCatalog, "kernel.xml");
        try {
            GroupRight groupRight = new GroupRight();
            groupRight.setParentId(0);
            groupRight.setTitle("\u042f\u0434\u0440\u043e");
            groupRight.setModuleId(0);
            groupRight.setType(RightType.SYSTEM);
            groupRightDao.update(groupRight);
            Document doc = XMLUtils.parseDocument(new InputSource(new FileInputStream(kernelActions)));
            for (Element groupElement : XMLUtils.selectElements(doc, "/actions/group")) {
                this.doSyncGroup(groupRight.getId(), 0, groupElement, groupRightDao, userRightRuleDao);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        ModuleManager moduleManager = new ModuleManager(con);
        try {
            for (BGModule module : moduleManager.getModules(null)) {
                File moduleActions = new File(actionsCatalog, module.getName() + ".xml");
                if (!moduleActions.exists()) {
                    logger.error((Object)(moduleActions.getPath() + " - \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!!!"));
                    continue;
                }
                try {
                    GroupRight groupRight = new GroupRight();
                    groupRight.setParentId(0);
                    groupRight.setTitle("\u041c\u043e\u0434\u0443\u043b\u044c " + module.getTitle());
                    groupRight.setModuleId(module.getId());
                    groupRight.setType(RightType.SYSTEM);
                    groupRightDao.update(groupRight);
                    Document doc = XMLUtils.parseDocument(new InputSource(new FileInputStream(moduleActions)));
                    for (Element groupElement : XMLUtils.selectElements(doc, "/actions/group")) {
                        this.doSyncGroup(groupRight.getId(), module.getId(), groupElement, groupRightDao, userRightRuleDao);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void doSyncGroup(int parentId, int moduleId, Element element, GroupRightDao groupRightDao, UserRightRuleDao userRightRuleDao) throws BGException {
        String title = element.getAttribute("title");
        GroupRight groupRight = new GroupRight();
        groupRight.setParentId(parentId);
        groupRight.setTitle(title);
        groupRight.setModuleId(moduleId);
        groupRight.setType(RightType.SYSTEM);
        groupRightDao.update(groupRight);
        for (Element serviceElement : XMLUtils.selectElements(element, "service")) {
            this.doSyncRule(groupRight.getId(), moduleId, serviceElement, userRightRuleDao);
        }
        for (Element actionElement : XMLUtils.selectElements(element, "action")) {
            this.doSyncRule(groupRight.getId(), moduleId, actionElement, userRightRuleDao);
        }
        for (Element groupElement : XMLUtils.selectElements(element, "group")) {
            this.doSyncGroup(groupRight.getId(), moduleId, groupElement, groupRightDao, userRightRuleDao);
        }
    }

    private void doSyncRule(int groupId, int moduleId, Element element, UserRightRuleDao userRightRuleDao) throws BGException {
        ObjectMapper mapper = new ObjectMapper();
        UserRightRule userRightRule = new UserRightRule();
        userRightRule.setModuleId(moduleId);
        userRightRule.setRightGroupId(groupId);
        userRightRule.setTitle(element.getAttribute("title"));
        try {
            if ("service".equals(element.getNodeName())) {
                UserRightRuleService rightRuleService = new UserRightRuleService();
                rightRuleService.setName(element.getAttribute("name"));
                rightRuleService.setOperation(element.getAttribute("operation"));
                userRightRule.setRule(mapper.writeValueAsString((Object)rightRuleService));
            } else if ("action".equals(element.getNodeName())) {
                UserRightRuleAction rightRuleAction = new UserRightRuleAction();
                rightRuleAction.setMask(element.getAttribute("mask"));
                userRightRule.setRule(mapper.writeValueAsString((Object)rightRuleAction));
            }
            userRightRuleDao.update(userRightRule);
        }
        catch (JsonProcessingException e) {
            logger.error((Object)e);
        }
    }

    public static boolean isAdmin(int userId) {
        return userId == 1;
    }

    public static final PermissionChecker getInstance() {
        if (instance == null) {
            instance = new PermissionChecker();
        }
        return instance;
    }

    public static final PermissionEntry getUserPermition(int userId) {
        return PermissionChecker.getInstance().usersPermition.get(userId);
    }

    synchronized void reload() {
        logger.info((Object)"Reload permissions..");
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.loadUserActions(con);
            this.loadModules(con);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void loadModules(Connection con) {
        try {
            this.modules.clear();
            this.modules.put("0", "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, title FROM module");
            while (rs.next()) {
                this.modules.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
            st.close();
            for (BGPluginBase bGPluginBase : BGPluginManagerServer.getManager().getPluginsMap().values()) {
                if (!(bGPluginBase instanceof BGPluginServer)) continue;
                this.modules.put("p" + ((BGPluginServer)bGPluginBase).getPluginUID(), "\u041f\u043b\u0430\u0433\u0438\u043d " + bGPluginBase.getName());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void loadUserActions(Connection con) throws BGException {
        HashMap<Integer, PermissionEntry> usersPermition = new HashMap<Integer, PermissionEntry>(50);
        HashMap<Integer, PermissionEntry> groupsPermition = new HashMap<Integer, PermissionEntry>(25);
        HashMap<Integer, List<Integer>> usersGroups = new HashMap<Integer, List<Integer>>(25);
        GroupManager groupManager = new GroupManager(con);
        List<Group> groupList = groupManager.getGroupList();
        GroupPermitionsManager gpm = new GroupPermitionsManager(con);
        UserPermitionsManager upm = new UserPermitionsManager(con);
        UserGroupManager userGroupManager = new UserGroupManager(con);
        for (Group group : groupList) {
            List<BGSAction> groupActions = gpm.getGroupActions(group.getId());
            HashSet<String> groupActionsMarkers = new HashSet<String>(groupActions.size());
            for (BGSAction action : groupActions) {
                groupActionsMarkers.add(action.mid + "_" + action.actionID);
            }
            groupsPermition.put(group.getId(), new PermissionEntry(0, groupActionsMarkers, group.getContractGroups(), group.getContractGroupsMode(), group.getRuleAccessContractParameter(), group.getRuleAccessObjectParameter(), null, null));
        }
        UserManager userManager = new UserManager(con);
        List<User> userList = userManager.list();
        userManager.close();
        DomainRuntimeMap domainRuntimeMap = DomainRuntimeMap.getInstance(con);
        for (User user : userList) {
            List<BGSAction> userActions = upm.getUserActions(user.getId());
            HashSet<String> userActionsMarkers = new HashSet<String>(userActions.size());
            for (BGSAction action : userActions) {
                userActionsMarkers.add(action.mid + "_" + action.actionID);
            }
            int pid = user.getContractPid();
            int cid = user.getContractCid();
            ParamEntry paramEntry = pid > 0 && cid > 0 ? new ParamEntry(pid, cid) : null;
            Set<Integer> domainIds = domainRuntimeMap.getAllDescendantDomainIds(user.getDomainIds());
            usersPermition.put(user.getId(), new PermissionEntry(user.getId(), userActionsMarkers, user.getContractGroups(), user.getContractGroupsMode(), user.getRuleAccessContractParameter(), user.getRuleAccessObjectParameter(), paramEntry, domainIds));
            usersGroups.put(user.getId(), userGroupManager.getUserGroups(user.getId()));
        }
        this.usersPermition = usersPermition;
        this.usersGroups = usersGroups;
        this.groupsPermition = groupsPermition;
    }

    private boolean isContractDisallow(Connection con, int cid, int pid, int val) {
        try {
            PreparedStatement ps = con.prepareStatement("SELECT cid FROM contract_parameter_type_8 WHERE cid=? AND pid=? AND val=?");
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ps.setInt(3, val);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                rs.close();
                ps.close();
                return false;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public ModuleAction findAction(String[] moduleId, String service, String operation, Map<String, Object> args) throws BGIllegalAccessException {
        ModuleAction moduleAction;
        ModuleActionMap actionMap = ModuleActionMap.getInstance();
        ModuleActionMap.Module module = actionMap.getModule(moduleId[0]);
        if (module != null) {
            moduleAction = module.moduleInfo.findAction(service, operation, args);
            if (moduleAction == null && !"0".equals(moduleId[0]) && (moduleAction = actionMap.getKernel().moduleInfo.findAction(service, operation, args)) == null) {
                for (ModuleInfo otherModule : actionMap.getModuleInfoMap().values()) {
                    if (otherModule.findAction(service, operation, args) == null) continue;
                    throw new BGIllegalAccessException("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439: \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f \"" + this.modules.get(moduleId[0]) + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
                }
            }
        } else {
            moduleAction = actionMap.getKernel().moduleInfo.findAction(service, operation, args);
            if (moduleAction == null) {
                throw new BGIllegalAccessException("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439: \u043c\u043e\u0434\u0443\u043b\u044c c \u043a\u043e\u0434\u043e\u043c mid=" + moduleId[0] + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            }
            moduleId[0] = "0";
        }
        return moduleAction;
    }

    public ModuleAction findAction(String[] moduleId, Map<String, String> requestMap) throws BGIllegalAccessException {
        ModuleAction moduleAction;
        ModuleActionMap actionMap = ModuleActionMap.getInstance();
        ModuleActionMap.Module module = actionMap.getModule(moduleId[0]);
        if (module != null) {
            moduleAction = module.moduleInfo.findAction(requestMap);
            if (moduleAction == null && !"0".equals(moduleId[0])) {
                moduleAction = actionMap.getKernel().moduleInfo.findAction(requestMap);
                if (moduleAction == null) {
                    for (ModuleInfo otherModule : actionMap.getModuleInfoMap().values()) {
                        if (otherModule.findAction(requestMap) == null) continue;
                        throw new BGIllegalAccessException("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439: \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f \"" + this.modules.get(moduleId[0]) + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
                    }
                } else {
                    moduleId[0] = "0";
                }
            }
        } else {
            assert (!"0".equals(moduleId[0]));
            moduleAction = actionMap.getKernel().moduleInfo.findAction(requestMap);
            if (moduleAction == null) {
                throw new BGIllegalAccessException("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439: \u043c\u043e\u0434\u0443\u043b\u044c c \u043a\u043e\u0434\u043e\u043c mid=" + moduleId[0] + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            }
            moduleId[0] = "0";
        }
        return moduleAction;
    }

    public ModuleAction findAction(String[] moduleId, HttpServletRequest request) throws BGIllegalAccessException {
        return this.findAction(moduleId, this.getRequestMap(request));
    }

    public void checkActionAllow(int userId, String moduleId, ModuleAction moduleAction, String service, String operation, int cid, Map<String, Object> params) throws BGIllegalAccessException {
        if (PermissionChecker.isAdmin(userId)) {
            return;
        }
        if (moduleAction == null) {
            logger.debug((Object)("Action " + service + ":" + operation + " not found in dictionary for module " + moduleId));
            return;
        }
        int pid = 0;
        if ("contractParameterUpdate".equals(operation) && "ContractService".equals(service)) {
            EntityAttr parameter = (EntityAttr)params.get("parameter");
            if (parameter != null) {
                pid = parameter.getEntitySpecAttrId();
            }
        } else {
            Object pidObj = params.get("pid");
            if (pidObj != null && pidObj instanceof Integer) {
                pid = (Integer)pidObj;
            }
        }
        this.checkActionAllow(userId, moduleId, moduleAction, service, operation, cid, pid, 0);
    }

    public String checkActionAllow(HttpServletRequest req, String moduleId, ModuleAction moduleAction, int userId, int cid) {
        return this.checkActionAllow(this.getRequestMap(req), moduleId, moduleAction, userId, cid);
    }

    public String checkActionAllow(Map<String, String> requestMap, String moduleId, ModuleAction moduleAction, int userId, int cid) {
        if (PermissionChecker.isAdmin(userId)) {
            return null;
        }
        if (moduleAction == null) {
            logger.debug((Object)("Action " + requestMap.get("action") + " not found in dictionary for module " + moduleId));
            return null;
        }
        try {
            String action = requestMap.get("action");
            int pid = Utils.parseInt(requestMap.get("pid"), -1);
            int opid = Utils.parseInt(requestMap.get("param"), -1);
            this.checkActionAllow(userId, moduleId, moduleAction, action, null, cid, pid, opid);
        }
        catch (BGIllegalAccessException ex) {
            return ex.getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkActionAllow(int userId, String moduleId, ModuleAction moduleAction, String service, String operation, int cid, int pid, int opid) throws BGIllegalAccessException {
        Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();
        try {
            String action = moduleId + "_" + moduleAction.id;
            boolean allow = false;
            boolean parameterAllowed = false;
            PermissionEntry userPermition = PermissionChecker.getUserPermition(userId);
            if (userPermition == null) {
                throw new BGIllegalAccessException("PermissionEntry == null for userId=" + userId);
            }
            List<PermissionEntry> groupPermissions = userPermition.getGroupsPermissions();
            ArrayList<PermissionEntry> permissions = new ArrayList<PermissionEntry>(groupPermissions);
            permissions.add(userPermition);
            for (PermissionEntry entry : permissions) {
                if (!entry.actions.contains(action)) continue;
                allow = true;
                break;
            }
            if (!allow) {
                throw new BGIllegalAccessException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \"" + this.modules.get(moduleId) + ": " + moduleAction.title + "\" \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
            }
            if (cid > 0 && !this.checkContractPerimission(con, cid, permissions, userPermition)) {
                throw new BGIllegalAccessException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c!");
            }
            if (pid > 0 && (parameterActionSet.contains(service) || "contractParameterUpdate".equals(operation) && "ContractService".equals(service)) && !(parameterAllowed = PermissionChecker.checkWriteContractParameter(userPermition, pid))) {
                throw new BGIllegalAccessException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
            }
            if (objectParameterActionSet.contains(service) && opid > 0) {
                int write = PermissionChecker.getWriteRule(userPermition.opids, opid);
                if (write == 0) {
                    write = this.setup.getInt("object.parameter.rule.write.user", 3);
                }
                if (write == 1) {
                    parameterAllowed = true;
                } else if (write == 2) {
                    parameterAllowed = false;
                } else {
                    write = 0;
                    for (PermissionEntry entry : groupPermissions) {
                        write = PermissionChecker.getWriteRule(entry.opids, opid);
                        if (write <= 0) continue;
                        break;
                    }
                    if (write == 0) {
                        write = this.setup.getInt("object.parameter.rule.write.group", 1);
                    }
                    boolean bl = parameterAllowed = write != 2;
                }
                if (!parameterAllowed) {
                    throw new BGIllegalAccessException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                }
            }
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private boolean checkContractPerimission(Connection con, int contractId, List<PermissionEntry> permissions, PermissionEntry userPermition) throws BGIllegalAccessException {
        ContractRuntime contractRuntime;
        long now = System.currentTimeMillis();
        if (userPermition.lastAllowedContractIdTime > now - 15000L && userPermition.lastAllowedContractId == contractId) {
            return true;
        }
        try {
            contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(con, (Integer)contractId);
        }
        catch (BGException e) {
            throw new BGIllegalAccessException(e);
        }
        if (contractRuntime != null) {
            boolean contractAllowed = false;
            long contractGroups = contractRuntime.getContractGroups();
            for (PermissionEntry entry : permissions) {
                if (!(entry.contractGroups == 0L && entry.contractGroupsMode > 0 && contractGroups == 0L || entry.contractGroups == 0L && entry.contractGroupsMode == 0) && !(entry.contractGroups != 0L && entry.contractGroupsMode > 0 ? (contractGroups & entry.contractGroups) == entry.contractGroups : (contractGroups & entry.contractGroups) > 0L)) continue;
                contractAllowed = true;
                break;
            }
            if (!contractAllowed) {
                return false;
            }
            Set<Integer> domainIds = userPermition.getDomainIds();
            if (domainIds != null && domainIds.size() > 0 && !domainIds.contains(contractRuntime.getDomainId())) {
                return false;
            }
        }
        if (userPermition.pairEntry != null && this.isContractDisallow(con, contractId, userPermition.pairEntry.pid, userPermition.pairEntry.cid)) {
            return false;
        }
        userPermition.lastAllowedContractId = contractId;
        userPermition.lastAllowedContractIdTime = now;
        return true;
    }

    public static int getWriteRule(List<String> rules, int pid) {
        int result = 0;
        block0: for (String rule : rules) {
            int rulePid = Utils.parseInt(rule.substring(0, rule.length() - 1));
            if (rulePid != pid) continue;
            char code = rule.charAt(rule.length() - 1);
            for (int index = 0; index < CODES.length; ++index) {
                if (CODES[index] != code) continue;
                result = index & 3;
                break block0;
            }
        }
        return result;
    }

    public static int getReadRule(List<String> rules, int pid) {
        int result = 0;
        block0: for (String rule : rules) {
            int rulePid = Utils.parseInt(rule.substring(0, rule.length() - 1));
            if (rulePid != pid) continue;
            char code = rule.charAt(rule.length() - 1);
            for (int index = 0; index < CODES.length; ++index) {
                if (CODES[index] != code) continue;
                result = (index & 0xC) >> 2;
                break block0;
            }
        }
        return result;
    }

    public static List<PermissionEntry> getGroupsPermissions(int userId) {
        ArrayList<PermissionEntry> result = new ArrayList<PermissionEntry>();
        List<Integer> groupIds = PermissionChecker.instance.usersGroups.get(userId);
        if (groupIds != null) {
            for (Integer groupId : groupIds) {
                PermissionEntry permissionEntry = PermissionChecker.instance.groupsPermition.get(groupId);
                if (permissionEntry == null) continue;
                result.add(permissionEntry);
            }
        }
        return result;
    }

    public static boolean checkReadObjectParameter(int parameterId, int userId) {
        boolean parameterAllowed = true;
        PermissionChecker.getInstance();
        PermissionEntry userPermition = PermissionChecker.getUserPermition(userId);
        List<PermissionEntry> groupPermissions = userPermition.getGroupsPermissions();
        int read = PermissionChecker.getReadRule(userPermition.opids, parameterId);
        if (read == 0) {
            read = Setup.getSetup().getInt("object.parameter.rule.read.user", 3);
        }
        if (read == 1) {
            parameterAllowed = true;
        } else if (read == 2) {
            parameterAllowed = false;
        } else {
            read = 0;
            for (PermissionEntry permissionEntry : groupPermissions) {
                read = PermissionChecker.getReadRule(permissionEntry.opids, parameterId);
                if (read <= 0) continue;
                break;
            }
            if (read == 0) {
                read = Setup.getSetup().getInt("object.parameter.rule.read.group", 1);
            }
            parameterAllowed = read != 2;
        }
        return parameterAllowed;
    }

    public static boolean checkReadContractParameter(int parameterId, int userId) {
        if (userId == 0 || userId == 1) {
            return true;
        }
        PermissionEntry userPermition = PermissionChecker.getUserPermition(userId);
        return PermissionChecker.checkReadContractParameter(userPermition, parameterId);
    }

    public static boolean checkReadContractParameter(PermissionEntry userPermition, int parameterId) {
        Boolean result = userPermition.parameterReadRules.get(parameterId);
        if (result != null) {
            return result;
        }
        boolean parameterAllowed = true;
        List<PermissionEntry> groupPermissions = userPermition.getGroupsPermissions();
        int read = PermissionChecker.getReadRule(userPermition.pids, parameterId);
        if (read == 0) {
            read = Setup.getSetup().getInt("contract.parameter.rule.read.user", 3);
        }
        if (read == 1) {
            parameterAllowed = true;
        } else if (read == 2) {
            parameterAllowed = false;
        } else {
            read = 0;
            for (PermissionEntry permissionEntry : groupPermissions) {
                read = PermissionChecker.getReadRule(permissionEntry.pids, parameterId);
                if (read <= 0) continue;
                break;
            }
            if (read == 0) {
                read = Setup.getSetup().getInt("contract.parameter.rule.read.group", 1);
            }
            parameterAllowed = read != 2;
        }
        userPermition.parameterReadRules.put(parameterId, parameterAllowed);
        return parameterAllowed;
    }

    private Map<String, String> getRequestMap(HttpServletRequest httpServletRequest) {
        Map parameterMap = httpServletRequest.getParameterMap();
        HashMap<String, String> sParameterMap = new HashMap<String, String>();
        for (String s : parameterMap.keySet()) {
            sParameterMap.put(s, ((String[])parameterMap.get(s))[0]);
        }
        return sParameterMap;
    }

    public static boolean checkWriteContractParameter(PermissionEntry userPermition, int parameterId) {
        Boolean result = userPermition.parameterWriteRules.get(parameterId);
        if (result != null) {
            return result;
        }
        boolean parameterAllowed = false;
        List<PermissionEntry> groupPermissions = userPermition.getGroupsPermissions();
        int write = PermissionChecker.getWriteRule(userPermition.pids, parameterId);
        if (write == 0) {
            write = Setup.getSetup().getInt("contract.parameter.rule.write.user", 3);
        }
        if (write == 1) {
            parameterAllowed = true;
        } else if (write == 2) {
            parameterAllowed = false;
        } else {
            write = 0;
            for (PermissionEntry entry : groupPermissions) {
                write = PermissionChecker.getWriteRule(entry.pids, parameterId);
                if (write <= 0) continue;
                break;
            }
            if (write == 0) {
                write = Setup.getSetup().getInt("contract.parameter.rule.write.group", 1);
            }
            parameterAllowed = write != 2;
        }
        userPermition.parameterWriteRules.put(parameterId, parameterAllowed);
        return parameterAllowed;
    }

    static {
        parameterActionSet.add("UpdateParameterType1");
        parameterActionSet.add("UpdateAddressInfo");
        parameterActionSet.add("UpdateEmailInfo");
        parameterActionSet.add("UpdateServiceInfo");
        parameterActionSet.add("UpdateParameterType5");
        parameterActionSet.add("UpdateParameterType6");
        parameterActionSet.add("UpdateListParam");
        parameterActionSet.add("UpdateMultiListParam");
        parameterActionSet.add("UpdateParameterType8");
        objectParameterActionSet = new HashSet<String>();
        objectParameterActionSet.add("AddressParamValueUpdate");
        objectParameterActionSet.add("DateParamValueUpdate");
        objectParameterActionSet.add("FlagParamValueUpdate");
        objectParameterActionSet.add("ListParamValueUpdate");
        objectParameterActionSet.add("TextParamValueUpdate");
    }

    public final class PermissionEntry {
        final int userId;
        public final Set<String> actions;
        public final long contractGroups;
        public final int contractGroupsMode;
        private final Set<Integer> domainIds;
        private final String domainIdsString;
        public final List<String> pids;
        public final List<String> opids;
        public final ParamEntry pairEntry;
        public volatile int lastAllowedContractId;
        public volatile long lastAllowedContractIdTime;
        final Map<Integer, Boolean> parameterReadRules = Collections.synchronizedMap(new HashMap());
        final Map<Integer, Boolean> parameterWriteRules = Collections.synchronizedMap(new HashMap());
        volatile List<PermissionEntry> groupsPermissions = null;

        public PermissionEntry(int userId, Set<String> actions, long contractGroups, int contractGroupsMode, List<String> pids, List<String> opids, ParamEntry pairEntry, Set<Integer> domainIds) {
            this.userId = userId;
            this.actions = actions;
            this.contractGroups = contractGroups;
            this.contractGroupsMode = contractGroupsMode;
            this.pids = pids;
            this.opids = opids;
            this.pairEntry = pairEntry;
            this.domainIds = domainIds;
            this.domainIdsString = domainIds != null ? Utils.toString(domainIds) : null;
        }

        public Set<Integer> getDomainIds() {
            return this.domainIds;
        }

        public String getDomainIdsString() {
            return this.domainIdsString;
        }

        public List<PermissionEntry> getGroupsPermissions() {
            if (this.userId > 0) {
                List<PermissionEntry> groupsPermissions = this.groupsPermissions;
                if (groupsPermissions != null) {
                    return groupsPermissions;
                }
                this.groupsPermissions = groupsPermissions = PermissionChecker.getGroupsPermissions(this.userId);
                return groupsPermissions;
            }
            assert (false) : "Can't get group permissions from group";
            return Collections.emptyList();
        }
    }

    public final class ParamEntry {
        public final int pid;
        public final int cid;

        public ParamEntry(int pid, int cid) {
            this.pid = pid;
            this.cid = cid;
        }
    }
}

