/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.HttpAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleInfo;
import ru.bitel.bgbilling.kernel.container.security.server.ServiceAction;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.xml.NodeNamespaceResolver;

public class ModuleActionMap {
    private static final Logger logger = Logger.getLogger(ModuleActionMap.class);
    private Map<String, ModuleInfo> moduleInfoMap = this.loadModulesActions();
    private volatile Module kernelModule;
    private volatile Map<String, Module> moduleMap;
    private volatile List<Module> moduleList;

    ModuleActionMap() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModulesChangedEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notify(ModulesChangedEvent e, EventListenerContext ctx) throws BGException {
                    if (e.isNeedReloadActionsXml()) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            ModuleActionMap.this.moduleInfoMap.clear();
                            ModuleActionMap.this.moduleInfoMap = ModuleActionMap.this.loadModulesActions();
                        }
                    }
                    ModuleActionMap.this.reload();
                }
            }, ModulesChangedEvent.class);
        }
        catch (BGException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.reload();
    }

    public static ModuleActionMap getInstance() {
        return InstanceHolder.instance;
    }

    Module getModule(String moduleId) {
        return this.moduleMap.get(moduleId);
    }

    Module getKernel() {
        return this.kernelModule;
    }

    List<Module> getModuleList() {
        return this.moduleList;
    }

    Map<String, ModuleInfo> getModuleInfoMap() {
        return this.moduleInfoMap;
    }

    public ModuleAction getModuleAction(String moduleId, int id) {
        Module module = this.moduleMap.get(moduleId);
        if (module == null) {
            return null;
        }
        return module.moduleInfo.moduleActionMap.get(id);
    }

    public ModuleAction getModuleAction(String mid, int id, String[] moduleTitle) {
        Module module = this.moduleMap.get(mid);
        if (module == null) {
            return null;
        }
        moduleTitle[0] = module.title;
        return module.moduleInfo.moduleActionMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reload() {
        logger.info((Object)"Load modules");
        Setup setup = Setup.getSetup();
        Connection con = setup.getDBConnectionFromPool();
        try {
            this.moduleMap = this.loadModules(con);
            this.kernelModule = this.moduleMap.get("0");
            this.moduleList = new ArrayList<Module>(this.moduleMap.values());
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private Map<String, ModuleInfo> loadModulesActions() {
        HashMap<String, ModuleInfo> result = new HashMap<String, ModuleInfo>();
        try {
            this.loadModulesActions0(result);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private void loadModulesActions0(Map<String, ModuleInfo> moduleMap) throws IOException {
        logger.info((Object)"Load module actions");
        File actionsCatalog = new File("actions");
        if (!actionsCatalog.exists() || !actionsCatalog.isDirectory()) {
            logger.error((Object)"Catalog BGBillingServer/actions not found!");
            return;
        }
        for (File file : actionsCatalog.listFiles()) {
            String moduleName;
            if (file.isDirectory() || !(moduleName = file.getName()).endsWith(".xml")) continue;
            int pos = moduleName.lastIndexOf(".");
            if (pos >= 0) {
                moduleName = moduleName.substring(0, pos);
            }
            Document doc = XMLUtils.parseDocument(new InputSource(new FileInputStream(file)));
            HashMap<Integer, ModuleAction> moduleActionMap = new HashMap<Integer, ModuleAction>();
            ArrayList<HttpAction> webActionList = new ArrayList<HttpAction>();
            HashMap<String, List<ServiceAction>> serviceActionMap = new HashMap<String, List<ServiceAction>>();
            for (Element description : XMLUtils.selectElements(doc, "//action")) {
                try {
                    HttpAction action = new HttpAction(description);
                    moduleActionMap.put(action.getId(), action);
                    webActionList.add(action);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (Element description : XMLUtils.selectElements(doc, "//service")) {
                try {
                    NodeNamespaceResolver namespaceContext = new NodeNamespaceResolver(description);
                    ServiceAction action = new ServiceAction(namespaceContext, description);
                    moduleActionMap.put(action.getId(), action);
                    ArrayList<ServiceAction> list = (ArrayList<ServiceAction>)serviceActionMap.get(action.name);
                    if (list == null) {
                        list = new ArrayList<ServiceAction>();
                        serviceActionMap.put(action.name, list);
                    }
                    list.add(action);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            moduleMap.put(moduleName, new ModuleInfo(moduleActionMap, webActionList, serviceActionMap));
        }
    }

    private Map<String, Module> loadModules(Connection con) {
        HashMap<String, Module> result = new HashMap<String, Module>();
        ModuleManager mm = new ModuleManager(con);
        for (Map.Entry<String, ModuleInfo> e : this.moduleInfoMap.entrySet()) {
            String moduleName = e.getKey();
            ModuleInfo moduleInfo = e.getValue();
            if ("kernel".equals(moduleName)) {
                result.put("0", new Module("\u042f\u0434\u0440\u043e", moduleInfo));
                continue;
            }
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(moduleName);
            if (plugin != null) {
                result.put("p" + plugin.getPluginUID(), new Module(plugin.getName(), moduleInfo));
                continue;
            }
            try {
                for (BGModule module : mm.getModules(moduleName)) {
                    result.put(String.valueOf(module.getId()), new Module(module.getTitle(), moduleInfo));
                }
            }
            catch (BGException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    static class InstanceHolder {
        static ModuleActionMap instance = new ModuleActionMap();

        InstanceHolder() {
        }
    }

    final class Module {
        final String title;
        final ModuleInfo moduleInfo;

        public Module(String title, ModuleInfo moduleInfo) {
            this.title = title;
            this.moduleInfo = moduleInfo;
        }
    }
}

