/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleActionMap;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;

public class BGSQueryLogDao {
    public static String getTableName(Date date) {
        return ServerUtils.getMonthTableName("bgs_query_log", date);
    }

    public static void log(Connection con, BGSQueryLogEntry entry, Date date) throws BGException {
        try {
            String query;
            String table = BGSQueryLogDao.getTableName(date);
            if (!ServerUtils.tableExists(con, table)) {
                query = "CREATE TABLE " + table + "(id INT AUTO_INCREMENT NOT NULL, dtime DATETIME NOT NULL default '0000-00-00 00:00:00', uid INT NOT NULL, ip CHAR(40) NOT NULL, cid INT NOT NULL, mid_aid VARCHAR(100) NOT NULL, query TEXT NOT NULL, PRIMARY KEY id(id), KEY cid(cid), KEY dtime(dtime), KEY mid_aid(mid_aid), KEY uid(uid) )";
                Setup.getSetup().checkAndCreatePeriodicTableName(con, table, query);
            }
            query = "INSERT INTO " + table + " SET dtime=NOW(), uid=?, ip=?, cid=?, query=?, mid_aid=?";
            PreparedStatement psInsert = con.prepareStatement(query);
            int parameterIndex = 1;
            psInsert.setInt(parameterIndex++, entry.getUserId());
            psInsert.setString(parameterIndex++, entry.getRemoteAddr());
            psInsert.setInt(parameterIndex++, entry.getContractId());
            psInsert.setString(parameterIndex++, entry.getQueryString());
            psInsert.setString(parameterIndex++, entry.getModuleId() + "_" + entry.getActionId());
            psInsert.executeUpdate();
            psInsert.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public static List<BGSQueryLogEntry> getLogTable(ConnectionSet connectionSet, Period period, int userId, String contractIds, String actionList, String parameter, String parameterValue, boolean isRegexp, Page page) throws BGException {
        ArrayList<BGSQueryLogEntry> result = new ArrayList<BGSQueryLogEntry>();
        String tableName = BGSQueryLogDao.getTableName(period.getDateFrom());
        if (ServerUtils.tableExists(connectionSet.getConnection(), tableName)) {
            Connection trashCon = connectionSet.getTrashConnection(tableName, 2);
            try {
                StringBuffer filterString = new StringBuffer(400);
                filterString.append(" WHERE dtime>='");
                filterString.append(TimeUtils.formatSQLDate(period.getDateFrom()));
                filterString.append("' AND dtime<'");
                filterString.append(TimeUtils.formatSQLDate(TimeUtils.getNextDay(TimeUtils.convertDateToCalendar(period.getDateTo()))));
                filterString.append("' ");
                if (userId > 0 || userId == -1) {
                    filterString.append(" AND uid=");
                    filterString.append(userId);
                }
                if (Utils.notEmptyString(contractIds)) {
                    filterString.append(" AND cid IN ( ");
                    filterString.append(contractIds);
                    filterString.append(" ) ");
                }
                if (Utils.notEmptyString(actionList)) {
                    filterString.append(" AND mid_aid IN ( '");
                    filterString.append(actionList.replaceAll(",", "','"));
                    filterString.append("' ) ");
                }
                if (Utils.notEmptyString(parameter)) {
                    if (!isRegexp) {
                        parameter = parameter.replaceAll("%", "[^\n]*").replace("_", ".");
                        parameterValue = parameterValue.replaceAll("%", "[^\n]*").replace("_", ".");
                    }
                    filterString.append(" AND (query REGEXP '");
                    filterString.append(parameter + " => " + parameterValue + "\n'");
                    filterString.append(" OR query REGEXP '");
                    filterString.append(parameter + " => .*" + parameterValue + ".*\n'");
                    filterString.append(" OR query REGEXP '");
                    filterString.append("<" + parameter + ".*>" + parameterValue + "</" + parameter + ">'");
                    filterString.append(" OR query REGEXP '");
                    filterString.append(parameter + "=\\\"" + parameterValue + "\\\"'");
                    filterString.append(")");
                }
                String query = "SELECT SQL_CALC_FOUND_ROWS q.*, c.title AS contractTitle, u.name AS userName FROM " + tableName + " AS q LEFT JOIN contract AS c ON c.id=q.cid LEFT JOIN user AS u ON u.id=q.uid " + filterString + " ORDER BY dtime LIMIT ?, ?";
                PreparedStatement ps = trashCon.prepareStatement(query.toString(), 1);
                ps.setInt(1, page.getPageFirstRecordNumber());
                ps.setInt(2, page.getPageSize());
                ResultSet rs = ps.executeQuery();
                page.setRecordCount(ServerUtils.foundRows(trashCon));
                String[] moduleTitle = new String[1];
                ModuleActionMap actionMap = ModuleActionMap.getInstance();
                while (rs.next()) {
                    BGSQueryLogEntry log;
                    ModuleAction action = actionMap.getModuleAction((log = BGSQueryLogDao.getFromRs(rs)).getModuleId(), log.getActionId(), moduleTitle);
                    log.setActionTitle(action != null ? action.getTitle() : "???");
                    result.add(log);
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        return result;
    }

    private static BGSQueryLogEntry getFromRs(ResultSet rs) throws SQLException {
        BGSQueryLogEntry entry = new BGSQueryLogEntry();
        entry.setDate(rs.getTimestamp("dtime"));
        entry.setUserName(Utils.maskBlank(rs.getString("userName"), "???"));
        entry.setRemoteAddr(rs.getString("ip"));
        entry.setContractTitle(Utils.maskBlank(rs.getString("contractTitle"), ""));
        entry.setQueryString(rs.getString("query"));
        entry.setUserId(rs.getInt("uid"));
        entry.setContractId(rs.getInt("cid"));
        BGSQueryLogDao.setModuleAndAction(entry, rs);
        return entry;
    }

    private static void setModuleAndAction(BGSQueryLogEntry entry, ResultSet rs) throws SQLException {
        String module = "";
        String midAid = rs.getString("mid_aid");
        String[] split = midAid.split("_");
        String id = split[0];
        String actionId = split[1];
        if (id.equals("0")) {
            module = "\u042f\u0434\u0440\u043e";
        } else if (id.startsWith("p")) {
            int pluginUID = Utils.parseInt(midAid.substring(1));
            String pluginName = "(" + pluginUID + ")";
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPluginByUID(pluginUID);
            if (plugin != null) {
                pluginName = plugin.getName();
            }
            module = "\u041f\u043b\u0430\u0433\u0438\u043d " + pluginName;
        } else {
            int moduleId = Utils.parseInt(id);
            BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
            module = Utils.maskBlank(bgModule.getName(), "???");
        }
        entry.setModuleId(id);
        entry.setActionId(Utils.parseInt(actionId));
        entry.setModuleName(module);
    }
}

