/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.webmenu.server.service;

import bitel.billing.server.bean.MenuItem;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuModuleItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.service.WebMenuService;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.Module;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.webmenu.common.service.WebMenuService")
public class WebMenuServiceImpl
extends AbstractService
implements WebMenuService {
    @Override
    public List<WebMenuItem> webMenuList(boolean loadCount) throws BGException {
        WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());
        List<WebMenuItem> list = webMenuDao.list();
        webMenuDao.recycle();
        Map<Integer, Integer> countMap = webMenuDao.getContractCount();
        Iterator<WebMenuItem> iterator = list.iterator();
        while (iterator.hasNext()) {
            WebMenuItem webMenuItem;
            Integer count = countMap.get((webMenuItem = iterator.next()).getId());
            webMenuItem.setCount(count == null ? 0 : count);
        }
        return list;
    }

    @Override
    public List<WebMenuItem> webMenuContractList(int contractId) throws BGException {
        ArrayList<WebMenuItem> list = new ArrayList<WebMenuItem>();
        WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());
        int webMenuId = webMenuDao.getWebMenuIdForContract(contractId);
        for (WebMenuItem webMenuItem : webMenuDao.list()) {
            webMenuItem.setSelected(webMenuId == webMenuItem.getId());
            list.add(webMenuItem);
        }
        WebMenuItem webMenuItem = new WebMenuItem();
        webMenuItem.setId(-1);
        webMenuItem.setSelected(webMenuId == -1);
        webMenuItem.setTitle("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        list.add(0, webMenuItem);
        webMenuDao.recycle();
        return list;
    }

    @Override
    public WebMenuItem webMenuInfoUpdate(WebMenuItem webMenuItem) throws BGException {
        return new WebMenuDao(this.getConnection()).updateInfo(webMenuItem);
    }

    @Override
    public WebMenuItem webMenuInfoGet(int webMenuItemId) throws BGException {
        return (WebMenuItem)new WebMenuDao(this.getConnection()).get(webMenuItemId);
    }

    @Override
    public void setWebMenuIdForContract(int webMenuItemId, int contractId) throws BGException {
        WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());
        webMenuDao.setWebMenuIdForContract(webMenuItemId, contractId);
        webMenuDao.recycle();
    }

    @Override
    public void webMenuDataUpdate(int webMenuItemId, String webMenuItemData) throws BGException {
        new WebMenuDao(this.getConnection()).updateData(webMenuItemId, webMenuItemData);
    }

    @Override
    public String webMenuDataGet(int webMenuItemId) throws BGException {
        return new WebMenuDao(this.getConnection()).getData(webMenuItemId);
    }

    @Override
    public void webMenuDataDelete(int webMenuItemId) throws BGException {
        new WebMenuDao(this.getConnection()).deleteData(webMenuItemId);
    }

    @Override
    public WebMenuModuleItem[] webMenuModuleItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        Connection con = this.getConnection();
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            try {
                String packServer = module.getInstalledModule().getPackageServer();
                Class<?> result = Class.forName(packServer + ".Module");
                Class<WebMenuBase> menuBaseClass = result.asSubclass(WebMenuBase.class);
                WebMenuBase menuBase = menuBaseClass.newInstance();
                for (MenuItem menuItem : menuBase.getWebMenuItems(con, module.getName(), module.getId(), true)) {
                    WebMenuModuleItem item = new WebMenuModuleItem();
                    item.setModuleId(module.getId());
                    item.setModuleName(module.getName());
                    item.setModuleTitle(module.getTitle());
                    item.setAction(menuItem.getAction());
                    item.setTitle(menuItem.getTitle());
                    list.add(item);
                }
            }
            catch (Exception exception) {
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public WebMenuModuleItem[] webMenuKernelItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        BGInstalledModule kernel = new BGInstalledModule();
        kernel.setType("module");
        kernel.setPackageServer(Module.class.getPackage().getName());
        kernel.setName("contract");
        Element extension = kernel.getServerExtensionMap().get(WebMenu.class.getName());
        if (extension != null) {
            for (Element itemElement : XMLUtils.selectElements(extension, "item")) {
                WebMenuModuleItem item = new WebMenuModuleItem();
                item.setModuleId(0);
                item.setModuleName("contract");
                item.setModuleTitle("\u042f\u0434\u0440\u043e");
                item.setAction(itemElement.getAttribute("action"));
                item.setTitle(itemElement.getAttribute("titleDefault"));
                list.add(item);
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public WebMenuModuleItem[] webMenuPluginItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions(WebMenu.class.getName(), false)) {
            if (extension == null) continue;
            for (Element itemElement : XMLUtils.selectElements(extension.getElement(), "item")) {
                WebMenuModuleItem item = new WebMenuModuleItem();
                item.setModuleId(0);
                item.setModuleName(extension.getPlugin().getId());
                item.setModuleTitle(extension.getPlugin().getName());
                item.setAction(itemElement.getAttribute("action"));
                item.setTitle(itemElement.getAttribute("titleDefault"));
                list.add(item);
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }
}

