/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.server.errorlog;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DefaultAlarmTask;
import ru.bitel.common.Utils;

public class MQCheckTask
extends DefaultAlarmTask {
    private static final Logger logger = Logger.getLogger(MQCheckTask.class);
    private long checkActiveMQMillis = 0L;
    private long[] previousTotalMessageCount = new long[5];
    private int errorCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTask() {
        long millis = System.currentTimeMillis();
        if (millis - this.checkActiveMQMillis < TimeUnit.SECONDS.toMillis(180L)) {
            return;
        }
        this.checkActiveMQMillis = millis;
        JMXConnector connector = null;
        try {
            String url = this.setup.get("mq.jmx.url", "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi");
            String brokerName = this.setup.get("mq.jmx.brokerName", "activeMQ");
            connector = JMXConnectorFactory.connect(new JMXServiceURL(url));
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            ObjectName brokerObjectName = new ObjectName("org.apache.activemq:type=Broker,brokerName=" + brokerName);
            double memoryPercentUsage = Utils.parseDouble(String.valueOf(connection.getAttribute(brokerObjectName, "MemoryPercentUsage")), -1.0);
            double tempPercentUsage = Utils.parseDouble(String.valueOf(connection.getAttribute(brokerObjectName, "TempPercentUsage")), -1.0);
            double storePercentUsage = Utils.parseDouble(String.valueOf(connection.getAttribute(brokerObjectName, "StorePercentUsage")), -1.0);
            long totalMessageCount = Utils.parseLong(String.valueOf(connection.getAttribute(brokerObjectName, "TotalMessageCount")), -1L);
            boolean needAlarm = false;
            long defaultInterval = 900000L;
            if (this.previousTotalMessageCount[4] > 10000L && totalMessageCount > this.previousTotalMessageCount[0] && this.previousTotalMessageCount[0] >= this.previousTotalMessageCount[1] && this.previousTotalMessageCount[1] >= this.previousTotalMessageCount[2] && this.previousTotalMessageCount[2] >= this.previousTotalMessageCount[3] && this.previousTotalMessageCount[3] >= this.previousTotalMessageCount[4]) {
                logger.warn((Object)("ActiveMQ totalMessageCount=" + totalMessageCount + ". Check message processing."));
                needAlarm = true;
            }
            this.previousTotalMessageCount[4] = this.previousTotalMessageCount[3];
            this.previousTotalMessageCount[3] = this.previousTotalMessageCount[2];
            this.previousTotalMessageCount[2] = this.previousTotalMessageCount[1];
            this.previousTotalMessageCount[1] = this.previousTotalMessageCount[0];
            this.previousTotalMessageCount[0] = totalMessageCount;
            if (memoryPercentUsage > 35.0 || tempPercentUsage > 35.0 || storePercentUsage > 35.0) {
                if (memoryPercentUsage > 50.0 || tempPercentUsage > 50.0 || storePercentUsage > 50.0) {
                    defaultInterval = 180000L;
                    if (memoryPercentUsage > 75.0 || tempPercentUsage > 75.0 || storePercentUsage > 75.0) {
                        logger.error((Object)"ActiveMQ store/temp/memory limit is almost out! Check message processing!");
                    } else {
                        logger.warn((Object)"ActiveMQ store/temp/memory limit is >=50%! Check message processing.");
                    }
                } else {
                    logger.warn((Object)"ActiveMQ store/temp/memory limit is >=35%! Check message processing.");
                }
                needAlarm = true;
            }
            if (needAlarm) {
                String key = "system.mq.server.load";
                String msg = "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ActiveMQ (\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043d\u0435 \u0443\u0441\u043f\u0435\u0432\u0430\u044e\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c\u0441\u044f \u0438\u043b\u0438 \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e\u0441\u044f). \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u043b-\u0432\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044f\u0445 (Queues) \u0447\u0435\u0440\u0435\u0437 web-\u043a\u043e\u043d\u0441\u043e\u043b\u044c, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u0439.";
                if (AlarmSender.needAlarmSend(key, millis, defaultInterval)) {
                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c ActiveMQ", msg), millis);
                }
            }
        }
        catch (Exception ex) {
            this.checkActiveMQMillis = millis + TimeUnit.MINUTES.toMillis(10L);
            if (this.errorCount == 0) {
                logger.debug((Object)("Error check activeMQ with JMX: " + ex.getMessage()));
            }
            ++this.errorCount;
            if (this.errorCount > 18) {
                this.errorCount = 0;
            }
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (Exception e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

