/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.news.server.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.news.common.bean.News;
import ru.bitel.bgbilling.kernel.admin.news.common.event.NewsModifiedEvent;
import ru.bitel.bgbilling.kernel.admin.news.common.service.NewsService;
import ru.bitel.bgbilling.kernel.admin.news.server.bean.NewsManager;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.common.model.Page;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.news.common.service.NewsService")
public class NewsServiceImpl
extends AbstractService
implements NewsService {
    private NewsManager newsManager;

    @PostConstruct
    void init() {
        this.newsManager = new NewsManager(this.getConnection());
    }

    @Override
    public int newsUpdate(News news) throws BGException {
        this.newsManager.update(news);
        this.context.publishAfterCommit(new NewsModifiedEvent(this.userId, 0));
        return news.getId();
    }

    @Override
    public List<News> newsList(Page page) throws BGException {
        return this.newsManager.list(page);
    }

    @Override
    public List<News> newsListForContract(long groups) throws BGException {
        return NewsManager.getNewsList(this.context.getSetup(), groups);
    }

    @Override
    public void newsDelete(int id) throws BGException {
        this.newsManager.delete(id);
        this.context.publishAfterCommit(new NewsModifiedEvent(this.userId, 0));
    }
}

