/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.telnet.old;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TelnetInputStream
extends FilterInputStream {
    private Object lock = new Object();
    public static final int IAC = 255;
    public static final int SE = 240;
    public static final int NOP = 241;
    public static final int DM = 242;
    public static final int BREAK = 243;
    public static final int IP = 244;
    public static final int AO = 245;
    public static final int AYT = 246;
    public static final int EC = 247;
    public static final int EL = 248;
    public static final int GA = 249;
    public static final int SB = 250;
    public static final int WILL = 251;
    public static final int WONT = 252;
    public static final int DO = 253;
    public static final int DONT = 254;
    private static final String[] cmdNames = new String[]{"IAC", "DONT", "DO", "WONT", "WILL", "SB", "GA", "EL", "EC", "AYT", "AO", "IP", "BREAK", "DM", "NOP", "SE"};
    private long cmdCount = 0L;
    private List<TelnetCommand> cmdList = new LinkedList<TelnetCommand>();
    private Set<TelnetCommandListener> commandListeners = new HashSet<TelnetCommandListener>();
    private PrintStream debugStream;

    public TelnetInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return -1;
        }
        if (c == 255) {
            int c1 = this.in.read();
            if (c1 == -1) {
                throw new IOException("Unterminated IAC telnet sequence");
            }
            switch (c1) {
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: {
                    this.commandFound(new TelnetCommand(this.cmdCount, c1));
                    break;
                }
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    int c2 = this.in.read();
                    if (c2 == -1) {
                        throw new IOException("Unterminated telnet option command sequence for command " + TelnetInputStream.getCommandName(c1) + "(" + c1 + ")");
                    }
                    this.commandFound(new TelnetCommand(this.cmdCount, c1, c2));
                    break;
                }
                default: {
                    throw new IOException("Unrecognized telnet command int: " + c1);
                }
            }
            ++this.cmdCount;
            return this.read();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandFound(TelnetCommand command) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.debugStream != null) {
                this.debugStream.println(command);
            }
            this.cmdList.add(command);
            Iterator<TelnetCommandListener> i = this.commandListeners.iterator();
            while (i.hasNext()) {
                i.next().telnetCommandReceived(this, command);
            }
        }
    }

    public TelnetCommand[] getCommands() {
        TelnetCommand[] cmds = new TelnetCommand[this.cmdList.size()];
        this.cmdList.toArray(cmds);
        return cmds;
    }

    public void commandHandled(TelnetCommand command) {
        if (command.getTIS() != this) {
            throw new RuntimeException("The command " + command + " is not been issued over this TelnetInputStream");
        }
        this.cmdList.remove(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTelnetCommandListener(TelnetCommandListener tcl) {
        Object object = this.lock;
        synchronized (object) {
            this.commandListeners.add(tcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTelnetCommandListener(TelnetCommandListener tcl) {
        Object object = this.lock;
        synchronized (object) {
            this.commandListeners.remove(tcl);
        }
    }

    private static final String getCommandName(int telnetCommandCode) {
        if (telnetCommandCode > 255 || telnetCommandCode < 240) {
            throw new IllegalArgumentException("Invalid command code " + telnetCommandCode + " - range is 240-255 inclusive");
        }
        return cmdNames[255 - telnetCommandCode];
    }

    public PrintStream getDebugStream() {
        return this.debugStream;
    }

    public void setDebugStream(PrintStream debugStream) {
        this.debugStream = debugStream;
    }

    public class TelnetCommand {
        private int code;
        private int option;
        private long sequenceNumber;

        TelnetCommand(long sequenceNumber, int code, int option) {
            this.code = code;
            this.option = option;
            this.sequenceNumber = sequenceNumber;
        }

        TelnetCommand(long sequenceNumber, int code) {
            this(sequenceNumber, code, -1);
        }

        public boolean hasOptionCode() {
            return this.option != -1;
        }

        public int getOptionCode() {
            if (!this.hasOptionCode()) {
                throw new IllegalStateException("The command " + TelnetInputStream.getCommandName(this.code) + " has not option code");
            }
            return this.option;
        }

        public int getCommandCode() {
            return this.code;
        }

        public String getCommandName() {
            return TelnetInputStream.getCommandName(this.code);
        }

        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String toString() {
            return this.getCommandName() + " " + (this.hasOptionCode() ? "" + this.getOptionCode() : "") + " (seq# " + this.sequenceNumber + ")";
        }

        TelnetInputStream getTIS() {
            return TelnetInputStream.this;
        }
    }

    public static interface TelnetCommandListener {
        public void telnetCommandReceived(TelnetInputStream var1, TelnetCommand var2) throws IOException;
    }

    public static class BasicNVTListener
    implements TelnetCommandListener {
        protected OutputStream os;

        public BasicNVTListener(OutputStream os) {
            this.os = os;
        }

        @Override
        public void telnetCommandReceived(TelnetInputStream is, TelnetCommand command) throws IOException {
            if (command.getCommandCode() == 253) {
                this.os.write(255);
                this.os.write(252);
                this.os.write(command.getOptionCode());
                this.os.flush();
            } else if (command.getCommandCode() == 251) {
                this.os.write(255);
                this.os.write(254);
                this.os.write(command.getOptionCode());
                this.os.flush();
            }
            is.commandHandled(command);
        }
    }
}

