/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.bean;

import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TableManager {
    private Connection con;
    private int mid;
    private String prefix;
    private static final Map<Integer, String> prefixMap = new HashMap<Integer, String>(8);

    public static final String getPrefix(Connection con, int mid) {
        String result = prefixMap.get(mid);
        if (result == null) {
            BGModule module = ModuleCache.getInstance().getModule(mid);
            if (module != null) {
                result = module.getName().equals("phone") ? "phone_" : (module.getName().equals("voiceip") ? "voiceip_" : "");
                prefixMap.put(mid, result);
            } else {
                result = "";
                System.err.println("ZoneUtils: unknown module is null " + mid);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getTable(Connection con, int mid, String table) {
        String result = prefixMap.get(mid);
        if (result == null) {
            Map<Integer, String> map = prefixMap;
            synchronized (map) {
                BGModule module = ModuleCache.getInstance().getModule(mid);
                if (module != null) {
                    result = module.getName().equals("phone") ? "phone_" : (module.getName().equals("voiceip") ? "voiceip_" : "");
                    prefixMap.put(mid, result);
                } else {
                    result = "";
                    System.err.println("ZoneUtils: unknown module is null " + mid);
                }
            }
        }
        return result + table + mid;
    }

    public TableManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.prefix = TableManager.getPrefix(con, mid);
    }

    public void createZoneTables() {
        try {
            String query = null;
            Statement st = this.con.createStatement();
            query = "CREATE TABLE IF NOT EXISTS " + this.prefix + "tariff_zone_" + this.mid + "(id int(11) NOT NULL auto_increment,title varchar(100) NOT NULL default '',PRIMARY KEY  (id) )";
            st.executeUpdate(query);
            query = "CREATE TABLE IF NOT EXISTS " + this.prefix + "geographic_code_" + this.mid + "(code varchar(20) NOT NULL,dest_id int(11) NOT NULL,start_level TINYINT NOT NULL,end_level TINYINT NOT NULL,PRIMARY KEY  (code) )";
            st.executeUpdate(query);
            query = "CREATE TABLE IF NOT EXISTS " + this.prefix + "zone_map_" + this.mid + "(id int(11) NOT NULL auto_increment,title varchar(200) NOT NULL,PRIMARY KEY (id) )";
            st.executeUpdate(query);
            query = "CREATE TABLE IF NOT EXISTS " + this.prefix + "zone_map_item_" + this.mid + "(map_id int(11) NOT NULL,code varchar(20) NOT NULL,zone_id int(11) NOT NULL,UNIQUE KEY map_code (map_id,code),KEY zone_id (zone_id) )";
            st.executeUpdate(query);
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteZoneTables() {
        try {
            ServerUtils.dropExistTable(this.con, this.prefix + "tariff_zone_" + this.mid);
            ServerUtils.dropExistTable(this.con, this.prefix + "geographic_code_" + this.mid);
            ServerUtils.dropExistTable(this.con, this.prefix + "zone_map_" + this.mid);
            ServerUtils.dropExistTable(this.con, this.prefix + "zone_map_item_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

