/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.util.HashSet;
import java.util.Map;
import ru.bitel.common.Utils;

public class ZoneTrafficRangeTariffTreeNode
extends DefaultTariffTreeNode {
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private int zone;
    private int mode;
    private int from;
    private int to;
    private int type;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        this.zone = Utils.parseInt(dataHash.get("zone"));
        this.mode = Utils.parseInt(dataHash.get("mode"));
        this.from = Utils.parseInt(dataHash.get("from"));
        this.to = Utils.parseInt(dataHash.get("to"));
        this.type = Utils.parseInt(dataHash.get("type"), 0);
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        if (action == null || !action.equals("init")) {
            if (action != null && action.equals("reset")) {
                HashSet<Integer> zoneSet = (HashSet<Integer>)request.getResponseParam("zone_set");
                if (zoneSet == null) {
                    zoneSet = new HashSet<Integer>();
                    request.setResponseParam("zone_set", zoneSet);
                }
                zoneSet.add(this.zone);
                request.addHistoryMsg("ZoneCostRangeTariffTreeNode=> zone=" + this.zone + "\n");
            } else {
                Integer trafficValue = null;
                trafficValue = this.type == 2 ? (Integer)request.getRequestParam("zone_traf_in_" + this.zone) : (this.type == 1 ? (Integer)request.getRequestParam("zone_traf_out_" + this.zone) : (Integer)request.getRequestParam("zone_traf_" + this.zone));
                request.addHistoryMsg("ZoneTrafficRangeTariffTreeNode=> zone=" + this.zone + " | trafficValue=" + trafficValue);
                if (trafficValue != null) {
                    trafficValue = trafficValue / 60;
                }
                int from = this.from;
                int to = this.to;
                if (this.mode == 0) {
                    Float part = (Float)request.getRequestParam("part");
                    if (part == null) {
                        part = Float.valueOf(1.0f);
                    }
                    from = (int)((float)from * part.floatValue());
                    to = (int)((float)to * part.floatValue());
                }
                request.addHistoryMsg(" |from=" + from + " | to=" + to);
                if (!(request.wasAccepted() || trafficValue == null || trafficValue < from || to != 0 && trafficValue > to)) {
                    request.addHistoryMsg(" processForChilds...");
                    this.processForChilds(request);
                }
                request.addHistoryMsg("\n");
            }
        }
    }
}

