/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import bitel.billing.server.tariff.voice.calc.ZoneDestFindRequest;
import bitel.billing.server.tariff.voice.calc.ZoneDestFinder;
import java.util.Map;
import ru.bitel.common.Utils;

public class ZoneMapTariffTreeNode
extends DefaultTariffTreeNode {
    private int mapId;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        this.mapId = Utils.parseInt(dataHash.get("map_id"));
    }

    @Override
    public void processRequest(TariffRequest request) {
        String phone = (String)request.getRequestParam("phone");
        ZoneDestFinder zdf = (ZoneDestFinder)request.getRequestParam("zdf");
        if (Utils.notBlankString(phone) && zdf != null) {
            ZoneDestFindRequest req = new ZoneDestFindRequest();
            req.mapId = this.mapId;
            req.number = phone;
            zdf.find(req);
            request.setRequestParam("zone_dest_find_request", req);
            if (req.destId > 0) {
                request.setResponseParam("dest", req.destId);
            }
            if (req.zoneId > 0) {
                request.setResponseParam("zone", req.zoneId);
            }
        }
    }
}

