/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius.auth.eap.tls;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractTLSTunnel {
    protected static byte[] LABEL_KEYING_MATERIAL_TLS = AbstractTLSTunnel.getBytes("client EAP encryption");

    public abstract State handshake() throws IOException;

    public abstract void updatePacketBuffer(byte[] var1);

    private static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.ISO_8859_1);
    }

    public abstract byte[] getKeyMaterial();

    public static byte[] getKeyMaterial(byte[] label, byte[] masterSecret, byte[] serverRandom, byte[] clientRandom) throws NoSuchAlgorithmException {
        byte[] seed = new byte[clientRandom.length + serverRandom.length];
        System.arraycopy(clientRandom, 0, seed, 0, clientRandom.length);
        System.arraycopy(serverRandom, 0, seed, clientRandom.length, serverRandom.length);
        byte[] prfA = AbstractTLSTunnel.PRF(masterSecret, label, seed, 128);
        byte[] prfB = AbstractTLSTunnel.PRF(new byte[0], label, seed, 64);
        byte[] key = new byte[192];
        System.arraycopy(prfA, 0, key, 0, 128);
        System.arraycopy(prfB, 0, key, 128, 64);
        return key;
    }

    private static byte[] expandMacKey(byte[] key) {
        if (key.length < 64) {
            byte[] t = new byte[64];
            System.arraycopy(key, 0, t, 0, key.length);
            key = t;
        }
        return key;
    }

    public static byte[] PRF(byte[] secret, byte[] label, byte[] seed, int length) throws NoSuchAlgorithmException {
        byte[] digest;
        Mac mac;
        SecretKeySpec key;
        int i;
        int sLen = (secret.length + 1) / 2;
        byte[] s1 = new byte[sLen];
        byte[] s2 = new byte[sLen];
        System.arraycopy(secret, 0, s1, 0, sLen);
        System.arraycopy(secret, secret.length - sLen, s2, 0, sLen);
        byte[] labelSeed = new byte[seed.length + label.length];
        System.arraycopy(label, 0, labelSeed, 0, label.length);
        System.arraycopy(seed, 0, labelSeed, label.length, seed.length);
        byte[] result = new byte[length];
        byte[] A2 = labelSeed;
        byte[] MAC_KEY_MATERIAL = AbstractTLSTunnel.expandMacKey(s1);
        for (i = 0; i < length; i += 16) {
            key = new SecretKeySpec(MAC_KEY_MATERIAL, "HmacMD5");
            mac = Mac.getInstance("HmacMD5");
            try {
                mac.init(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mac.update(A2, 0, A2.length);
            A2 = mac.doFinal();
            key = new SecretKeySpec(MAC_KEY_MATERIAL, "HmacMD5");
            mac = Mac.getInstance("HmacMD5");
            try {
                mac.init(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mac.update(A2, 0, A2.length);
            mac.update(labelSeed, 0, labelSeed.length);
            digest = mac.doFinal();
            System.arraycopy(digest, 0, result, i, Math.min(16, length - i));
        }
        MAC_KEY_MATERIAL = AbstractTLSTunnel.expandMacKey(s2);
        A2 = labelSeed;
        for (i = 0; i < length; i += 20) {
            key = new SecretKeySpec(MAC_KEY_MATERIAL, "HmacSHA1");
            mac = Mac.getInstance("HmacSHA1");
            try {
                mac.init(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mac.update(A2, 0, A2.length);
            A2 = mac.doFinal();
            key = new SecretKeySpec(MAC_KEY_MATERIAL, "HmacSHA1");
            mac = Mac.getInstance("HmacSHA1");
            try {
                mac.init(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mac.update(A2, 0, A2.length);
            mac.update(labelSeed, 0, labelSeed.length);
            digest = mac.doFinal();
            assert (digest.length == 20);
            int limit = Math.min(20, length - i);
            for (int j = 0; j < limit; ++j) {
                int n = i + j;
                result[n] = (byte)(result[n] ^ digest[j]);
            }
        }
        return result;
    }

    public static enum State {
        none,
        handshaking,
        established,
        handshake_error;

    }
}

