/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.processor.LC_CheckingLogin;
import bitel.billing.server.processor.LoginError;
import bitel.billing.server.radius.RadiusSetup;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class LC_LimitChecker {
    protected RadiusSetup setup = null;
    protected ConcurrentMap<Integer, LC_CheckingLogin> registredLogins = new ConcurrentHashMap<Integer, LC_CheckingLogin>();

    public void init(RadiusSetup setup) {
        this.setup = setup;
    }

    public LC_CheckingLogin registerLogin(Login login, Connection con) {
        Integer loginId = login.getId();
        LC_CheckingLogin checkingLogin = this.createCheckingLogin(login, this.setup, con);
        int connectionCount = this.getLoginSessionsCount(loginId);
        checkingLogin.setConnectionsCount(connectionCount);
        this.registredLogins.put(loginId, checkingLogin);
        return checkingLogin;
    }

    public void unregisterLogin(int lid) {
        int connectionCount;
        Integer loginKey = new Integer(lid);
        LC_CheckingLogin checkingLogin = (LC_CheckingLogin)this.registredLogins.get(loginKey);
        if (checkingLogin != null && (connectionCount = this.getLoginSessionsCount(lid)) == 0) {
            this.registredLogins.remove(loginKey, checkingLogin);
        }
    }

    protected abstract int getLoginSessionsCount(int var1);

    public Hashtable<String, Object> getRests(Hashtable<String, Object> params, int lid, int sid, boolean subst) {
        Hashtable<String, Object> result = null;
        LC_CheckingLogin checkingLogin = this.getCheckingLogin(lid);
        if (checkingLogin != null) {
            result = checkingLogin.getRests(params, sid, subst);
        }
        return result;
    }

    public LoginError canComeIn(Connection con, Hashtable<String, Object> params, Login login) {
        LC_CheckingLogin checkingLogin = this.registerLogin(login, con);
        LoginError error = null;
        if (checkingLogin != null) {
            error = checkingLogin.canLoginComeIn(con, params);
        }
        return error;
    }

    protected LC_CheckingLogin getCheckingLogin(int lid) {
        return (LC_CheckingLogin)this.registredLogins.get(lid);
    }

    protected LC_CheckingLogin createCheckingLogin(Login login, RadiusSetup setup, Connection con) {
        return new LC_CheckingLogin(login, setup, con);
    }

    public Vector<Object> limitServiceAndMoney(int lid, int sid, Long needService, Float needMoney, Calendar time, float tariff) {
        Vector<Object> returnVect = new Vector<Object>();
        long serviceAmount = needService;
        float summa = needMoney.floatValue();
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("need_service", needService);
        params.put("need_money", needMoney);
        params.put("time", time.clone());
        Hashtable<String, Object> result = this.getRests(params, lid, sid, false);
        if (result != null) {
            float summa_limit = 0.0f;
            long service_limit = 0L;
            Float money = (Float)result.get("money");
            Long service = (Long)result.get("service");
            if (money != null && service != null) {
                service_limit = service;
                summa_limit = money.floatValue();
                float delta_money = summa - summa_limit;
                long delta_service = serviceAmount - service_limit;
                if (delta_service > 0L && ((float)delta_service * tariff > delta_money || tariff == 0.0f)) {
                    serviceAmount -= delta_service;
                } else if (delta_money > 0.0f) {
                    serviceAmount = (int)((summa - delta_money) / tariff);
                }
                summa = (float)serviceAmount * tariff;
            }
        }
        returnVect.add(0, new Long(serviceAmount));
        returnVect.add(1, new Float(summa));
        return returnVect;
    }

    public boolean hasConditions(int lid) {
        boolean result = false;
        LC_CheckingLogin checkingLogin = this.getCheckingLogin(lid);
        if (checkingLogin != null) {
            result = checkingLogin.hasConditions();
        }
        return result;
    }

    public void substFromLimits(int lid, int sid, Calendar time, long serviceAmount, float summa) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("need_service", new Long(serviceAmount));
        params.put("need_money", new Float(summa));
        params.put("time", time.clone());
        this.getRests(params, lid, sid, true);
    }

    public String getStatus() {
        StringBuffer result = new StringBuffer("LC_LimitChecker logins:");
        result.append(this.registredLogins.size());
        return result.toString();
    }
}

