/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer.library;

import bitel.billing.server.installer.event.GetLibrariesInfoEvent;
import bitel.billing.server.installer.event.GetLibraryEvent;
import bitel.billing.server.installer.library.LibraryInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class LibraryUpdate {
    public static final String LIB_APP_DIR = "lib/app";
    public static final String LIB_APP_UPDATE_DIR = "lib.app.update";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<LibraryInfo> getLibrariesInfo() throws Exception {
        ArrayList<LibraryInfo> result = new ArrayList<LibraryInfo>();
        File dir = new File(LIB_APP_DIR);
        for (File file : dir.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream is = new FileInputStream(file);){
                is = new DigestInputStream(is, md);
                Utils.readByBlock(is);
            }
            String digest = Utils.bytesToHexString(md.digest());
            result.add(new LibraryInfo(file.getName(), file.length(), digest));
        }
        return result;
    }

    public static final byte[] getLibraryData(String libName) throws Exception {
        File file = new File(LIB_APP_DIR + File.separator + libName);
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = Utils.readByBlock(is);
            return byArray;
        }
    }

    public static final List<LibraryInfo> getLibrariesForUpdate() throws Exception {
        ArrayList<LibraryInfo> result = new ArrayList<LibraryInfo>();
        GetLibrariesInfoEvent event = new GetLibrariesInfoEvent();
        try {
            event = EventProcessor.getInstance().request(event, 10000L);
        }
        catch (Exception e) {
            System.err.println("Error requesting BGBillingServer. Check BGBillingServer and system time.");
            throw e;
        }
        HashMap<String, LibraryInfo> localLibMap = new HashMap<String, LibraryInfo>();
        for (LibraryInfo info : LibraryUpdate.getLibrariesInfo()) {
            localLibMap.put(info.getName(), info);
        }
        for (LibraryInfo info : event.getLibList()) {
            LibraryInfo localLib = (LibraryInfo)localLibMap.remove(info.getName());
            if (localLib != null && info.equals(localLib)) continue;
            result.add(info);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            System.out.println("Starting libraries update. Requesting BGBillingServer lib info.");
            Setup.setSetup(new Setup(System.getProperty("setup.name")));
            List<LibraryInfo> libsForUpdate = LibraryUpdate.getLibrariesForUpdate();
            for (LibraryInfo info : libsForUpdate) {
                System.out.println("Taking " + info.getName() + "...");
                GetLibraryEvent getLibEvent = new GetLibraryEvent(info.getName());
                getLibEvent = EventProcessor.getInstance().request(getLibEvent);
                System.out.println("OK. Saving to \"lib.app.update\".");
                try {
                    File dir = new File(LIB_APP_UPDATE_DIR);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                FileOutputStream fos = new FileOutputStream(LIB_APP_UPDATE_DIR + File.separator + info.getName());
                fos.write(getLibEvent.getData());
                fos.close();
            }
            if (libsForUpdate.size() > 0) {
                System.out.println("Update finished. Please restart application.");
            } else {
                System.out.println("Local libraries already synchronized with BGBillingServer.");
            }
            System.in.read();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

